/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import nl.b3p.brmo.loader.entity.BrkBericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.xml.BrkSnapshotXMLReader;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BRKScannerProces;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BRKDirectoryScanner
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BRKDirectoryScanner.class);
    private final BRKScannerProces config;
    private ProgressUpdateListener listener;

    public BRKDirectoryScanner(BRKScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        StringBuilder sb = new StringBuilder("\n" + this.config.getLogfile());
        String msg = String.format("De BRK scanner met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        log.info((Object)msg);
        listener.addLog(msg);
        sb.append(msg);
        File scanDirectory = new File(this.config.getScanDirectory());
        if (!scanDirectory.isDirectory() || !scanDirectory.canExecute()) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            msg = String.format("De scan directory '%s' is geen executable directory", scanDirectory);
            this.config.setLogfile(msg);
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.listener.exception((Throwable)new BrmoException(msg));
            return;
        }
        String aDir = this.config.getArchiefDirectory();
        File archiefDirectory = null;
        if (aDir != null) {
            archiefDirectory = new File(aDir);
            archiefDirectory.mkdirs();
            if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                archiefDirectory = null;
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                msg = String.format("De archief directory '%s' is geen beschrijfbare directory, er worden geen bestanden gearchiveerd.", archiefDirectory);
                sb.append(msg);
                this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                log.error((Object)msg);
                this.listener.exception((Throwable)new BrmoException(msg));
            }
            if (!scanDirectory.canWrite()) {
                archiefDirectory = null;
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                msg = String.format("De scan directory '%s' is geen beschrijfbare directory, er worden geen bestanden gearchiveerd.", scanDirectory);
                sb.append(msg);
                this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                log.error((Object)msg);
                this.listener.exception((Throwable)new BrmoException(msg));
            }
        }
        this.config.setLogfile(sb.toString());
        File[] files = scanDirectory.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
        this.processXMLFiles(files, scanDirectory, archiefDirectory);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private void processXMLFiles(File[] files, File scanDirectory, File archiefDirectory) {
        String msg;
        StringBuilder sb = new StringBuilder("\n" + this.config.getLogfile());
        int filterAlVerwerkt = 0;
        int aantalGeladen = 0;
        int progress = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        int commitPageSize = 1000;
        this.listener.total((long)files.length);
        for (File f : files) {
            if (f.isDirectory()) continue;
            msg = String.format("Bestand %s is gevonden in %s.", f, scanDirectory);
            log.info((Object)msg);
            this.listener.addLog(msg);
            sb.append("\n").append(msg).append("\n");
            if (this.isDuplicaatLaadProces(f, "brk")) {
                msg = String.format("  Bestand %s is een duplicaat en wordt overgeslagen.", f);
                this.listener.addLog(msg);
                log.info((Object)msg);
                sb.append(msg).append("\n");
                ++filterAlVerwerkt;
            } else {
                try {
                    LaadProces lp = new LaadProces();
                    lp.setBestand_naam(this.getBestandsNaam(f));
                    lp.setSoort("brk");
                    lp.setStatus(LaadProces.STATUS.STAGING_OK);
                    lp.setOpmerking(String.format("Bestand geladen van %s op %s", f.getAbsolutePath(), sdf.format(new Date())));
                    lp.setAutomatischProces((AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.config.getId()));
                    Bericht b = new Bericht();
                    b.setLaadprocesid(lp);
                    b.setDatum(lp.getBestand_datum());
                    b.setSoort("brk");
                    b.setStatus_datum(new Date());
                    String fileContent = FileUtils.readFileToString((File)f, (String)"UTF-8");
                    fileContent = fileContent.replaceAll("\u0000.*", "");
                    b.setBr_orgineel_xml(fileContent);
                    try {
                        BrkSnapshotXMLReader reader = new BrkSnapshotXMLReader((InputStream)new ByteArrayInputStream(b.getBr_orgineel_xml().getBytes("UTF-8")));
                        BrkBericht bericht = reader.next();
                        if (bericht.getDatum() != null) {
                            b.setDatum(bericht.getDatum());
                        }
                        b.setBr_xml(bericht.getBrXml());
                        b.setVolgordenummer(bericht.getVolgordeNummer());
                        String objectRef = bericht.getObjectRef();
                        if (objectRef != null && !objectRef.isEmpty()) {
                            b.setObject_ref(bericht.getObjectRef());
                            b.setStatus(Bericht.STATUS.STAGING_OK);
                            b.setOpmerking("Klaar voor verwerking.");
                        } else {
                            b.setStatus(Bericht.STATUS.STAGING_NOK);
                            b.setOpmerking("Object Ref niet gevonden in bericht-xml, neem contact op met leverancier.");
                        }
                    }
                    catch (Exception e) {
                        b.setStatus(Bericht.STATUS.STAGING_NOK);
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        msg = String.format("Fout bij parsen BRK bericht (bestand %s): %s ", f, sw.toString());
                        b.setOpmerking(msg);
                        log.warn((Object)msg);
                    }
                    Stripersist.getEntityManager().persist((Object)lp);
                    Stripersist.getEntityManager().persist((Object)b);
                    Stripersist.getEntityManager().merge((Object)this.config);
                    ++aantalGeladen;
                    msg = String.format("  Bestand %s is geladen en heeft status: %s. (Leverde bericht id: %s, met status: %s.)", f, lp.getStatus(), b.getId(), b.getStatus());
                    log.info((Object)msg);
                    this.listener.addLog(msg);
                    sb.append(msg).append("\n");
                    if (aantalGeladen % 1000 == 0) {
                        log.debug((Object)"Tussentijds opslaan van berichten, 'commitPageSize' is bereikt");
                        Stripersist.getEntityManager().flush();
                        Stripersist.getEntityManager().getTransaction().commit();
                        Stripersist.getEntityManager().clear();
                    }
                }
                catch (IOException io) {
                    log.error((Object)io.getLocalizedMessage());
                    sb.append(io.getLocalizedMessage()).append("\n");
                    this.listener.exception((Throwable)io);
                }
            }
            this.listener.progress((long)(++progress));
            if (archiefDirectory == null) continue;
            f.renameTo(new File(archiefDirectory, f.getName()));
            msg = String.format("  Bestand %s is naar archief %s verplaatst.", f, archiefDirectory);
            log.info((Object)msg);
            this.listener.addLog(msg);
            sb.append(msg).append("\n");
        }
        msg = String.format("Klaar met run op %tc", Calendar.getInstance());
        log.info((Object)msg);
        this.listener.updateStatus(msg);
        this.listener.addLog(msg);
        sb.append(msg);
        this.listener.addLog("\n\n**** resultaat ****");
        this.listener.addLog("\nAantal bestanden die al waren geladen: " + filterAlVerwerkt);
        this.listener.addLog("\nAantal bestanden geladen: " + aantalGeladen + "\n");
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLogfile(sb.toString());
        this.config.setLastrun(new Date());
        this.config.updateSamenvattingEnLogfile("Aantal bestanden die al waren verwerkt: " + filterAlVerwerkt + "\n" + "Aantal bestanden geladen: " + aantalGeladen + "\n");
        Stripersist.getEntityManager().merge((Object)this.config);
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

