/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.MailRapportageProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class MailRapportage
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(MailRapportage.class);
    private MailRapportageProces config;

    public MailRapportage(MailRapportageProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.active = true;
        StringBuilder sb = new StringBuilder();
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        String logMsg = String.format("De mail rapportage met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        log.info((Object)logMsg);
        sb.append(logMsg).append("\n");
        try {
            InitialContext init = new InitialContext();
            Context env = (Context)init.lookup("java:comp/env");
            Session session = (Session)env.lookup("mail/session");
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom();
            msg.setSentDate(new Date());
            String sForStatus = this.config.getForStatus() == null ? "alle" : this.config.getForStatus().toString();
            String sPIDS = this.config.getConfig().get("pIDS") == null ? "alle" : ((ClobElement)this.config.getConfig().get("pIDS")).getValue();
            String subject = String.format("BRMO rapport: %d voor status: %s (taken: %s)", this.config.getId(), sForStatus, sPIDS);
            msg.setSubject(subject);
            String[] adressen = this.config.getMailAdressenArray();
            InternetAddress[] aanAdr = new InternetAddress[adressen.length];
            for (int i = 0; i < adressen.length; ++i) {
                aanAdr[i] = new InternetAddress(adressen[i]);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])aanAdr);
            StringBuilder mailText = new StringBuilder();
            List processen = this.getProcessen();
            for (AutomatischProces p : processen) {
                logMsg = String.format("Rapportage van taak %d met status: %s", p.getId(), p.getStatus());
                log.info((Object)logMsg);
                sb.append(logMsg).append("\n");
                mailText.append("Rapport van taak: ").append(p.getId()).append(", type: ").append(p.getClass().getSimpleName()).append("\n");
                mailText.append("Status van de taak: ").append(p.getStatus()).append("\n");
                mailText.append("Samenvatting: ").append("\n");
                mailText.append(p.getSamenvatting()).append("\n");
                mailText.append("---------------------------------").append("\n");
            }
            if (processen.isEmpty()) {
                mailText.append("Er waren geen automatische processen die voldeden aan de opgegeven voorwaarden: ").append("\n");
                mailText.append(" - Status: ").append(sForStatus).append("\n");
                mailText.append(" - Taken: ").append(sPIDS).append("\n");
            }
            log.debug((Object)mailText.toString());
            msg.setText(mailText.toString());
            Transport.send((Message)msg);
            logMsg = String.format("Klaar met taak %d op %tc", this.config.getId(), Calendar.getInstance());
            log.info((Object)logMsg);
            sb.append(logMsg).append("\n");
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.updateSamenvattingEnLogfile(sb.toString());
            this.config.setLastrun(new Date());
        }
        catch (MessagingException ex) {
            log.error((Object)ex);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            throw new BrmoException((Throwable)ex);
        }
        catch (NamingException ex) {
            log.error((Object)ex);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            throw new BrmoException((Throwable)ex);
        }
        finally {
            this.active = false;
        }
    }

    private List<AutomatischProces> getProcessen() {
        String pids;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        EntityManager em = Stripersist.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(AutomatischProces.class);
        Root from = cq.from(AutomatischProces.class);
        if (this.config.getForStatus() != null) {
            Predicate where = cb.equal((Expression)from.get("status"), (Object)this.config.getForStatus());
            predicates.add(where);
        }
        if ((pids = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("pIDS")))) != null) {
            ArrayList<Long> pidLijst = new ArrayList<Long>();
            Matcher match = Pattern.compile("[0-9]+").matcher(pids);
            while (match.find()) {
                pidLijst.add(Long.valueOf(match.group()));
            }
            Predicate in = from.get("id").in(pidLijst);
            predicates.add(in);
        }
        Predicate notIn = from.get("id").in(new Object[]{this.config.getId()}).not();
        predicates.add(notIn);
        cq.where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()])));
        cq.orderBy(new Order[]{cb.asc((Expression)from.get("status"))});
        cq.orderBy(new Order[]{cb.asc((Expression)from.get("lastrun"))});
        return em.createQuery(cq).getResultList();
    }

    public void execute(ProgressUpdateListener listener) {
        try {
            this.execute();
        }
        catch (BrmoException ex) {
            log.error((Object)ex);
        }
    }
}

