/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripersist;

import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.InitializeSettings;
import org.w3c.dom.Node;

public class DynamicStripersistInitializer
implements InitializeSettings {
    private static final Log log = LogFactory.getLog(DynamicStripersistInitializer.class);
    private static final String DATA_SOURCE_NAME = "java:comp/env/jdbc/brmo/staging";
    public static final String PU_PREFIX = "brmo.persistence.";
    public static String databaseProductName = null;
    private SortedMap<String, Node> persistenceUnits;
    private ServletContext context;

    public void init(SortedMap<String, Node> persistenceUnits, URL xml, ServletContext context) {
        this.persistenceUnits = persistenceUnits;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPersistenceUnitsToCreate() throws Exception {
        log.info((Object)"Trying to determine persistence unit from JNDI DataSource database");
        String persistenceUnit = null;
        DataSource ds = null;
        try {
            InitialContext ctx = new InitialContext();
            ds = (DataSource)ctx.lookup(DATA_SOURCE_NAME);
        }
        catch (Exception e) {
            log.info((Object)"No JNDI DataSource found under java:comp/env/jdbc/brmo/staging");
        }
        if (ds != null) {
            try {
                Connection conn = ds.getConnection();
                try {
                    databaseProductName = conn.getMetaData().getDatabaseProductName();
                }
                finally {
                    conn.close();
                }
                if (databaseProductName == null) {
                    throw new Exception("No database product name found!");
                }
                persistenceUnit = PU_PREFIX + databaseProductName.toLowerCase();
                if (!this.persistenceUnits.containsKey(persistenceUnit)) {
                    throw new Exception(String.format("No persistence unit \"%s\" found for database product name \"%s\"", persistenceUnit, databaseProductName));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error looking up database product name", (Throwable)e);
                throw e;
            }
        }
        log.info((Object)("Found persistence unit: " + persistenceUnit));
        return Arrays.asList(persistenceUnit);
    }
}

