/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.NoResultException;
import nl.b3p.brmo.loader.entity.BagBericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.xml.BagXMLReader;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.persistence.staging.WebMirrorBAGScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.stripesstuff.stripersist.Stripersist;

public class WebMirrorBAGDirectoryScanner
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(WebMirrorBAGDirectoryScanner.class);
    private final WebMirrorBAGScannerProces config;
    private ProgressUpdateListener listener;

    public WebMirrorBAGDirectoryScanner(WebMirrorBAGScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        String msg = String.format("Initialiseren... %tc", new Date());
        listener.updateStatus(msg);
        listener.addLog(msg);
        this.config.addLogLine(msg);
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        Stripersist.getEntityManager().flush();
        try {
            URI parent;
            String url = this.config.getScanDirectory();
            msg = String.format("Ophalen van de lijst van links van %s.", url);
            listener.addLog(msg);
            this.config.addLogLine(msg);
            Document doc = Jsoup.connect((String)url).timeout(5000).followRedirects(true).ignoreHttpErrors(false).get();
            msg = "De lijst met download links is succesvol opgehaald.";
            listener.updateStatus(msg);
            listener.addLog(msg);
            this.config.addLogLine(msg);
            String expression = ((ClobElement)this.config.getConfig().get("csspath")).getValue();
            Elements links = doc.select(expression);
            URI uri = new URI(url);
            URI uRI = parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
            if (parent.toString().equalsIgnoreCase(links.first().attr("abs:href"))) {
                msg = String.format("Overslaan van (parent) link %s", parent);
                listener.updateStatus(msg);
                listener.addLog(msg);
                this.config.addLogLine(msg);
                log.info((Object)msg);
                links.remove((Object)links.first());
            }
            int items = links.size();
            listener.total((long)items);
            int progress = 0;
            int aantalGeladen = 0;
            int filterAlVerwerkt = 0;
            for (int i = 0; i < items; ++i) {
                String berichtUrl = links.get(i).attr("abs:href");
                String bestandsnaam = links.get(i).text();
                if (this.isBestandAlGeladen(berichtUrl)) {
                    ++filterAlVerwerkt;
                    msg = bestandsnaam + " is al geladen.";
                    listener.addLog(msg);
                    if (log.isDebugEnabled()) {
                        this.config.addLogLine(msg);
                        log.info((Object)msg);
                    }
                } else {
                    this.laadBestand(berichtUrl, bestandsnaam);
                    ++aantalGeladen;
                }
                listener.progress((long)(++progress));
            }
            msg = String.format("Klaar met run op %tc.", Calendar.getInstance());
            listener.updateStatus(msg);
            listener.addLog(msg);
            listener.addLog("\n**** resultaat ****\n");
            listener.addLog("Aantal url's die al waren geladen: " + filterAlVerwerkt);
            listener.addLog("Aantal url's geladen: " + aantalGeladen + "\n");
            this.config.updateSamenvattingEnLogfile(msg + "\nAantal url's die al waren geladen: " + filterAlVerwerkt + "\nAantal url's opgehaald: " + aantalGeladen);
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setLastrun(new Date());
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().getTransaction().commit();
        }
        catch (MalformedURLException ex) {
            log.error((Object)ex);
            this.config.addLogLine(ex.getLocalizedMessage());
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (HttpStatusException ex) {
            msg = String.format("Er is een fout opgetreden bij het uitlezen van de url %s. Status code %s", ex.getUrl(), ex.getStatusCode());
            log.error((Object)msg);
            this.config.addLogLine(msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (SocketTimeoutException ex) {
            log.error((Object)ex);
            this.config.addLogLine(ex.getLocalizedMessage());
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.config.addLogLine(ex.getLocalizedMessage());
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            this.config.addLogLine(ex.getLocalizedMessage());
            listener.exception((Throwable)ex);
            String m = "Fout bij inladen van berichten: " + ExceptionUtils.getMessage((Throwable)ex);
            if (ex.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)ex);
            }
            log.error((Object)m, (Throwable)ex);
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
        }
        finally {
            this.config.setLastrun(new Date());
            Stripersist.getEntityManager().merge((Object)this.config);
            if (Stripersist.getEntityManager().getTransaction().getRollbackOnly()) {
                Stripersist.getEntityManager().getTransaction().rollback();
            } else {
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
    }

    private boolean isBestandAlGeladen(String naam) {
        try {
            Stripersist.getEntityManager().createQuery("select 1 from LaadProces lp where lp.bestand_naam = :n").setParameter("n", (Object)naam).getSingleResult();
            log.debug((Object)("is al geladen: " + naam));
            return true;
        }
        catch (NoResultException nre) {
            log.debug((Object)("nog niet geladen: " + naam));
            return false;
        }
    }

    private void laadBestand(String sUrl, String naam) throws Exception {
        ZipInputStream zis;
        ZipEntry entry;
        String msg = "Downloaden " + sUrl;
        this.listener.updateStatus(msg);
        this.listener.addLog(msg);
        this.config.addLogLine(msg);
        log.info((Object)msg);
        URL url = new URL(sUrl);
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(false);
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.connect();
        InputStream zipData = conn.getInputStream();
        if (this.isArchivingOK()) {
            FileOutputStream archiveFile = new FileOutputStream(new File(this.config.getArchiefDirectory(), naam));
            zipData = new TeeInputStream(zipData, (OutputStream)archiveFile, true);
        }
        if ((entry = (zis = new ZipInputStream(zipData)).getNextEntry()) == null) {
            msg = String.format("  Geen geschikt bestand gevonden in download %s.", sUrl);
            this.listener.addLog(msg);
            this.config.addLogLine(msg);
            return;
        }
        LaadProces lp = new LaadProces();
        lp.setBestand_naam(sUrl);
        lp.setSoort("bag");
        lp.setStatus(LaadProces.STATUS.STAGING_OK);
        lp.setStatus_datum(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        lp.setOpmerking("WebMirror download van " + url + " op " + sdf.format(new Date()));
        lp.setAutomatischProces((AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.config.getId()));
        SimpleDateFormat sdFmt = new SimpleDateFormat("ddMMyyyy");
        String d = naam.substring("9999MUT01012015-".length(), "9999MUT01012015-02012015".length());
        lp.setBestand_datum(sdFmt.parse(d));
        Stripersist.getEntityManager().persist((Object)lp);
        while (entry != null) {
            if (!entry.getName().toLowerCase().endsWith(".xml")) {
                msg = "Overslaan zip entry geen XML: " + entry.getName();
                this.listener.updateStatus(msg);
                this.listener.addLog(msg);
                this.config.addLogLine(msg);
                log.info((Object)msg);
            } else {
                msg = String.format("  Lezen XML bestand: %s uit zip", entry.getName());
                this.listener.updateStatus(msg);
                this.listener.addLog(msg);
                this.config.addLogLine(msg);
                log.info((Object)msg);
                byte[] xml = IOUtils.toByteArray((InputStream)zis);
                BagXMLReader bagreader = new BagXMLReader((InputStream)new ByteArrayInputStream(xml));
                if (bagreader.hasNext()) {
                    while (bagreader.hasNext()) {
                        Bericht b = new Bericht();
                        b.setLaadprocesid(lp);
                        b.setSoort("bag");
                        b.setStatus(Bericht.STATUS.STAGING_OK);
                        b.setStatus_datum(new Date());
                        msg = String.format("Bericht uit bestand %s (zip file: %s)", entry.getName(), naam);
                        b.setOpmerking(msg);
                        this.listener.updateStatus(msg);
                        BagBericht bag = bagreader.next();
                        b.setBr_xml(bag.getBrXml());
                        b.setVolgordenummer(bag.getVolgordeNummer());
                        b.setObject_ref(bag.getObjectRef());
                        b.setDatum(bag.getDatum());
                        Stripersist.getEntityManager().persist((Object)b);
                    }
                } else {
                    msg = String.format("  Geen mutatie berichten in bestand %s (%d Kb) gevonden.", entry.getName(), entry.getSize() / 1024L);
                    this.listener.addLog(msg);
                    this.config.addLogLine(msg);
                    log.warn((Object)msg);
                }
            }
            entry = zis.getNextEntry();
        }
        IOUtils.closeQuietly((InputStream)zis);
        Stripersist.getEntityManager().merge((Object)lp);
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private boolean isArchivingOK() {
        boolean isArchiving;
        String aDir = this.config.getArchiefDirectory();
        boolean bl = isArchiving = aDir != null;
        if (isArchiving) {
            File archiefDirectory = new File(aDir);
            try {
                archiefDirectory.mkdirs();
                if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    String msg = String.format("FOUT: De archief directory '%s' is geen beschrijfbare directory, zipfiles worden niet gearchiveerd.", archiefDirectory);
                    this.listener.addLog(msg);
                    this.config.addLogLine(msg);
                    isArchiving = false;
                }
            }
            catch (SecurityException e) {
                String msg = String.format("SecurityException voor archief directory '%s', zipfiles worden niet gearchiveerd.", archiefDirectory);
                this.listener.addLog(msg);
                this.config.addLogLine(msg);
                log.error((Object)msg, (Throwable)e);
                isArchiving = false;
            }
        }
        log.debug((Object)("Archief directory ingesteld op " + aDir));
        return isArchiving;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

