/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.jobs;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.service.jobs.AutomatischProcesJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeplandeTakenInit
implements Servlet {
    private static final Log log = LogFactory.getLog(GeplandeTakenInit.class);
    private static Scheduler scheduler;
    public static final String JOBKEY_PREFIX = "proces_";
    public static final String TRIGGERKEY_PREFIX = "trigger_";
    public static final String SCHEDULER_NAME = "BRMOgeplandeTaken";
    public static final String QUARTZ_FACTORY_KEY = "BRMO_qtz_factory";
    private ServletConfig config;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        try {
            this.setupQuartz();
        }
        catch (SchedulerException ex) {
            log.error((Object)ex);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServletInfo() {
        return "Initialiseer Quartz scheduler voor BRMO";
    }

    public void destroy() {
        try {
            this.destroyQuartz();
        }
        catch (SchedulerException ex) {
            log.error((Object)ex);
        }
    }

    private void destroyQuartz() throws SchedulerException {
        if (scheduler != null) {
            scheduler.shutdown(true);
        }
    }

    private void setupQuartz() throws SchedulerException {
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", "BRMOgeplandeTaken");
        props.put("org.quartz.threadPool.threadCount", "1");
        props.put("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        props.put("org.quartz.scheduler.skipUpdateCheck", "true");
        StdSchedulerFactory factory = new StdSchedulerFactory(props);
        scheduler = factory.getScheduler();
        scheduler.start();
        Stripersist.requestInit();
        EntityManager entityManager = Stripersist.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(AutomatischProces.class);
        Root from = cq.from(AutomatischProces.class);
        cq.where((Expression)cb.isNotNull((Expression)from.get("cronExpressie")));
        List procList = entityManager.createQuery(cq).getResultList();
        for (AutomatischProces p : procList) {
            GeplandeTakenInit.addJobDetails((Scheduler)scheduler, (AutomatischProces)p);
        }
        this.getServletConfig().getServletContext().setAttribute("BRMO_qtz_factory", (Object)factory);
    }

    public static void addJobDetails(Scheduler scheduler, AutomatischProces p) throws SchedulerException {
        try {
            CronExpression cron = new CronExpression(p.getCronExpressie());
            JobDetail job = JobBuilder.newJob(AutomatischProcesJob.class).usingJobData("id", p.getId()).withIdentity("proces_" + p.getId()).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().startNow().forJob(job).withIdentity("trigger_" + p.getId()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cron)).build();
            scheduler.scheduleJob(job, (Trigger)trigger);
            log.info((Object)String.format("Proces: %d met cron expressie %s is toegevoegd (of bijgewerkt).", p.getId(), p.getCronExpressie()));
        }
        catch (ParseException ex) {
            log.warn((Object)String.format("Ongeldige cron expressie voor proces met %d. Het proces is niet ingepland.", p.getId()), (Throwable)ex);
        }
    }
}

