/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.exports.ExportProcess;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.brmo.loader.util.StagingRowHandler;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
public class ExportActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log log = LogFactory.getLog(ExportActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/transform/exports.jsp";
    private static final String JSP_PROGRESS = "/WEB-INF/jsp/transform/exportsprogress.jsp";
    private static final String MUTOPEN = "<?xml version=\"1.0\"?><Mutatie:Mutatie xmlns:Mutatie=\"http://www.kadaster.nl/schemas/brk-levering/product-mutatie/v20120901\" xmlns:KadastraalObjectRef=\"http://www.kadaster.nl/schemas/brk-levering/snapshot/imkad-kadastraalobject-ref/v20120201\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"><Mutatie:BRKDatum>%s</Mutatie:BRKDatum><Mutatie:volgnummerKadastraalObjectDatum>%s</Mutatie:volgnummerKadastraalObjectDatum><Mutatie:kadastraalObject><Mutatie:AanduidingKadastraalObject><Mutatie:kadastraalObject><KadastraalObjectRef:PerceelRef xlink:href=\"%s\"/></Mutatie:kadastraalObject></Mutatie:AanduidingKadastraalObject></Mutatie:kadastraalObject><Mutatie:wordt>";
    private static final String MUTCLOSE = "</Mutatie:wordt></Mutatie:Mutatie>";
    private ActionBeanContext context;
    private List<ExportProcess> exportProcesses;
    @Validate(required=true, on={"export"})
    private String exportProcessName;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private Date start;
    private Date update;
    private String exceptionStacktrace;
    private boolean repairFirst = false;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public List<ExportProcess> getExportProcesses() {
        return this.exportProcesses;
    }

    public void setExportProcesses(List<ExportProcess> exportProcesses) {
        this.exportProcesses = exportProcesses;
    }

    public String getExportProcessName() {
        return this.exportProcessName;
    }

    public void setExportProcessName(String exportProcessName) {
        this.exportProcessName = exportProcessName;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void populateExportProcesses() {
        this.exportProcesses = Arrays.asList(new ExportProcess("Exporteren BRK mutaties", "brk", "/tmp/brkmutaties"), new ExportProcess("Repareren BRK mutaties", "brk", null));
    }

    @DefaultHandler
    public Resolution form() {
        return new ForwardResolution(this.complete ? JSP_PROGRESS : JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/transform/exportsprogress.jsp", delay=1000, refresh=1000)
    public Resolution export() {
        ExportProcess process = null;
        for (ExportProcess p : this.exportProcesses) {
            if (!p.getName().equals(this.exportProcessName)) continue;
            process = p;
            break;
        }
        if (process == null) {
            this.getContext().getMessages().add(new SimpleMessage("Ongeldig proces", new Object[0]));
            return new ForwardResolution(JSP);
        }
        this.start = new Date();
        log.info((Object)("Start export process: " + process.getName()));
        this.processed = 0L;
        try {
            if (process.getName().equals("Exporteren BRK mutaties")) {
                this.exportMutatieBerichten(process.getExportpad());
            } else if (process.getName().equals("Repareren BRK mutaties")) {
                this.repairMutatieBerichten();
            }
            if (this.exceptionStacktrace == null) {
                this.getContext().getMessages().add(new SimpleMessage("Export afgerond.", new Object[0]));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij exporteren", t);
            String m = "Fout bij exporteren: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            this.complete = true;
        }
        return new ForwardResolution(JSP_PROGRESS);
    }

    public void repairMutatieBerichten() throws Exception {
        int offset = 0;
        int batch = 250;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        do {
            log.debug((Object)String.format("Ophalen mutatieberichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where volgordenummer >= 0 order by id ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    public void exportMutatieBerichten(String locatie) throws Exception {
        if (this.repairFirst) {
            this.repairMutatieBerichten();
        }
        int offset = 0;
        int batch = 5000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        File exportDir = new File(locatie);
        FileUtils.forceMkdir((File)exportDir);
        do {
            log.debug((Object)String.format("Ophalen mutatieberichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where volgordenummer >= 0 order by object_ref, datum, volgordenummer ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            File f = new File(exportDir, "batch" + offset + ".zip");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (out != null) {
                out.close();
            }
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

