/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.util.List;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class LaadProcesActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(LaadProcesActionBean.class);
    private ActionBeanContext context;
    private List<LaadProces> processen;
    private long[] selectedIds;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private JSONObject changedItem;

    @DefaultHandler
    public Resolution list() {
        return new ForwardResolution("/WEB-INF/jsp/laadproces/list.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution delete() {
        if (this.selectedIds != null) {
            BrmoFramework brmo = null;
            try {
                DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
                DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
                brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb);
                long[] arr$ = this.selectedIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Long id = arr$[i$];
                    brmo.delete(id);
                }
            }
            catch (BrmoException e) {
                log.error((Object)"Fout", (Throwable)e);
                ErrorResolution errorResolution = new ErrorResolution(500, "Er is een onherstelbare fout opgetreden. Contacteer uw applicatiebeheerder: " + e.getLocalizedMessage());
                return errorResolution;
            }
            finally {
                if (brmo != null) {
                    brmo.closeBrmoFramework();
                }
            }
        }
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("success", true);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getGridData() {
        String filterSoort = "";
        String filterStatus = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                String value = j.getString("value");
                if (property.equals("soort")) {
                    filterSoort = value;
                }
                if (!property.equals("status")) continue;
                filterStatus = value;
            }
        }
        JSONObject grid = new JSONObject();
        BrmoFramework brmo = null;
        try {
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            long count = 0L;
            JSONArray jsonProcessen = new JSONArray();
            brmo = new BrmoFramework(dataSourceStaging, null);
            count = brmo.getCountLaadProcessen(this.sort, this.dir, filterSoort, filterStatus);
            this.processen = brmo.getLaadprocessen(this.page, this.start, this.limit, this.sort == null || this.sort.trim().isEmpty() ? "id" : this.sort, this.dir == null || this.dir.trim().isEmpty() ? "asc" : this.dir, filterSoort, filterStatus);
            for (LaadProces proces : this.processen) {
                JSONObject jsonObject = this.laadProces2Json(proces);
                jsonProcessen.put((Object)jsonObject);
            }
            grid.put("total", count);
            grid.put("items", (Object)jsonProcessen);
        }
        catch (BrmoException e) {
            log.error((Object)"Fout", (Throwable)e);
            ErrorResolution errorResolution = new ErrorResolution(500, "Er is een onherstelbare fout opgetreden. Contacteer uw applicatiebeheerder: " + e.getLocalizedMessage());
            return errorResolution;
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject laadProces2Json(LaadProces lp) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)lp.getId());
        json.put("bestand_naam", (Object)lp.getBestandNaam());
        json.put("bestand_datum", (Object)lp.getBestandDatum());
        json.put("soort", (Object)lp.getSoort());
        json.put("status", (Object)lp.getStatus());
        json.put("volgorde", (Object)"nvt");
        json.put("opmerking", (Object)lp.getOpmerking());
        return json;
    }

    public Resolution saveRecord() {
        JSONObject item = this.getChangedItem();
        EntityManager em = Stripersist.getEntityManager();
        nl.b3p.brmo.persistence.staging.LaadProces _lp = (nl.b3p.brmo.persistence.staging.LaadProces)em.find(nl.b3p.brmo.persistence.staging.LaadProces.class, (Object)item.getLong("id"));
        _lp.setStatus(LaadProces.STATUS.valueOf((String)item.getString("status")));
        em.merge((Object)_lp);
        em.getTransaction().commit();
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("success", true);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<LaadProces> getProcessen() {
        return this.processen;
    }

    public void setProcessen(List<LaadProces> processen) {
        this.processen = processen;
    }

    public long[] getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(long[] selectedIds) {
        this.selectedIds = selectedIds;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public JSONObject getChangedItem() {
        return this.changedItem;
    }

    public void setChangedItem(JSONObject changedItem) {
        this.changedItem = changedItem;
    }
}

