/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.util.Date;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.service.stripes.TransformActionBean;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

public class TransformActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log log = LogFactory.getLog(TransformActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/transform/transform.jsp";
    private ActionBeanContext context;
    private long[] selectedIds;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private Date start;
    private Date update;
    private String exceptionStacktrace;

    @Before
    public void before() {
        this.start = new Date();
    }

    @After
    public void completed() {
        this.complete = true;
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        this.exceptionStacktrace = t.getLocalizedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolution doTransform(RsgbProxy.BerichtSelectMode mode, boolean orderBerichten) {
        BrmoFramework brmo = null;
        try {
            String capacityString;
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
            brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb);
            boolean enableTransformPipeline = "true".equals(this.getContext().getServletContext().getInitParameter("pipelining.enabled"));
            brmo.setEnablePipeline(enableTransformPipeline);
            if (enableTransformPipeline && (capacityString = this.getContext().getServletContext().getInitParameter("pipelining.capacity")) != null) {
                brmo.setTransformPipelineCapacity(Integer.parseInt(capacityString));
            }
            brmo.setOrderBerichten(orderBerichten);
            Thread t = null;
            switch (1.$SwitchMap$nl$b3p$brmo$loader$RsgbProxy$BerichtSelectMode[mode.ordinal()]) {
                case 1: {
                    t = brmo.toRsgb(RsgbProxy.BerichtSelectMode.BY_IDS, this.selectedIds, (ProgressUpdateListener)this);
                    break;
                }
                case 2: {
                    t = brmo.toRsgb((ProgressUpdateListener)this);
                    break;
                }
                case 3: {
                    t = brmo.toRsgb(RsgbProxy.BerichtSelectMode.RETRY_WAITING, null, (ProgressUpdateListener)this);
                    break;
                }
                case 4: {
                    t = brmo.toRsgb(RsgbProxy.BerichtSelectMode.BY_LAADPROCES, this.selectedIds, (ProgressUpdateListener)this);
                }
            }
            t.join();
            if (this.exceptionStacktrace == null) {
                this.getContext().getMessages().add(new SimpleMessage("Transformatie afgerond, controleer berichtenstatus.", new Object[0]));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij transformeren berichten naar RSGB", t);
            String m = "Fout bij transformeren berichten naar RSGB: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
        return new ForwardResolution(JSP);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformSelected() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.BY_IDS, true);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformAll() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.BY_STATUS, true);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformAllStand() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.BY_STATUS, false);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformRetry() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.RETRY_WAITING, true);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformRetryStand() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.RETRY_WAITING, false);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformSelectedLaadprocessen() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.BY_LAADPROCES, true);
    }

    @WaitPage(path="/WEB-INF/jsp/transform/transform.jsp", delay=1000, refresh=1000)
    public Resolution transformSelectedLaadprocessenStand() {
        return this.doTransform(RsgbProxy.BerichtSelectMode.BY_LAADPROCES, false);
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public long[] getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(long[] selectedIds) {
        this.selectedIds = selectedIds;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }
}

