/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BAGScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.BAGDirectoryScanner;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BAGDirectoryScanner
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BAGDirectoryScanner.class);
    private final BAGScannerProces config;

    public BAGDirectoryScanner(BAGScannerProces config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute() throws BrmoException {
        switch (1.$SwitchMap$nl$b3p$brmo$persistence$staging$AutomatischProces$ProcessingStatus[this.config.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                sb = new StringBuilder();
                this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
                msg = String.format("De BAG scanner met ID %d is gestart op %tc.", new Object[]{this.config.getId(), Calendar.getInstance()});
                BAGDirectoryScanner.log.info((Object)msg);
                sb.append(msg).append("\n");
                this.active = true;
                scanDirectory = new File(this.config.getScanDirectory());
                if (!scanDirectory.isDirectory() || !scanDirectory.canExecute()) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    this.config.addLogLine(String.format("FOUT: De scan directory '%s' is geen executable directory", new Object[]{scanDirectory}));
                    this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                    this.active = false;
                    throw new BrmoException(String.format("De scan directory '%s' is geen executable directory", new Object[]{scanDirectory}));
                }
                aDir = this.config.getArchiefDirectory();
                isArchiving = aDir != null;
                archiefDirectory = null;
                if (isArchiving) {
                    archiefDirectory = new File(aDir);
                    archiefDirectory.mkdirs();
                    if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                        this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                        this.config.addLogLine(String.format("FOUT: De archief directory '%s' is geen beschrijfbare directory", new Object[]{archiefDirectory}));
                        this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                        this.active = false;
                        throw new BrmoException(String.format("De archief directory '%s' is geen beschrijfbare directory", new Object[]{archiefDirectory}));
                    }
                    if (!scanDirectory.canWrite()) {
                        this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                        this.config.addLogLine(String.format("FOUT: De scan directory '%s' is geen beschrijfbare directory", new Object[]{scanDirectory}));
                        this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                        this.active = false;
                        throw new BrmoException(String.format("De scan directory '%s' is geen beschrijfbare directory", new Object[]{scanDirectory}));
                    }
                }
                files = scanDirectory.listFiles();
                Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
                for (File f : files) {
                    if (f.isDirectory()) continue;
                    msg = String.format("Bestand %s is gevonden in %s.", new Object[]{f, scanDirectory});
                    BAGDirectoryScanner.log.info((Object)msg);
                    sb.append(msg).append("\n");
                    brmo = null;
                    if (this.isDuplicaatLaadProces(f, "bag")) {
                        msg = String.format("Bestand %s is een duplicaat en wordt overgeslagen.", new Object[]{f});
                        BAGDirectoryScanner.log.info((Object)msg);
                        sb.append(msg).append("\n");
                    } else {
                        brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), null);
                        brmo.loadFromFile("bag", this.getBestandsNaam(f));
                        msg = String.format("Bestand %s is geladen.", new Object[]{f});
                        BAGDirectoryScanner.log.info((Object)msg);
                        sb.append(msg).append("\n");
                    }
                    if (brmo == null) ** GOTO lbl60
                    brmo.closeBrmoFramework();
lbl60:
                    // 2 sources

                    if (!isArchiving) continue;
                    try {
                        FileUtils.copyFileToDirectory((File)f, (File)archiefDirectory);
                        succes = FileUtils.deleteQuietly((File)f);
                        msg = succes ? String.format("  Bestand %s is naar archief %s verplaatst.", new Object[]{f, archiefDirectory}) : String.format("  Bestand %s is naar archief %s verplaatst, maar origineel kon niet verwijderd worden.", new Object[]{f, archiefDirectory});
                    }
                    catch (IOException e) {
                        msg = String.format("  Bestand %s is NIET naar archief %s verplaatst, oorzaak: (%s).", new Object[]{f, archiefDirectory, e.getLocalizedMessage()});
                        BAGDirectoryScanner.log.error((Object)msg);
                    }
                    BAGDirectoryScanner.log.info((Object)msg);
                    sb.append(msg).append("\n");
                    continue;
                    catch (BrmoDuplicaatLaadprocesException duplicaat) {
                        BAGDirectoryScanner.log.info((Object)duplicaat.getLocalizedMessage());
                        sb.append(duplicaat.getLocalizedMessage()).append("\n");
                        if (brmo == null) ** GOTO lbl80
                        brmo.closeBrmoFramework();
lbl80:
                        // 2 sources

                        if (!isArchiving) continue;
                        try {
                            FileUtils.copyFileToDirectory((File)f, (File)archiefDirectory);
                            succes = FileUtils.deleteQuietly((File)f);
                            msg = succes ? String.format("  Bestand %s is naar archief %s verplaatst.", new Object[]{f, archiefDirectory}) : String.format("  Bestand %s is naar archief %s verplaatst, maar origineel kon niet verwijderd worden.", new Object[]{f, archiefDirectory});
                        }
                        catch (IOException e) {
                            msg = String.format("  Bestand %s is NIET naar archief %s verplaatst, oorzaak: (%s).", new Object[]{f, archiefDirectory, e.getLocalizedMessage()});
                            BAGDirectoryScanner.log.error((Object)msg);
                        }
                        BAGDirectoryScanner.log.info((Object)msg);
                        sb.append(msg).append("\n");
                        continue;
                    }
                    catch (BrmoLeegBestandException leegEx) {
                        BAGDirectoryScanner.log.warn((Object)leegEx.getLocalizedMessage());
                        sb.append(leegEx.getLocalizedMessage()).append("\n");
                        if (brmo == null) ** GOTO lbl116
                        {
                            catch (Throwable var14_21) {
                                if (brmo != null) {
                                    brmo.closeBrmoFramework();
                                }
                                if (isArchiving) {
                                    try {
                                        FileUtils.copyFileToDirectory((File)f, (File)archiefDirectory);
                                        succes = FileUtils.deleteQuietly((File)f);
                                        msg = succes ? String.format("  Bestand %s is naar archief %s verplaatst.", new Object[]{f, archiefDirectory}) : String.format("  Bestand %s is naar archief %s verplaatst, maar origineel kon niet verwijderd worden.", new Object[]{f, archiefDirectory});
                                    }
                                    catch (IOException e) {
                                        msg = String.format("  Bestand %s is NIET naar archief %s verplaatst, oorzaak: (%s).", new Object[]{f, archiefDirectory, e.getLocalizedMessage()});
                                        BAGDirectoryScanner.log.error((Object)msg);
                                    }
                                    BAGDirectoryScanner.log.info((Object)msg);
                                    sb.append(msg).append("\n");
                                }
                                throw var14_21;
                            }
                        }
                        brmo.closeBrmoFramework();
lbl116:
                        // 2 sources

                        if (!isArchiving) continue;
                        try {
                            FileUtils.copyFileToDirectory((File)f, (File)archiefDirectory);
                            succes = FileUtils.deleteQuietly((File)f);
                            msg = succes ? String.format("  Bestand %s is naar archief %s verplaatst.", new Object[]{f, archiefDirectory}) : String.format("  Bestand %s is naar archief %s verplaatst, maar origineel kon niet verwijderd worden.", new Object[]{f, archiefDirectory});
                        }
                        catch (IOException e) {
                            msg = String.format("  Bestand %s is NIET naar archief %s verplaatst, oorzaak: (%s).", new Object[]{f, archiefDirectory, e.getLocalizedMessage()});
                            BAGDirectoryScanner.log.error((Object)msg);
                        }
                        BAGDirectoryScanner.log.info((Object)msg);
                        sb.append(msg).append("\n");
                    }
                }
                msg = String.format("Klaar met run op %tc", new Object[]{Calendar.getInstance()});
                BAGDirectoryScanner.log.info((Object)msg);
                sb.append(msg);
                this.active = false;
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                this.config.updateSamenvattingEnLogfile(sb.toString());
                this.config.setLastrun(new Date());
                break;
            }
            default: {
                BAGDirectoryScanner.log.warn((Object)String.format("De BAG scanner met ID %d is niet gestart vanwege de status %s.", new Object[]{this.config.getId(), this.config.getStatus()}));
            }
        }
    }

    public void execute(ProgressUpdateListener listener) {
        try {
            this.execute();
            listener.total(1L);
            listener.progress(1L);
            listener.updateStatus("Onbekend - niet geimplementeerd");
            listener.addLog("Onbkend - niet geimplementeerd");
        }
        catch (BrmoException ex) {
            log.error((Object)ex);
        }
    }
}

