/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.Date;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BerichtTransformatieProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BerichtTransformatieUitvoeren
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BerichtTransformatieUitvoeren.class);
    private final BerichtTransformatieProces config;
    private ProgressUpdateListener l;

    public BerichtTransformatieUitvoeren(BerichtTransformatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.l = listener;
        this.l.updateStatus("Initialiseren...");
        this.l.addLog(String.format("Initialiseren... %tc", new Date()));
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        Stripersist.getEntityManager().flush();
        BrmoFramework brmo = null;
        try {
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
            brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb);
            brmo.setEnablePipeline(true);
            brmo.setOrderBerichten(true);
            brmo.setTransformPipelineCapacity(100);
            Thread t = brmo.toRsgb((nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
            t.join();
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setSamenvatting("Bericht transformatie is afgerond.");
            this.config.setLastrun(new Date());
            this.l.addLog("Bericht transformatie is afgerond.");
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij transformeren berichten naar RSGB", t);
            String m = "Fout bij transformeren berichten naar RSGB: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.config.setLastrun(new Date());
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
        }
    }

    static /* synthetic */ BerichtTransformatieProces access$000(BerichtTransformatieUitvoeren x0) {
        return x0.config;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ ProgressUpdateListener access$200(BerichtTransformatieUitvoeren x0) {
        return x0.l;
    }
}

