/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BGTLightScannerProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BGTLightDirectoryScanner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(BGTLightDirectoryScanner.class);
    private final BGTLightScannerProces config;
    private final int defaultCommitPageSize = 1000;
    @Transient
    private ProgressUpdateListener listener;

    public BGTLightDirectoryScanner(BGTLightScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 2000) {
                sb.append(oldLog.substring(oldLog.length() - 2000));
            } else {
                sb.append(oldLog);
            }
        }
        String msg = String.format("De BGT Light scanner met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.addLog(msg);
        sb.append(msg);
        File scanDirectory = new File(this.config.getScanDirectory());
        if (!scanDirectory.isDirectory() || !scanDirectory.canExecute()) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            msg = String.format("De scan directory '%s' is geen executable directory", scanDirectory);
            this.config.setLogfile(msg);
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.listener.exception((Throwable)new BrmoException(msg));
            return;
        }
        this.config.setLogfile(sb.toString());
        File[] files = scanDirectory.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
        this.processZipFiles(files, scanDirectory);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private void processZipFiles(File[] files, File scanDirectory) {
        String msg;
        StringBuilder sb = new StringBuilder("\n" + this.config.getLogfile());
        int filterAlVerwerkt = 0;
        int aantalGeladen = 0;
        int progress = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        int commitPageSize = this.getCommitPageSize();
        this.listener.total((long)files.length);
        for (File f : files) {
            if (f.isDirectory()) continue;
            msg = String.format("Bestand %s is gevonden in %s.", f, scanDirectory);
            LOG.info((Object)msg);
            this.listener.addLog(msg);
            sb.append("\n").append(msg).append("\n");
            if (this.isDuplicaatLaadProces(f, "bgtlight")) {
                msg = String.format("  Bestand %s is een duplicaat en wordt overgeslagen.", f);
                this.listener.addLog(msg);
                LOG.info((Object)msg);
                sb.append(msg).append("\n");
                ++filterAlVerwerkt;
            } else {
                LaadProces lp = new LaadProces();
                lp.setBestand_naam(this.getBestandsNaam(f));
                lp.setBestand_datum(this.getBestandsDatum(f));
                lp.setSoort("bgtlight");
                lp.setStatus(LaadProces.STATUS.STAGING_OK);
                lp.setOpmerking(String.format("Bestand geladen van %s op %s", f.getAbsolutePath(), sdf.format(new Date())));
                lp.setAutomatischProces((AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.config.getId()));
                Stripersist.getEntityManager().persist((Object)lp);
                Stripersist.getEntityManager().merge((Object)this.config);
                ++aantalGeladen;
                msg = String.format("  Bestand %s is geladen en heeft status: %s.", f, lp.getStatus());
                LOG.info((Object)msg);
                this.listener.addLog(msg);
                sb.append(msg).append("\n");
                if (aantalGeladen % commitPageSize == 0) {
                    LOG.debug((Object)"Tussentijds opslaan van berichten, 'commitPageSize' is bereikt");
                    Stripersist.getEntityManager().flush();
                    Stripersist.getEntityManager().getTransaction().commit();
                    Stripersist.getEntityManager().clear();
                }
            }
            this.listener.progress((long)(++progress));
        }
        msg = String.format("Klaar met run op %tc", Calendar.getInstance());
        LOG.info((Object)msg);
        this.listener.updateStatus(msg);
        this.listener.addLog(msg);
        sb.append(msg);
        this.listener.addLog("\n\n**** resultaat ****");
        this.listener.addLog("\nAantal bestanden die al waren geladen: " + filterAlVerwerkt);
        this.listener.addLog("\nAantal bestanden geladen: " + aantalGeladen + "\n");
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLogfile(sb.toString());
        this.config.setLastrun(new Date());
        this.config.updateSamenvattingEnLogfile("Aantal bestanden die al waren verwerkt: " + filterAlVerwerkt + "\n" + "Aantal bestanden geladen: " + aantalGeladen + "\n");
        Stripersist.getEntityManager().merge((Object)this.config);
    }

    private int getCommitPageSize() {
        int commitPageSize;
        try {
            String s = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("commitPageSize")));
            commitPageSize = Integer.parseInt(s);
            if (commitPageSize < 1 || commitPageSize > 1000) {
                commitPageSize = 1000;
            }
        }
        catch (NumberFormatException nfe) {
            commitPageSize = 1000;
        }
        LOG.debug((Object)("Instellen van commit page size op: " + commitPageSize));
        return commitPageSize;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

