/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.util;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.util.BrmoException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtil
implements Servlet {
    private static final Log log = LogFactory.getLog(ConfigUtil.class);
    private static final String JNDI_NAME = "java:comp/env";
    private static final String JDBC_NAME_STAGING = "jdbc/brmo/staging";
    private static final String JDBC_NAME_RSGB = "jdbc/brmo/rsgb";
    private static final String JDBC_NAME_RSGB_BGT = "jdbc/brmo/rsgbbgt";
    private static DataSource datasourceStaging = null;
    private static DataSource datasourceRsgb = null;
    public static Integer MAX_UPLOAD_SIZE;
    public static String TEMP_FOLDER;

    public void init(ServletConfig config) throws ServletException {
        String tempSize = config.getInitParameter("max_upload_size");
        MAX_UPLOAD_SIZE = tempSize != null && !tempSize.isEmpty() ? Integer.valueOf(new Integer(tempSize) * 1024) : Integer.valueOf(512000);
        String tempFolder = config.getInitParameter("temp_folder");
        TEMP_FOLDER = tempFolder != null && !tempFolder.isEmpty() ? tempFolder : "/tmp";
    }

    public static DataSource getDataSourceStaging() throws BrmoException {
        DataSource ds = null;
        try {
            if (datasourceStaging == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                ds = (DataSource)xmlContext.lookup(JDBC_NAME_STAGING);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar staging db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return ds;
    }

    public static DataSource getDataSourceRsgb() throws BrmoException {
        DataSource ds = null;
        try {
            if (datasourceRsgb == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                ds = (DataSource)xmlContext.lookup(JDBC_NAME_RSGB);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return ds;
    }

    public static DataSource getDataSourceRsgbBgt() throws BrmoException {
        DataSource ds = null;
        try {
            if (datasourceRsgb == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                ds = (DataSource)xmlContext.lookup(JDBC_NAME_RSGB_BGT);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb bgt db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return ds;
    }

    public ServletConfig getServletConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void service(ServletRequest sr, ServletResponse sr1) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServletInfo() {
        return "Servlet used for cofngiuration parameters in web.xml";
    }

    public void destroy() {
    }
}

