/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Transient;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import net.sourceforge.stripes.util.Base64;
import nl.b3p.brmo.loader.entity.BrkBericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.xml.BrkSnapshotXMLReader;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.GDS2OphaalProces;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.gds2.Main;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGbOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstgbresultaat.afgifte.v20130701.AfgifteGBType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragen.v20130701.BestandenlijstOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20130701.AfgifteSelectieCriteriaType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20130701.BestandKenmerkenType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20130701.FilterDatumTijdType;
import nl.kadaster.schemas.gds2.service.afgifte.v20130701.Gds2AfgifteServiceV20130701;
import nl.kadaster.schemas.gds2.service.afgifte.v20130701.Gds2AfgifteServiceV20130701Service;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGBOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGBOpvragenResponse;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20130701.BestandenlijstOpvragenRequest;
import nl.logius.digikoppeling.gb._2010._10.DataReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
public class GDS2OphalenProces
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(GDS2OphalenProces.class);
    private final GDS2OphaalProces config;
    @Transient
    private ProgressUpdateListener l;
    @Transient
    private SSLContext context;
    private static final String PEM_KEY_START = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_KEY_END = "-----END PRIVATE KEY-----";
    private static final String PEM_CERT_START = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERT_END = "-----END CERTIFICATE-----";
    private static final int BESTANDENLIJST_ATTEMPTS = 5;
    private static final int BESTANDENLIJST_RETRY_WAIT = 10000;
    private static final int AFGIFTE_DOWNLOAD_ATTEMPTS = 5;
    private static final int AFGIFTE_DOWNLOAD_RETRY_WAIT = 3000;

    GDS2OphalenProces(GDS2OphaalProces config) {
        this.config = config;
    }

    public static Log getLog() {
        return log;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static PrivateKey getPrivateKeyFromPEM(String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (!(pem = pem.replaceAll("\n", "").trim()).startsWith("-----BEGIN PRIVATE KEY-----")) {
            throw new IllegalArgumentException("Private key moet beginnen met -----BEGIN PRIVATE KEY-----");
        }
        if (!pem.endsWith("-----END PRIVATE KEY-----")) {
            throw new IllegalArgumentException("Private key moet eindigen met -----END PRIVATE KEY-----");
        }
        pem = pem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
        byte[] decoded = Base64.decode((String)pem);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        return kf.generatePrivate(spec);
    }

    private static Certificate getCertificateFromPEM(String pem) throws CertificateException, UnsupportedEncodingException {
        if (!(pem = pem.replaceAll("\n", "").trim()).startsWith("-----BEGIN CERTIFICATE-----")) {
            throw new IllegalArgumentException("Certificaat moet beginnen met -----BEGIN CERTIFICATE-----");
        }
        if (!pem.endsWith("-----END CERTIFICATE-----")) {
            throw new IllegalArgumentException("Certificaat moet eindigen met -----END CERTIFICATE-----");
        }
        return CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(pem.getBytes("US-ASCII")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.l = listener;
        try {
            this.l.updateStatus("Initialiseren...");
            Date startDate = new Date();
            this.l.addLog(String.format("Initialiseren GDS2 ophalen proces %d... %tc", this.config.getId(), startDate));
            this.config.updateSamenvattingEnLogfile(String.format("Het GDS2 ophalen proces is gestart op %tc.", startDate));
            this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
            this.config.setLastrun(startDate);
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
            BestandenlijstOpvragenRequest request = new BestandenlijstOpvragenRequest();
            BestandenlijstOpvragenType verzoek = new BestandenlijstOpvragenType();
            request.setVerzoek(verzoek);
            AfgifteSelectieCriteriaType criteria = new AfgifteSelectieCriteriaType();
            verzoek.setAfgifteSelectieCriteria(criteria);
            BestandenlijstGBOpvragenRequest requestGb = new BestandenlijstGBOpvragenRequest();
            BestandenlijstGbOpvragenType verzoekGb = new BestandenlijstGbOpvragenType();
            requestGb.setVerzoek(verzoekGb);
            String contractnummer = ((ClobElement)this.config.getConfig().get("gds2_contractnummer")).getValue();
            criteria.setBestandKenmerken(new BestandKenmerkenType());
            criteria.getBestandKenmerken().setContractnummer(contractnummer);
            String alGerapporteerd = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_al_gerapporteerde_afgiftes")));
            if (!"true".equals(alGerapporteerd)) {
                criteria.setNogNietGerapporteerd(Boolean.valueOf(true));
            }
            GregorianCalendar vanaf = null;
            GregorianCalendar tot = this.getDatumTijd(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("totdatum"))));
            String sVanaf = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("vanafdatum")));
            vanaf = tot != null && "-1".equals(sVanaf) | "-2".equals(sVanaf) | "-3".equals(sVanaf) ? this.getDatumTijd(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("totdatum"))), Integer.parseInt(sVanaf)) : this.getDatumTijd(sVanaf);
            GregorianCalendar currentMoment = null;
            boolean parseblePeriod = false;
            int loopType = 5;
            int loopMax = 180;
            int loopNum = 0;
            boolean reducePeriod = false;
            boolean increasePeriod = false;
            if (vanaf != null && tot != null && vanaf.before(tot)) {
                parseblePeriod = true;
                currentMoment = vanaf;
            }
            ArrayList afgiftesGb = new ArrayList();
            Gds2AfgifteServiceV20130701 gds2 = this.initGDS2();
            this.l.updateStatus("Uitvoeren SOAP request naar Kadaster...");
            boolean morePeriods2Process = false;
            do {
                this.l.addLog("\n*** start periode ***");
                if (parseblePeriod) {
                    if (reducePeriod) {
                        switch (loopType) {
                            case 5: {
                                currentMoment.add(loopType, -1);
                                loopType = 11;
                                this.l.addLog("* Verklein loop periode naar uur");
                                this.config.addLogLine("Verklein loop periode naar uur");
                                break;
                            }
                            case 11: {
                                currentMoment.add(loopType, -1);
                                loopType = 12;
                                this.l.addLog("* Verklein loop periode naar minuut");
                                this.config.addLogLine("Verklein loop periode naar minuut");
                                break;
                            }
                            default: {
                                this.l.addLog("Niet alle gevraagde berichten zijn opgehaald");
                                this.config.addLogLine("Niet alle gevraagde berichten zijn opgehaald");
                            }
                        }
                        reducePeriod = false;
                    }
                    if (increasePeriod) {
                        switch (loopType) {
                            case 11: {
                                loopType = 5;
                                this.l.addLog("* Vergroot loop periode naar dag");
                                this.config.addLogLine("Vergroot loop periode naar dag");
                                break;
                            }
                            case 12: {
                                loopType = 11;
                                this.l.addLog("* Vergroot loop periode naar uur");
                                this.config.addLogLine("Vergroot loop periode naar uur");
                                break;
                            }
                        }
                        increasePeriod = false;
                    }
                    FilterDatumTijdType d = new FilterDatumTijdType();
                    d.setDatumTijdVanaf(this.getXMLDatumTijd(currentMoment));
                    this.l.addLog(String.format("Datum vanaf: %tc", currentMoment.getTime()));
                    this.config.addLogLine(String.format("Datum vanaf: %tc", currentMoment.getTime()));
                    currentMoment.add(loopType, 1);
                    d.setDatumTijdTot(this.getXMLDatumTijd(currentMoment));
                    this.l.addLog(String.format("Datum tot: %tc", currentMoment.getTime()));
                    this.config.addLogLine(String.format("Datum tot: %tc", currentMoment.getTime()));
                    criteria.setPeriode(d);
                    switch (loopType) {
                        case 11: {
                            if (currentMoment.get(loopType) != 0) break;
                            increasePeriod = true;
                            break;
                        }
                        case 12: {
                            if (currentMoment.get(loopType) != 0) break;
                            increasePeriod = true;
                            break;
                        }
                        default: {
                            ++loopNum;
                        }
                    }
                    morePeriods2Process = currentMoment.before(tot) && loopNum < loopMax;
                }
                verzoekGb.setAfgifteSelectieCriteria(criteria);
                BestandenlijstGBOpvragenResponse responseGb = this.retryBestandenLijstGBOpvragen(gds2, requestGb);
                int aantalInAntwoord = responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB().size();
                this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                this.config.addLogLine("Aantal in antwoord: " + aantalInAntwoord);
                boolean hasMore = responseGb.getAntwoord().getMeerAfgiftesbeschikbaar().equalsIgnoreCase("true");
                this.l.addLog("Meer afgiftes beschikbaar: " + hasMore);
                this.config.addLogLine("Meer afgiftes beschikbaar: " + hasMore);
                if (hasMore && "true".equals(alGerapporteerd)) {
                    reducePeriod = true;
                    morePeriods2Process = true;
                    increasePeriod = false;
                    if (parseblePeriod) continue;
                    morePeriods2Process = false;
                }
                afgiftesGb.addAll(responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB());
                int moreCount = 0;
                String dontGetMoreConfig = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_niet_gerapporteerde_afgiftes_niet_ophalen")));
                while (hasMore && !"true".equals(dontGetMoreConfig)) {
                    this.l.updateStatus("Uitvoeren SOAP request naar Kadaster voor meer afgiftes..." + moreCount++);
                    criteria.setNogNietGerapporteerd(Boolean.valueOf(true));
                    responseGb = this.retryBestandenLijstGBOpvragen(gds2, requestGb);
                    List afgiftes = responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB();
                    for (AfgifteGBType t : afgiftes) {
                        Iterator iterator;
                        if (t.getDigikoppelingExternalDatareferences() == null || t.getDigikoppelingExternalDatareferences().getDataReference() == null || !(iterator = t.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) continue;
                        DataReference dr = (DataReference)iterator.next();
                        log.info((Object)("GDS2url te downloaden: " + dr.getTransport().getLocation().getSenderUrl().getValue()));
                    }
                    afgiftesGb.addAll(afgiftes);
                    aantalInAntwoord = afgiftes.size();
                    this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                    this.config.addLogLine("Aantal in antwoord: " + aantalInAntwoord);
                    hasMore = responseGb.getAntwoord().getMeerAfgiftesbeschikbaar().equalsIgnoreCase("true");
                    this.l.addLog("Nog meer afgiftes beschikbaar: " + hasMore);
                    this.config.addLogLine("Nog meer afgiftes beschikbaar: " + hasMore);
                }
            } while (morePeriods2Process);
            this.l.total((long)afgiftesGb.size());
            this.l.addLog("Totaal aantal op te halen berichten: " + afgiftesGb.size());
            this.config.addLogLine("Totaal aantal op te halen berichten: " + afgiftesGb.size());
            this.verwerkAfgiftes(afgiftesGb);
        }
        catch (Exception e) {
            log.error((Object)"Fout bij ophalen van GDS2 berichten", (Throwable)e);
            this.config.setLastrun(new Date());
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            String m = "Fout bij ophalen van GDS2 berichten: " + ExceptionUtils.getMessage((Throwable)e);
            if (e.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            }
            this.config.addLogLine(m);
            this.l.exception((Throwable)e);
        }
        finally {
            if (Stripersist.getEntityManager().getTransaction().getRollbackOnly()) {
                Stripersist.getEntityManager().getTransaction().rollback();
            } else {
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().getTransaction().commit();
            }
            this.l.updateStatus("Uitvoeren SOAP request naar Kadaster afgerond");
        }
    }

    private BestandenlijstGBOpvragenResponse retryBestandenLijstGBOpvragen(Gds2AfgifteServiceV20130701 gds2, BestandenlijstGBOpvragenRequest requestGb) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return gds2.bestandenlijstGBOpvragen(requestGb);
            }
            catch (Exception e) {
                if (++attempt == 5) {
                    this.l.addLog("Fout bij laatste poging ophalen bestandenlijst: " + e.getClass().getName() + ": " + e.getMessage());
                    throw e;
                }
                this.l.addLog("Fout bij poging " + attempt + " om bestandenlijst op te halen: " + e.getClass().getName() + ": " + e.getMessage());
                Thread.sleep(10000L);
                this.l.addLog("Uitvoeren poging " + (attempt + 1) + " om bestandenlijst op te halen...");
                continue;
            }
            break;
        }
    }

    private String getLaadprocesBestansanaam(AfgifteGBType a) {
        return a.getBestand().getBestandsnaam() + " (" + a.getAfgifteID() + ")";
    }

    private boolean isAfgifteAlGeladen(AfgifteGBType a, String url) {
        try {
            Stripersist.getEntityManager().createQuery("select 1 from LaadProces lp where lp.bestand_naam = :n").setParameter("n", (Object)this.getLaadprocesBestansanaam(a)).getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    private Bericht laadAfgifte(AfgifteGBType a, String url) throws Exception {
        Object input;
        String msg = "Downloaden " + url;
        this.l.updateStatus(msg);
        this.l.addLog(msg);
        this.config.addLogLine(msg);
        HttpsURLConnection.setDefaultSSLSocketFactory(this.context.getSocketFactory());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int attempt = 0;
        while (true) {
            try {
                URLConnection connection = new URL(url).openConnection();
                input = (InputStream)connection.getContent();
                IOUtils.copy((InputStream)input, (OutputStream)bos);
            }
            catch (Exception e) {
                if (++attempt == 5) {
                    this.l.addLog("Fout bij laatste poging downloaden afgifte: " + e.getClass().getName() + ": " + e.getMessage());
                    throw e;
                }
                this.l.addLog("Fout bij poging " + attempt + " om afgifte te downloaden: " + e.getClass().getName() + ": " + e.getMessage());
                Thread.sleep(3000L);
                this.l.addLog("Uitvoeren poging " + (attempt + 1) + " om afgifte " + url + " te downloaden...");
                continue;
            }
            break;
        }
        LaadProces lp = new LaadProces();
        lp.setBestand_naam(this.getLaadprocesBestansanaam(a));
        if (a.getDigikoppelingExternalDatareferences() != null && a.getDigikoppelingExternalDatareferences().getDataReference() != null && (input = a.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) {
            DataReference dr = (DataReference)input.next();
            lp.setBestand_datum(dr.getLifetime().getCreationTime().getValue().toGregorianCalendar().getTime());
        }
        lp.setSoort("brk");
        lp.setStatus(LaadProces.STATUS.STAGING_OK);
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        lp.setOpmerking("GDS2 download van " + url + " op " + sdf.format(new Date()));
        lp.setAutomatischProces((AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.config.getId()));
        Bericht b = new Bericht();
        b.setLaadprocesid(lp);
        b.setDatum(lp.getBestand_datum());
        b.setSoort("brk");
        b.setStatus_datum(new Date());
        ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null && !entry.getName().toLowerCase().endsWith(".xml")) {
            msg = "Overslaan zip entry geen XML: " + entry.getName();
            this.l.addLog(msg);
            this.config.addLogLine(msg);
            entry = zip.getNextEntry();
        }
        if (entry == null) {
            msg = "Geen geschikt XML bestand gevonden in zip bestand!";
            this.l.addLog(msg);
            this.config.addLogLine(msg);
            return null;
        }
        b.setBr_orgineel_xml(IOUtils.toString((InputStream)zip, (String)"UTF-8"));
        if (log.isDebugEnabled()) {
            String fName = "/tmp/" + lp.getBestand_naam() + ".xml";
            log.debug((Object)("Dump xml bericht naar: " + fName));
            IOUtils.write((String)b.getBr_orgineel_xml(), (Writer)new FileWriter(fName));
        }
        try {
            BrkSnapshotXMLReader reader = new BrkSnapshotXMLReader((InputStream)new ByteArrayInputStream(b.getBr_orgineel_xml().getBytes("UTF-8")));
            BrkBericht bericht = reader.next();
            if (bericht.getDatum() != null) {
                b.setDatum(bericht.getDatum());
            }
            b.setBr_xml(bericht.getBrXml());
            b.setVolgordenummer(bericht.getVolgordeNummer());
            String objectRef = bericht.getObjectRef();
            if (objectRef != null && !objectRef.isEmpty()) {
                b.setObject_ref(bericht.getObjectRef());
                b.setStatus(Bericht.STATUS.STAGING_OK);
                b.setOpmerking("Klaar voor verwerking.");
            } else {
                b.setStatus(Bericht.STATUS.STAGING_NOK);
                b.setOpmerking("Object Ref niet gevonden in bericht-xml, neem contact op met leverancier.");
            }
        }
        catch (Exception e) {
            b.setStatus(Bericht.STATUS.STAGING_NOK);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            b.setOpmerking("Fout bij parsen BRK bericht: " + sw.toString());
        }
        Stripersist.getEntityManager().persist((Object)lp);
        Stripersist.getEntityManager().persist((Object)b);
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
        return b;
    }

    public static boolean doorsturenBericht(AutomatischProces proces, ProgressUpdateListener l, Bericht b, String endpoint) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            String msg;
            if (endpoint == null || endpoint.length() < 1) {
                return false;
            }
            URL url = new URL(endpoint);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", "" + b.getBr_orgineel_xml().length());
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            IOUtils.copy((InputStream)IOUtils.toInputStream((String)b.getBr_orgineel_xml(), (String)"UTF-8"), (OutputStream)conn.getOutputStream());
            conn.disconnect();
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 201 || conn.getResponseCode() == 202) {
                msg = "Bericht " + b.getObject_ref() + " op " + sdf.format(new Date()) + " doorgestuurd naar " + endpoint;
                b.setStatus(Bericht.STATUS.STAGING_FORWARDED);
            } else {
                msg = String.format("HTTP foutcode bij doorsturen bericht %s op %s naar endpoint %s: %s", b.getObject_ref(), sdf.format(new Date()), endpoint, conn.getResponseCode() + ": " + conn.getResponseMessage());
                b.setStatus(Bericht.STATUS.STAGING_NOK);
            }
            b.setOpmerking(msg);
            proces.addLogLine(msg);
            l.addLog(msg);
            return b.getStatus() == Bericht.STATUS.STAGING_FORWARDED;
        }
        catch (Exception e) {
            String msg = String.format("Fout bij doorsturen bericht op %s naar endpoint %s: %s", sdf.format(new Date()), endpoint, e.getClass() + ": " + e.getMessage());
            b.setOpmerking(msg);
            b.setStatus(Bericht.STATUS.STAGING_NOK);
            proces.addLogLine(msg);
            l.addLog(msg);
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private GregorianCalendar getDatumTijd(String dateStr) {
        Date date;
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
        if (dateStr.equalsIgnoreCase("nu")) {
            date = new Date();
        } else {
            try {
                date = format.parse(dateStr);
            }
            catch (ParseException ex) {
                log.error((Object)ex);
                return null;
            }
        }
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(date);
        return gregory;
    }

    private GregorianCalendar getDatumTijd(String refDate, int before) {
        GregorianCalendar ref = this.getDatumTijd(refDate);
        ref.add(6, before);
        return ref;
    }

    private XMLGregorianCalendar getXMLDatumTijd(GregorianCalendar gregory) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory);
        }
        catch (DatatypeConfigurationException ex) {
            log.error((Object)ex);
            return null;
        }
    }

    private void verwerkAfgiftes(List<AfgifteGBType> afgiftesGb) throws Exception {
        int filterAlVerwerkt = 0;
        int aantalGeladen = 0;
        int aantalDoorgestuurd = 0;
        int progress = 0;
        ArrayList<Long> geladenBerichtIds = new ArrayList<Long>();
        String doorsturenUrl = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("delivery_endpoint")));
        for (AfgifteGBType a : afgiftesGb) {
            Iterator iterator;
            String url = null;
            if (a.getDigikoppelingExternalDatareferences() != null && a.getDigikoppelingExternalDatareferences().getDataReference() != null && (iterator = a.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) {
                DataReference dr = (DataReference)iterator.next();
                url = dr.getTransport().getLocation().getSenderUrl().getValue();
            }
            if (url != null) {
                if (this.isAfgifteAlGeladen(a, url)) {
                    ++filterAlVerwerkt;
                } else {
                    Bericht b = this.laadAfgifte(a, url);
                    if (b != null && doorsturenUrl != null) {
                        geladenBerichtIds.add(b.getId());
                    }
                    ++aantalGeladen;
                }
            }
            this.l.progress((long)(++progress));
        }
        if (doorsturenUrl != null && !geladenBerichtIds.isEmpty()) {
            this.l.addLog("Doorsturen van de opgehaalde berichten, in totaal " + geladenBerichtIds.size());
            this.l.total((long)geladenBerichtIds.size());
            progress = 0;
            for (Long bId : geladenBerichtIds) {
                Bericht b = (Bericht)Stripersist.getEntityManager().find(Bericht.class, (Object)bId);
                this.l.updateStatus("Doorsturen bericht: " + b.getObject_ref());
                GDS2OphalenProces.doorsturenBericht((AutomatischProces)this.config, (ProgressUpdateListener)this.l, (Bericht)b, (String)doorsturenUrl);
                Stripersist.getEntityManager().merge((Object)b);
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
                Stripersist.getEntityManager().getTransaction().commit();
                Stripersist.getEntityManager().clear();
                ++aantalDoorgestuurd;
                this.l.progress((long)(++progress));
            }
        }
        this.l.addLog("\n\n**** resultaat ****\n");
        this.l.addLog("Aantal afgiftes die al waren verwerkt: " + filterAlVerwerkt);
        this.l.addLog("\nAantal afgiftes geladen: " + aantalGeladen);
        this.l.addLog("\nAantal afgiftes doorgestuurd: " + aantalDoorgestuurd + "\n");
        this.l.addLog(String.format("Het GDS2 ophalen proces met ID %d is afgerond op %tc", this.config.getId(), Calendar.getInstance()));
        this.config.updateSamenvattingEnLogfile(String.format("Het GDS2 ophalen proces, gestart op %tc, is afgerond op %tc. \nAantal afgiftes die al waren verwerkt: %d\nAantal afgiftes geladen: %d\nAantal afgiftes doorgestuurd: %d", this.config.getLastrun(), Calendar.getInstance(), filterAlVerwerkt, aantalGeladen, aantalDoorgestuurd));
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private Gds2AfgifteServiceV20130701 initGDS2() throws Exception {
        Gds2AfgifteServiceV20130701 gds2 = new Gds2AfgifteServiceV20130701Service().getAGds2AfgifteServiceV20130701();
        BindingProvider bp = (BindingProvider)gds2;
        Map ctxt = bp.getRequestContext();
        String endpoint = (String)ctxt.get("javax.xml.ws.service.endpoint.address");
        this.l.addLog("Kadaster endpoint: " + endpoint);
        this.l.updateStatus("Laden keys...");
        this.l.addLog("Loading keystore");
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(Main.class.getResourceAsStream("/pkioverheid.jks"), "changeit".toCharArray());
        this.l.addLog("Initializing TrustManagerFactory");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(ks);
        this.l.addLog("Initializing KeyManagerFactory");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ks = KeyStore.getInstance("jks");
        char[] thePassword = "changeit".toCharArray();
        PrivateKey privateKey = GDS2OphalenProces.getPrivateKeyFromPEM((String)((ClobElement)this.config.getConfig().get("gds2_privkey")).getValue());
        Certificate certificate = GDS2OphalenProces.getCertificateFromPEM((String)((ClobElement)this.config.getConfig().get("gds2_pubkey")).getValue());
        ks.load(null);
        ks.setKeyEntry("thekey", privateKey, thePassword, new Certificate[]{certificate});
        kmf.init(ks, thePassword);
        this.l.updateStatus("Opzetten SSL context...");
        this.l.addLog("Initializing SSLContext");
        this.config.addLogLine("Initializing SSLContext");
        this.context = SSLContext.getInstance("TLS", "SunJSSE");
        this.context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLContext.setDefault(this.context);
        ctxt.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.context.getSocketFactory());
        return gds2;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

