/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProcesExecutable;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.EntityTypeConverter;
import org.stripesstuff.stripersist.Stripersist;

public class BGTOphalenUitvoerActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final String JSP = "/WEB-INF/jsp/beheer/bgtdownloaduitvoeren.jsp";
    @Validate(converter=EntityTypeConverter.class)
    private AutomatischProces proces;
    private ActionBeanContext context;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private String status;
    private String label;
    private String log = "";
    private Date start;
    private Date update;
    private String exceptionStacktrace;
    private String title;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    @WaitPage(path="/WEB-INF/jsp/beheer/bgtdownloaduitvoeren.jsp", delay=1000, refresh=1000)
    public Resolution execute() {
        if (this.proces == null) {
            this.getContext().getMessages().add(new SimpleMessage("Proces ongeldig!", new Object[0]));
            this.completed();
            return new ForwardResolution(JSP);
        }
        this.proces = (AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.proces.getId());
        ProcesExecutable exeProces = AbstractExecutableProces.getProces((AutomatischProces)this.proces);
        try {
            exeProces.execute((ProgressUpdateListener)this);
            this.proces.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        }
        catch (Exception e) {
            this.proces.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            Stripersist.getEntityManager().merge((Object)this.proces);
            this.exception((Throwable)e);
        }
        finally {
            this.completed();
            if (Stripersist.getEntityManager().getTransaction().isActive()) {
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
        return new ForwardResolution(JSP);
    }

    @Before
    public void before() {
        this.start = new Date();
    }

    @After
    public void completed() {
        this.complete = true;
        this.proces.setLastrun(this.update);
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public void updateStatus(String status) {
        this.status = status;
    }

    public void addLog(String log) {
        this.log = this.log + log + "\n";
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public AutomatischProces getProces() {
        return this.proces;
    }

    public void setProces(AutomatischProces proces) {
        this.proces = proces;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

