/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.advancedfunctions.AdvancedFunctionProcess;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.StagingRowHandler;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
public class AdvancedFunctionsActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log log = LogFactory.getLog(AdvancedFunctionsActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/transform/advancedfunctions.jsp";
    private static final String JSP_PROGRESS = "/WEB-INF/jsp/transform/advancedfunctionsprogress.jsp";
    private static final String MUTOPEN = "<?xml version=\"1.0\"?><Mutatie:Mutatie xmlns:Mutatie=\"http://www.kadaster.nl/schemas/brk-levering/product-mutatie/v20120901\" xmlns:KadastraalObjectRef=\"http://www.kadaster.nl/schemas/brk-levering/snapshot/imkad-kadastraalobject-ref/v20120201\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"><Mutatie:BRKDatum>%s</Mutatie:BRKDatum><Mutatie:volgnummerKadastraalObjectDatum>%s</Mutatie:volgnummerKadastraalObjectDatum><Mutatie:kadastraalObject><Mutatie:AanduidingKadastraalObject><Mutatie:kadastraalObject><KadastraalObjectRef:PerceelRef xlink:href=\"%s\"/></Mutatie:kadastraalObject></Mutatie:AanduidingKadastraalObject></Mutatie:kadastraalObject><Mutatie:wordt>";
    private static final String MUTCLOSE = "</Mutatie:wordt></Mutatie:Mutatie>";
    private ActionBeanContext context;
    private List<AdvancedFunctionProcess> advancedFunctionProcesses;
    @Validate(required=true, on={"perform"})
    private String advancedFunctionProcessName;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private Date start;
    private Date update;
    private String exceptionStacktrace;
    private final String BRK_VERWIJDEREN_NOGMAALS_UITVOEREN = "Herhaal transformatie BRK verwijderberichten, oplossen achtergebleven 'kad_onrrnd_zk' records";
    private final boolean repairFirst = false;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public List<AdvancedFunctionProcess> getAdvancedFunctionProcesses() {
        return this.advancedFunctionProcesses;
    }

    public void setAdvancedFunctionProcesses(List<AdvancedFunctionProcess> advancedFunctionProcesses) {
        this.advancedFunctionProcesses = advancedFunctionProcesses;
    }

    public String getAdvancedFunctionProcessName() {
        return this.advancedFunctionProcessName;
    }

    public void setAdvancedFunctionProcessName(String advancedFunctionProcessName) {
        this.advancedFunctionProcessName = advancedFunctionProcessName;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void populateAdvancedFunctionProcesses() {
        this.advancedFunctionProcesses = Arrays.asList(new AdvancedFunctionProcess("Exporteren BRK mutaties", "brk", "/tmp/brkmutaties"), new AdvancedFunctionProcess("Repareren BRK mutaties met status STAGING_NOK", "brk", Bericht.STATUS.STAGING_NOK.toString()), new AdvancedFunctionProcess("Repareren BAG mutaties met status STAGING_NOK", "bag", Bericht.STATUS.STAGING_NOK.toString()), new AdvancedFunctionProcess("Opschonen en archiveren van BRK berichten met status RSGB_OK, ouder dan 3 maanden", "brk", Bericht.STATUS.RSGB_OK.toString()), new AdvancedFunctionProcess("Opschonen en archiveren van BAG berichten met status RSGB_OK, ouder dan 3 maanden", "bag", Bericht.STATUS.RSGB_OK.toString()), new AdvancedFunctionProcess("Verwijderen van BRK berichten met status ARCHIVE", "brk", Bericht.STATUS.ARCHIVE.toString()), new AdvancedFunctionProcess("Verwijderen van BAG berichten met status ARCHIVE", "bag", Bericht.STATUS.ARCHIVE.toString()), new AdvancedFunctionProcess("Herhaal transformatie BRK verwijderberichten, oplossen achtergebleven 'kad_onrrnd_zk' records", "brk", Bericht.STATUS.RSGB_OK.toString()));
    }

    @DefaultHandler
    public Resolution form() {
        return new ForwardResolution(this.complete ? JSP_PROGRESS : JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/transform/advancedfunctionsprogress.jsp", delay=1000, refresh=1000)
    public Resolution perform() {
        AdvancedFunctionProcess process = null;
        for (AdvancedFunctionProcess p : this.advancedFunctionProcesses) {
            if (!p.getName().equals(this.advancedFunctionProcessName)) continue;
            process = p;
            break;
        }
        if (process == null) {
            this.getContext().getMessages().add(new SimpleMessage("Ongeldig proces", new Object[0]));
            return new ForwardResolution(JSP);
        }
        this.start = new Date();
        log.info((Object)("Start export process: " + process.getName()));
        this.processed = 0L;
        try {
            if (process.getName().equals("Exporteren BRK mutaties")) {
                this.exportBRKMutatieBerichten(process.getConfig());
            } else if (process.getName().equals("Repareren BRK mutaties met status STAGING_NOK")) {
                this.repairBRKMutatieBerichten(process.getConfig());
            } else if (process.getName().equals("Repareren BAG mutaties met status STAGING_NOK")) {
                this.repairBAGMutatieBerichten(process.getConfig());
            } else if (process.getName().equals("Opschonen en archiveren van BRK berichten met status RSGB_OK, ouder dan 3 maanden")) {
                this.cleanupBerichten(process.getConfig(), "brk");
            } else if (process.getName().equals("Opschonen en archiveren van BAG berichten met status RSGB_OK, ouder dan 3 maanden")) {
                this.cleanupBerichten(process.getConfig(), "bag");
            } else if (process.getName().equals("Verwijderen van BRK berichten met status ARCHIVE")) {
                this.deleteBerichten(process.getConfig(), "brk");
            } else if (process.getName().equals("Verwijderen van BAG berichten met status ARCHIVE")) {
                this.deleteBerichten(process.getConfig(), "bag");
            } else if (process.getName().equals("Herhaal transformatie BRK verwijderberichten, oplossen achtergebleven 'kad_onrrnd_zk' records")) {
                this.replayBRKVerwijderBerichten(process.getSoort(), process.getConfig());
            }
            if (this.exceptionStacktrace == null) {
                this.getContext().getMessages().add(new SimpleMessage("Geavanceerde functie afgerond.", new Object[0]));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij geavanceerd functie", t);
            String m = "Fout bij geavanceerd functie: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            this.complete = true;
        }
        return new ForwardResolution(JSP_PROGRESS);
    }

    public void repairBRKMutatieBerichten(String config) throws Exception {
        int offset = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        do {
            log.debug((Object)String.format("Ophalen mutatieberichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where volgordenummer >= 0  and soort='brk'  and status='" + config + "' order by id ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    public void repairBAGMutatieBerichten(String config) throws Exception {
        int offset = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        do {
            log.debug((Object)String.format("Ophalen BAG mutatieberichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where volgordenummer >= 0  and soort='bag'  and status='" + config + "' order by id ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    public void exportBRKMutatieBerichten(String locatie) throws Exception {
        int offset = 0;
        int batch = 5000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        File exportDir = new File(locatie);
        FileUtils.forceMkdir((File)exportDir);
        do {
            log.debug((Object)String.format("Ophalen mutatieberichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where volgordenummer >= 0  and soort='brk'  order by object_ref, datum, volgordenummer ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            File f = new File(exportDir, "batch" + offset + ".zip");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (out != null) {
                out.close();
            }
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    public void cleanupBerichten(String config, String soort) throws Exception {
        int offset = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -3);
        String countsql = "select count(*) from bericht where soort='" + soort + "'  and status='" + config + "' and status_datum < ? ";
        Object o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (Object)new Timestamp(c.getTimeInMillis()), (ResultSetHandler)new ScalarHandler());
        if (o instanceof BigDecimal) {
            this.total(((BigDecimal)o).longValue());
        } else if (o instanceof Integer) {
            this.total(((Integer)o).longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        do {
            log.debug((Object)String.format("Ophalen berichten batch met offset %d, limit %d, tot datum %tc", offset, batch, c));
            String sql = "select * from bericht where soort='" + soort + "'  and status='" + config + "' and status_datum < ?  order by id ";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (Object)new Timestamp(c.getTimeInMillis()), (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
    }

    public void deleteBerichten(String config, String soort) throws Exception {
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        String countsql = "select count(*) from bericht where soort='" + soort + "'  and status='" + config + "'";
        Object o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler());
        if (o instanceof BigDecimal) {
            this.total(((BigDecimal)o).longValue());
        } else if (o instanceof Integer) {
            this.total(((Integer)o).longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        log.debug((Object)("Totaal te verwijderen " + config + " berichten: " + o));
        o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "DELETE FROM bericht WHERE soort='" + soort + "'  and status='" + config + "'");
        if (o instanceof BigDecimal) {
            this.progress(((BigDecimal)o).longValue());
        } else if (o instanceof Integer) {
            this.progress(((Integer)o).longValue());
        } else {
            this.progress(((Long)o).longValue());
        }
    }

    public void replayBRKVerwijderBerichten(String soort, String status) throws SQLException, BrmoException, Exception {
        int offset = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        log.debug((Object)("staging datasource: " + dataSourceStaging));
        log.debug((Object)("rsgb datasource: " + dataSourceRsgb));
        String countsql = "select count(id) from bericht where soort='" + soort + "' and status='" + status + "' and br_xml like '<empty/>'";
        log.debug((Object)("SQL voor tellen van berichten batch: " + countsql));
        Object o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler());
        log.debug((Object)("Totaal te verwerken verwijder berichten: " + o));
        if (o instanceof BigDecimal) {
            this.total(((BigDecimal)o).longValue());
        } else if (o instanceof Integer) {
            this.total(((Integer)o).longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        StagingProxy staging = new StagingProxy(dataSourceStaging);
        RsgbProxy rsgb = new RsgbProxy(dataSourceRsgb, staging, Bericht.STATUS.RSGB_OK, (ProgressUpdateListener)this);
        rsgb.setOrderBerichten(true);
        rsgb.init();
        do {
            log.debug((Object)String.format("Ophalen berichten batch met offset %d, limit %d", offset, batch));
            String sql = "select * from bericht where soort='" + soort + "' and status='" + status + "' and br_xml like '<empty/>' order by id";
            sql = geomToJdbc.buildPaginationSql(sql, offset, batch);
            log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            throw e;
        } while (processed.intValue() > 0);
        rsgb.close();
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

