/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BAGScannerProces;
import nl.b3p.brmo.persistence.staging.BGTLightOphaalProces;
import nl.b3p.brmo.persistence.staging.BGTLightScannerProces;
import nl.b3p.brmo.persistence.staging.BRKScannerProces;
import nl.b3p.brmo.persistence.staging.BerichtDoorstuurProces;
import nl.b3p.brmo.persistence.staging.BerichtTransformatieProces;
import nl.b3p.brmo.persistence.staging.BerichtstatusRapportProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.GDS2OphaalProces;
import nl.b3p.brmo.persistence.staging.LaadprocesTransformatieProces;
import nl.b3p.brmo.persistence.staging.MailRapportageProces;
import nl.b3p.brmo.persistence.staging.MaterializedViewRefresh;
import nl.b3p.brmo.persistence.staging.WebMirrorBAGScannerProces;
import nl.b3p.brmo.service.jobs.GeplandeTakenInit;
import nl.b3p.brmo.service.scanner.ProcesExecutable;
import nl.b3p.brmo.service.stripes.OphaalConfigActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.stripesstuff.stripersist.EntityTypeConverter;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class OphaalConfigActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(OphaalConfigActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/beheer/processenophalen.jsp";
    private ActionBeanContext context;
    private List<AutomatischProces> processen = new ArrayList();
    @Validate(converter=EntityTypeConverter.class)
    @ValidateNestedProperties(value={@Validate(field="cronExpressie")})
    private AutomatischProces proces;
    @Validate
    private ProcesExecutable.ProcessingImple type;
    @Validate
    private Map<String, ClobElement> config = new HashMap();

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void load() {
        this.processen = Stripersist.getEntityManager().createQuery("from AutomatischProces p order by type(p),p.id").getResultList();
    }

    @DefaultHandler
    public Resolution view() {
        if (this.proces != null) {
            this.config = this.proces.getConfig();
        }
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution cancel() {
        return new RedirectResolution(OphaalConfigActionBean.class);
    }

    @DontValidate
    public Resolution delete() {
        if (this.proces != null) {
            Stripersist.getEntityManager().createQuery("update LaadProces set automatischProces = null where automatischProces = :this").setParameter("this", (Object)this.proces).executeUpdate();
            Stripersist.getEntityManager().remove((Object)this.proces);
            this.load();
            Stripersist.getEntityManager().getTransaction().commit();
            this.deleteScheduledJob(this.proces);
            this.proces = null;
            this.getContext().getMessages().add(new SimpleMessage("Proces is verwijderd", new Object[0]));
        }
        return new ForwardResolution(JSP);
    }

    @DontValidate
    public Resolution add() {
        return new ForwardResolution(JSP).addParameter("type", new Object[]{this.type});
    }

    public Resolution save() {
        if (this.proces == null) {
            this.proces = this.getProces(this.type);
        }
        this.proces.getConfig().clear();
        this.proces.getConfig().putAll(this.config);
        if (this.proces instanceof BerichtDoorstuurProces) {
            String id = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.get("gds2_ophaalproces_id")));
            GDS2OphaalProces p = (GDS2OphaalProces)Stripersist.getEntityManager().find(GDS2OphaalProces.class, (Object)Long.parseLong(id));
            if (p != null) {
                String label = ClobElement.nullSafeGet((ClobElement)((ClobElement)p.getConfig().get("label")));
                this.proces.getConfig().put("label", new ClobElement("Doorsturen " + label + " afgiftes"));
            }
        }
        Stripersist.getEntityManager().persist((Object)this.proces);
        this.load();
        Stripersist.getEntityManager().getTransaction().commit();
        this.getContext().getMessages().add(new SimpleMessage("Proces is opgeslagen", new Object[0]));
        try {
            this.updateJobSchedule(this.proces);
        }
        catch (SchedulerException ex) {
            this.getContext().getMessages().add(new SimpleError("Er is een fout opgetreden tijdens inplannen van de taak. {2}", new Object[]{ex.getMessage()}));
        }
        return new ForwardResolution(JSP).addParameter("proces", new Object[]{this.proces.getId()});
    }

    private AutomatischProces getProces(ProcesExecutable.ProcessingImple type) {
        switch (1.$SwitchMap$nl$b3p$brmo$service$scanner$ProcesExecutable$ProcessingImple[type.ordinal()]) {
            case 1: {
                return new BAGScannerProces();
            }
            case 2: {
                return new BRKScannerProces();
            }
            case 3: {
                return new MailRapportageProces();
            }
            case 4: {
                return new GDS2OphaalProces();
            }
            case 5: {
                return new BerichtTransformatieProces();
            }
            case 6: {
                return new BerichtDoorstuurProces();
            }
            case 7: {
                return new WebMirrorBAGScannerProces();
            }
            case 8: {
                return new BGTLightScannerProces();
            }
            case 9: {
                return new BGTLightOphaalProces();
            }
            case 10: {
                return new LaadprocesTransformatieProces();
            }
            case 11: {
                return new MaterializedViewRefresh();
            }
            case 12: {
                return new BerichtstatusRapportProces();
            }
        }
        throw new IllegalArgumentException(type.name() + " is geen ondersteund proces type...");
    }

    private ProcesExecutable.ProcessingImple getType(AutomatischProces p) {
        return ProcesExecutable.ProcessingImple.valueOf((String)p.getClass().getSimpleName());
    }

    private void updateJobSchedule(AutomatischProces p) throws SchedulerException {
        log.debug((Object)("Update scheduled job:" + p.getId()));
        StdSchedulerFactory factory = (StdSchedulerFactory)this.getContext().getServletContext().getAttribute("BRMO_qtz_factory");
        Scheduler scheduler = factory.getScheduler("BRMOgeplandeTaken");
        JobKey key = new JobKey("proces_" + p.getId());
        log.debug((Object)("Jobkey voor id " + p.getId() + " gevonden? " + scheduler.checkExists(key)));
        scheduler.deleteJob(key);
        if (p.getCronExpressie() != null) {
            GeplandeTakenInit.addJobDetails((Scheduler)scheduler, (AutomatischProces)p);
        }
    }

    private void deleteScheduledJob(AutomatischProces p) {
        try {
            p.setCronExpressie(null);
            this.updateJobSchedule(p);
        }
        catch (SchedulerException se) {
            log.warn((Object)"Ingeplande taak uit de planner halen is mislukt", (Throwable)se);
        }
    }

    @ValidationMethod(on={"save"})
    public void validateCronExpressie() {
        if (this.proces != null) {
            String expr = this.proces.getCronExpressie();
            try {
                if (expr != null) {
                    CronExpression cronExpression = new CronExpression(expr);
                }
            }
            catch (ParseException ex) {
                this.getContext().getValidationErrors().add("cronExpressie", (ValidationError)new SimpleError("{0} {2} is ongeldig.", new Object[]{expr}));
            }
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<AutomatischProces> getProcessen() {
        return this.processen;
    }

    public void setProcessen(List<AutomatischProces> processen) {
        this.processen = processen;
    }

    public AutomatischProces getProces() {
        return this.proces;
    }

    public void setProces(AutomatischProces proces) {
        this.proces = proces;
        this.type = this.getType(proces);
    }

    public Map<String, ClobElement> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, ClobElement> config) {
        this.config = config;
    }

    public ProcesExecutable.ProcessingImple getType() {
        return this.type;
    }

    public void setType(ProcesExecutable.ProcessingImple type) {
        this.type = type;
        this.proces = this.getProces(type);
    }
}

