/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Transient;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.MaterializedViewRefresh;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class MaterializedViewRefreshUitvoeren
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(MaterializedViewRefreshUitvoeren.class);
    private final MaterializedViewRefresh config;
    @Transient
    private ProgressUpdateListener listener;

    public MaterializedViewRefreshUitvoeren(MaterializedViewRefresh config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        String msg = String.format("De materialized view ververser met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.updateStatus(msg);
        listener.addLog(msg);
        String mview = "onbekend";
        try {
            mview = this.config.getMView();
            DataSource ds = ConfigUtil.getDataSourceRsgb();
            Connection conn = ds.getConnection();
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            Integer o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, geomToJdbc.getMViewRefreshSQL(mview));
            LOG.debug((Object)("mview update resultaat: " + o));
            String resultaat = null;
            resultaat = geomToJdbc.getGeotoolsDBTypeName().equalsIgnoreCase("oracle") ? (((Object)o).toString().equals("1") ? "OK" : "NOT OK") : (((Object)o).toString().equals("0") ? "OK" : "NOT OK");
            msg = String.format("De materialized view %s is ververst met resultaat %s om %tc", mview, resultaat, Calendar.getInstance());
            LOG.info((Object)msg);
            listener.updateStatus(msg);
            listener.addLog(msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setLastrun(new Date());
        }
        catch (SQLException | BrmoException e) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            LOG.error((Object)("Fout tijdens verversen materialized view: " + mview), e);
            listener.exception(e);
        }
        finally {
            Stripersist.getEntityManager().merge((Object)this.config);
        }
    }

    public static List<String> mviews() {
        try {
            DataSource ds = ConfigUtil.getDataSourceRsgb();
            Connection conn = ds.getConnection();
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            List mviews = (List)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, geomToJdbc.getMViewsSQL(), (ResultSetHandler)new ColumnListHandler());
            mviews.sort(String::compareToIgnoreCase);
            return Collections.unmodifiableList(mviews);
        }
        catch (ClassCastException | IllegalArgumentException | UnsupportedOperationException | SQLException | BrmoException ex) {
            LOG.error((Object)"Ophalen materialized views is mislukt.", ex);
            return Collections.EMPTY_LIST;
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

