/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.stripesstuff.stripersist.Stripersist;

public class AutomatischProcesJob
implements Job {
    private static final Log log = LogFactory.getLog(AutomatischProcesJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Long id = null;
        AutomatischProces p = null;
        try {
            id = context.getJobDetail().getJobDataMap().getLongValue("id");
            log.debug((Object)("Poging gepland automatisch proces met id: " + id + " te starten."));
            Stripersist.requestInit();
            p = (AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)id);
            if (p != null) {
                p.addLogLine(String.format("Geplande taak gestart op %tc.", new Date()));
                AbstractExecutableProces.getProces((AutomatischProces)p).execute();
                p.addLogLine(String.format("Geplande taak afgerond op %tc.", new Date()));
                p.setLastrun(new Date());
                Stripersist.getEntityManager().merge((Object)p);
                Stripersist.getEntityManager().flush();
                log.debug((Object)("Gepland automatisch proces met " + id + " is afgerond."));
            } else {
                log.warn((Object)("Automatisch proces met id:" + id + " bestaat niet."));
            }
        }
        catch (ClassCastException cce) {
            log.warn((Object)"Geen geldige ID gevonden in de jobdata map.", (Throwable)cce);
        }
        catch (BrmoException ex) {
            if (p != null) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                p.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                p.updateSamenvattingEnLogfile(String.format("Fout tijdens starten of uitvoeren van automatische proces met id %s: %s ", id, sw.toString()));
                Stripersist.getEntityManager().merge((Object)p);
            }
            log.error((Object)("Fout tijdens starten of uitvoeren van automatische proces met id: " + id), (Throwable)ex);
        }
        finally {
            if (Stripersist.getEntityManager().getTransaction().isActive()) {
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
    }
}

