/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.updates.UpdateProcess;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
public class UpdatesActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log log = LogFactory.getLog(UpdatesActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/transform/updates.jsp";
    private static final String JSP_PROGRESS = "/WEB-INF/jsp/transform/updateprogress.jsp";
    private ActionBeanContext context;
    private List<UpdateProcess> updateProcesses;
    @Validate(required=true, on={"update"})
    private String updateProcessName;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private Date start;
    private Date update;
    private String exceptionStacktrace;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public List<UpdateProcess> getUpdateProcesses() {
        return this.updateProcesses;
    }

    public void setUpdateProcesses(List<UpdateProcess> updateProcesses) {
        this.updateProcesses = updateProcesses;
    }

    public String getUpdateProcessName() {
        return this.updateProcessName;
    }

    public void setUpdateProcessName(String updateProcessName) {
        this.updateProcessName = updateProcessName;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void populateUpdateProcesses() {
        this.updateProcesses = Arrays.asList(new UpdateProcess("Toevoegen BSN aan ingeschreven natuurlijk persoon", "brk", "/xsl/update-bsn.xsl"), new UpdateProcess("Toevoegen RSIN aan ingeschreven niet-natuurlijk persoon", "brk", "/xsl/update-rsin.xsl"), new UpdateProcess("Bijwerken van omschrijving, datum en ref_id in brondocument", "brk", "/xsl/update-brondocument.xsl"), new UpdateProcess("Bijwerken van onvolledig adres", "brk", "/xsl/update-incompleetadres.xsl"), new UpdateProcess("Bijwerken van rechthebbende VVE op zakelijk recht", "brk", "/xsl/update-zak_recht-vve.xsl"));
    }

    @DefaultHandler
    public Resolution form() {
        return new ForwardResolution(this.complete ? JSP_PROGRESS : JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/transform/updateprogress.jsp", delay=1000, refresh=1000)
    public Resolution update() {
        UpdateProcess process = null;
        for (UpdateProcess p : this.updateProcesses) {
            if (!p.getName().equals(this.updateProcessName)) continue;
            process = p;
            break;
        }
        if (process == null) {
            this.getContext().getMessages().add(new SimpleMessage("Ongeldig proces", new Object[0]));
            return new ForwardResolution(JSP);
        }
        this.start = new Date();
        log.info((Object)("Start update process: " + process.getName()));
        BrmoFramework brmo = null;
        try {
            String errorState;
            String batchString;
            String capacityString;
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
            brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb);
            boolean enableTransformPipeline = "true".equals(this.getContext().getServletContext().getInitParameter("pipelining.enabled"));
            brmo.setEnablePipeline(enableTransformPipeline);
            if (enableTransformPipeline && (capacityString = this.getContext().getServletContext().getInitParameter("pipelining.capacity")) != null) {
                brmo.setTransformPipelineCapacity(Integer.parseInt(capacityString));
            }
            if ((batchString = this.getContext().getServletContext().getInitParameter("batch.capacity")) != null) {
                brmo.setBatchCapacity(Integer.parseInt(batchString));
            }
            if ((errorState = this.getContext().getServletContext().getInitParameter("error.state")) != null) {
                brmo.setErrorState(errorState);
            }
            Thread t = brmo.toRsgb(process, (ProgressUpdateListener)this);
            t.join();
            if (this.exceptionStacktrace == null) {
                this.getContext().getMessages().add(new SimpleMessage("Transformatie afgerond, controleer berichtenstatus.", new Object[0]));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij updaten", t);
            String m = "Fout bij updaten: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
            this.complete = true;
        }
        return new ForwardResolution(JSP_PROGRESS);
    }
}

