/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.service.stripes.BasisregistratieFileUploadActionBean;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
public class BasisregistratieFileUploadActionBean
implements ActionBean {
    private static final int ZIP_HEADER = 1347093252;
    private static final Log log = LogFactory.getLog(BasisregistratieFileUploadActionBean.class);
    private ActionBeanContext context;
    @Validate(required=true)
    private String basisregistratie;
    @Validate(required=true)
    private FileBean bestand;

    @DefaultHandler
    @DontValidate
    public Resolution form() {
        return new ForwardResolution("/WEB-INF/jsp/bestand/form.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution upload() throws BrmoException {
        DataSource ds = ConfigUtil.getDataSourceStaging();
        BrmoFramework brmo = null;
        brmo = new BrmoFramework(ds, null);
        ZipInputStream zip = null;
        ZipEntry entry = null;
        int errors = 0;
        int empty = 0;
        int duplicate = 0;
        int ERROR_LIMIT = 5;
        try {
            MutableLong theTotal = new MutableLong(0L);
            int extractedFiles = 0;
            1 totalAdder = new /* Unavailable Anonymous Inner Class!! */;
            BufferedInputStream in = new BufferedInputStream(this.bestand.getInputStream());
            ((InputStream)in).mark(4);
            int header = new DataInputStream(in).readInt();
            ((InputStream)in).reset();
            if (header == 1347093252) {
                zip = new ZipInputStream(in);
                try {
                    entry = zip.getNextEntry();
                    while (entry != null) {
                        if (!entry.getName().toLowerCase().endsWith(".xml")) {
                            log.warn((Object)("Overslaan zip entry geen XML: " + entry.getName()));
                        } else {
                            block25: {
                                log.debug((Object)("Lezen XML bestand uit zip: " + entry.getName()));
                                try {
                                    brmo.loadFromStream(this.basisregistratie, (InputStream)new CloseShieldInputStream((InputStream)zip), this.bestand.getFileName() + "/" + entry.getName(), (ProgressUpdateListener)totalAdder);
                                }
                                catch (BrmoLeegBestandException e) {
                                    log.info((Object)("Negeer ZIP entry " + entry.getName() + ": " + e.getMessage()));
                                    ++empty;
                                }
                                catch (BrmoDuplicaatLaadprocesException e) {
                                    log.info((Object)("Negeer ZIP entry " + entry.getName() + ": duplicaat laadproces"));
                                    ++duplicate;
                                }
                                catch (BrmoException e) {
                                    log.error((Object)("BrmoException bij laden ZIP entry " + entry.getName() + (++errors > 5 ? "; afbreken" : "; doorgaan met volgende")), (Throwable)e);
                                    if (errors <= 5) break block25;
                                    throw new BrmoException("Maximum aantal fouten (5) bereikt bij inladen ZIP bestanden, inladen afgebroken. Controleer brmo-service.log", (Throwable)e);
                                }
                            }
                            ++extractedFiles;
                        }
                        entry = zip.getNextEntry();
                    }
                }
                finally {
                    zip.close();
                }
            }
            brmo.loadFromStream(this.basisregistratie, (InputStream)in, this.bestand.getFileName(), (ProgressUpdateListener)totalAdder);
            ArrayList<String> warnings = new ArrayList<String>();
            if (errors > 0) {
                warnings.add("let op: " + errors + " bericht" + (errors > 1 ? "en" : "") + " niet ingeladen wegens fouten");
            }
            if (empty > 0) {
                warnings.add("let op: " + empty + (empty > 1 ? " lege berichten" : " leeg bericht") + " overgeslagen");
            }
            if (duplicate > 0) {
                warnings.add("let op: " + duplicate + (duplicate > 1 ? " duplicate berichten" : " duplicaat bericht") + " overgeslagen");
            }
            String warning = warnings.isEmpty() ? "" : ", " + String.join((CharSequence)", ", warnings.toArray(new String[0])) + ", zie log voor bestandsnamen uit ZIP en details!";
            this.getContext().getMessages().add(new SimpleMessage("Bestand " + this.bestand.getFileName() + " is ingelezen, " + theTotal.getValue() + " berichten" + (extractedFiles > 0 ? " (uit " + extractedFiles + " uitgepakte XML bestanden)" : "") + warning, new Object[0]));
            log.info((Object)String.format("Stored %s data from file \"%s\" uploaded via form", this.basisregistratie, this.bestand.getFileName()));
        }
        catch (Exception ex) {
            String msg = "Fout bij inlezen bestand " + (zip != null && entry != null ? entry.getName() + " uit ZIP bestand " + this.bestand.getFileName() : this.bestand.getFileName());
            log.error((Object)msg, (Throwable)ex);
            this.getContext().getMessages().add(new SimpleMessage(msg + ": " + ExceptionUtils.getRootCauseMessage((Throwable)ex), new Object[0]));
        }
        finally {
            try {
                this.bestand.delete();
            }
            catch (IOException iOException) {}
            brmo.closeBrmoFramework();
        }
        return new ForwardResolution("/WEB-INF/jsp/bestand/form.jsp");
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getBasisregistratie() {
        return this.basisregistratie;
    }

    public void setBasisregistratie(String basisregistratie) {
        this.basisregistratie = basisregistratie;
    }

    public FileBean getBestand() {
        return this.bestand;
    }

    public void setBestand(FileBean bestand) {
        this.bestand = bestand;
    }
}

