/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.util.List;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class BerichtenActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(BerichtenActionBean.class);
    private ActionBeanContext context;
    private List<Bericht> berichten;
    private long[] selectedIds;
    @Validate
    private int page;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate
    private JSONArray filter;
    @Validate
    private JSONObject changedItem;

    @DefaultHandler
    public Resolution list() {
        return new ForwardResolution("/WEB-INF/jsp/bericht/list.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getGridData() throws BrmoException {
        String filterSoort = "";
        String filterStatus = "";
        if (this.getFilter() != null) {
            for (int k = 0; k < this.getFilter().length(); ++k) {
                JSONObject j = this.getFilter().getJSONObject(k);
                String property = j.getString("property");
                Object value = j.opt("value");
                String stringValue = "";
                if (value instanceof String) {
                    stringValue = (String)value;
                } else if (value instanceof JSONArray) {
                    JSONArray jaValue = (JSONArray)value;
                    stringValue = jaValue.join(",");
                    stringValue = stringValue.replaceAll("\"", "");
                }
                if (property.equals("soort")) {
                    filterSoort = stringValue;
                }
                if (!property.equals("status")) continue;
                filterStatus = stringValue;
            }
        }
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        long count = 0L;
        JSONArray jsoNBerichten = new JSONArray();
        BrmoFramework brmo = null;
        try {
            brmo = new BrmoFramework(dataSourceStaging, null);
            count = brmo.getCountBerichten(this.sort, this.dir, filterSoort, filterStatus);
            if (this.start < 0) {
                this.start = 0;
            }
            this.berichten = brmo.getBerichten(this.page, this.start, this.limit, this.sort == null || this.sort.trim().isEmpty() ? "id" : this.sort, this.dir == null || this.dir.trim().isEmpty() ? "asc" : this.dir, filterSoort, filterStatus);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
        for (Bericht b : this.berichten) {
            JSONObject jsonObject = this.bericht2Json(b);
            jsoNBerichten.put((Object)jsonObject);
        }
        JSONObject grid = new JSONObject();
        if (count < 0L) {
            grid.put("virtualtotal", true);
            count = 0L;
        }
        grid.put("total", count);
        grid.put("items", (Object)jsoNBerichten);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JSONObject bericht2Json(Bericht ber) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)ber.getId());
        json.put("object_ref", (Object)ber.getObjectRef());
        json.put("datum", (Object)ber.getDatum());
        json.put("soort", (Object)ber.getSoort());
        json.put("status", (Object)ber.getStatus());
        json.put("volgordenummer", (Object)ber.getVolgordeNummer());
        return json;
    }

    public Resolution saveRecord() {
        JSONObject item = this.getChangedItem();
        EntityManager em = Stripersist.getEntityManager();
        nl.b3p.brmo.persistence.staging.Bericht bericht = (nl.b3p.brmo.persistence.staging.Bericht)em.find(nl.b3p.brmo.persistence.staging.Bericht.class, (Object)item.getLong("id"));
        bericht.setStatus(Bericht.STATUS.valueOf((String)item.getString("status")));
        em.merge((Object)bericht);
        em.getTransaction().commit();
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("success", true);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution log() throws BrmoException {
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("success", (Object)Boolean.FALSE);
        BrmoFramework brmo = new BrmoFramework(dataSourceStaging, null);
        try {
            Bericht bericht = brmo.getBerichtById(this.selectedIds[0]);
            jsonObj = this.bericht2Json(bericht);
            jsonObj.put("opmerking", (Object)bericht.getOpmerking());
            jsonObj.put("success", (Object)Boolean.TRUE);
        }
        finally {
            brmo.closeBrmoFramework();
        }
        String returnValue = jsonObj.toString();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public List<Bericht> getBerichten() {
        return this.berichten;
    }

    public void setBerichten(List<Bericht> berichten) {
        this.berichten = berichten;
    }

    public long[] getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(long[] selectedIds) {
        this.selectedIds = selectedIds;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public JSONArray getFilter() {
        return this.filter;
    }

    public void setFilter(JSONArray filter) {
        this.filter = filter;
    }

    public JSONObject getChangedItem() {
        return this.changedItem;
    }

    public void setChangedItem(JSONObject changedItem) {
        this.changedItem = changedItem;
    }
}

