/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.Calendar;
import java.util.Date;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BerichtTransformatieProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BerichtTransformatieUitvoeren
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BerichtTransformatieUitvoeren.class);
    private final BerichtTransformatieProces config;
    private ProgressUpdateListener l;
    private boolean transformErrorOccured = false;

    public BerichtTransformatieUitvoeren(BerichtTransformatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.l = listener;
        this.l.updateStatus("Initialiseren...");
        this.l.addLog(String.format("Initialiseren... %tc", new Date()));
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        String msg = String.format("Het bericht transformatie proces met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        log.info((Object)msg);
        this.l.addLog(msg);
        sb.append(msg).append("\n");
        BrmoFramework brmo = null;
        try {
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
            brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb);
            brmo.setEnablePipeline(true);
            brmo.setOrderBerichten(true);
            brmo.setTransformPipelineCapacity(100);
            Thread t = brmo.toRsgb((nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
            t.join();
            if (this.transformErrorOccured) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                msg = "Handmatige transformatie vanuit de berichten pagina is noodzakelijk.";
                sb.append(msg).append("\n");
                log.warn((Object)msg);
                msg = String.format("Bericht transformatie proces met ID %d is niet succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                log.error((Object)msg);
            } else {
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                msg = String.format("Bericht transformatie proces met ID %d is succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                log.info((Object)msg);
            }
            sb.append(msg).append("\n");
            this.l.addLog(msg);
            this.config.setSamenvatting(msg);
            this.config.setLogfile(sb.toString());
        }
        catch (InterruptedException | BrmoException t) {
            log.error((Object)"Fout bij transformeren berichten naar RSGB", t);
            String m = "Fout bij transformeren berichten naar RSGB: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.config.setLogfile(sb.toString());
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
        }
    }

    static /* synthetic */ boolean access$002(BerichtTransformatieUitvoeren x0, boolean x1) {
        x0.transformErrorOccured = x1;
        return x0.transformErrorOccured;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ ProgressUpdateListener access$200(BerichtTransformatieUitvoeren x0) {
        return x0.l;
    }
}

