/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.persistence.Transient;
import nl.b3p.brmo.bgt.util.PDOKBGTLightUtil;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BGTLightOphaalProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.jdbc.StreamUtils;
import org.stripesstuff.stripersist.Stripersist;

public class BGTLightOphalenProces
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(BGTLightOphalenProces.class);
    private final BGTLightOphaalProces config;
    @Transient
    private ProgressUpdateListener listener;

    public BGTLightOphalenProces(BGTLightOphaalProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        long totaal = 0L;
        long aantalGeladen = 0L;
        String msg = String.format("Het BGT GML Light ophalen proces met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.addLog(msg);
        sb.append(msg).append("\n");
        if (this.isArchivingOK()) {
            this.config.setLogfile(sb.toString());
            Set ids = this.config.getGridIds();
            if (ids == null || ids.isEmpty()) {
                msg = "Ophalen 'tileinfo.json' en bepalen grid cellen";
                listener.updateStatus(msg);
                String ophaalgebiedWKT = this.config.getOphaalgebied();
                msg = "Ophaalgebied: " + ophaalgebiedWKT;
                sb.append(msg).append("\n");
                listener.addLog(msg);
                LOG.info((Object)msg);
                String tileInfoJsonUrl = this.config.getTileInfoUrl();
                msg = "BGT tileinfo url: " + tileInfoJsonUrl;
                sb.append(msg).append("\n");
                LOG.info((Object)msg);
                ids = PDOKBGTLightUtil.calculateGridIds((String)ophaalgebiedWKT, (String)tileInfoJsonUrl);
                msg = "De berekende lijst met op te halen grid cellen is: " + ids;
            } else {
                msg = "De berekende lijst met op te halen grid cellen is: " + ids;
            }
            listener.total((long)ids.size());
            sb.append(msg).append("\n");
            LOG.info((Object)msg);
            listener.addLog(msg);
            listener.updateStatus(msg);
            String bUrl = this.config.getOphaalUrl();
            LOG.info((Object)("BGT GML light ophaal basis url: " + bUrl));
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            String enddate = sdf.format(new Date());
            bUrl = bUrl.replace("ENDDATE", enddate);
            BrmoFramework brmo = null;
            for (Integer id : ids) {
                String sUrl = bUrl.replace("GRID_ID", id.toString());
                msg = "Ophalen/downloaden bestand voor grid id: " + id + " aggr. nivo 0";
                listener.updateStatus(msg);
                LOG.info((Object)msg);
                listener.addLog(msg);
                sb.append(msg).append("\n");
                String naam = id + "_0-" + enddate + ".zip";
                File gmlZip = this.getBestand(sUrl, naam, sb);
                if (gmlZip != null) {
                    msg = "Laden bestand: " + naam;
                    listener.updateStatus(msg);
                    LOG.info((Object)msg);
                    listener.addLog(msg);
                    sb.append(msg).append("\n");
                    try {
                        brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), null);
                        brmo.loadFromFile("bgtlight", gmlZip.getAbsolutePath(), this.config.getId());
                        ++aantalGeladen;
                    }
                    catch (BrmoException ex) {
                        msg = "GML Bestand kon niet worden geladen.";
                        sb.append(msg).append("\n");
                        LOG.error((Object)msg, (Throwable)ex);
                        this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs.");
                        listener.exception((Throwable)ex);
                    }
                    finally {
                        if (brmo != null) {
                            brmo.closeBrmoFramework();
                        }
                    }
                }
                listener.progress(++totaal);
            }
            msg = "Er zijn " + aantalGeladen + " bestanden opgehaald en geladen.";
            sb.append(msg).append("\n");
            listener.addLog("\n\n**** resultaat ****\n");
            listener.addLog(msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setSamenvatting(msg);
        } else {
            msg = "FOUT: Download bestanden kunnen niet worden opgeslagen/weggeschreven.";
            LOG.error((Object)msg);
            sb.append(msg).append("\n");
            listener.updateStatus(msg);
            listener.addLog(msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.config.setSamenvatting(msg);
        }
        msg = String.format("Het BGT GML Light ophalen proces met ID %d is afgerond op %tc", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.updateStatus(msg);
        listener.addLog("\n" + msg);
        sb.append(msg).append("\n");
        this.config.setLogfile(sb.toString());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private File getBestand(String sUrl, String naam, StringBuilder log) {
        File out = new File(this.config.getArchiefDirectory(), naam);
        if (this.isDuplicaatLaadProces(out, "bgtlight")) {
            String msg = "Duplicaat bestand " + naam + " wordt niet (opnieuw) opgehaald of geladen.";
            LOG.info((Object)msg);
            log.append(msg).append("\n");
            this.listener.addLog(msg);
            return null;
        }
        try {
            LOG.debug((Object)("ophalen bestand: " + sUrl));
            URL url = new URL(sUrl);
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setUseCaches(false);
            conn.setDefaultUseCaches(false);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(60000);
            conn.connect();
            InputStream data = conn.getInputStream();
            FileOutputStream archiveFile = new FileOutputStream(out);
            StreamUtils.copy((InputStream)data, (OutputStream)archiveFile);
        }
        catch (IOException ex) {
            LOG.error((Object)"Bestand kon niet worden opgehaald of opgeslagen.", (Throwable)ex);
            log.append("Bestand kon niet worden opgehaald of opgeslagen: ").append(ex.getLocalizedMessage()).append("\n");
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs.");
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.listener.exception((Throwable)ex);
        }
        return out;
    }

    private boolean isArchivingOK() {
        boolean isArchiving;
        LOG.debug((Object)"Controle archief directory.");
        String aDir = this.config.getArchiefDirectory();
        boolean bl = isArchiving = aDir != null;
        if (isArchiving) {
            File archiefDirectory = new File(aDir);
            try {
                archiefDirectory.mkdirs();
                if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    String msg = String.format("FOUT: De archief directory '%s' is geen beschrijfbare directory, zipfiles kunnen niet worden niet opgeslagen.", archiefDirectory);
                    LOG.error((Object)msg);
                    this.listener.addLog(msg);
                    this.config.addLogLine(msg);
                    isArchiving = false;
                }
            }
            catch (SecurityException e) {
                String msg = String.format("SecurityException voor archief directory '%s', zipfiles kunnen niet worden niet opgeslagen.", archiefDirectory);
                this.listener.addLog(msg);
                this.config.addLogLine(msg);
                LOG.error((Object)msg, (Throwable)e);
                isArchiving = false;
                this.listener.exception((Throwable)e);
            }
        }
        LOG.debug((Object)("Archief directory ingesteld op " + aDir));
        return isArchiving;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

