/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Transient;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.LaadprocesTransformatieProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.scanner.TopNLDirectoryScanner;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class LaadprocesTransformatieUitvoeren
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(LaadprocesTransformatieUitvoeren.class);
    private final LaadprocesTransformatieProces config;
    @Transient
    private ProgressUpdateListener listener;
    private boolean transformErrorOccured = false;

    public LaadprocesTransformatieUitvoeren(LaadprocesTransformatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        listener.updateStatus("Initialiseren...");
        listener.addLog(String.format("Initialiseren... %tc", new Date()));
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        String msg = String.format("Het laadproces transformatie proces met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.addLog(msg);
        sb.append(msg).append("\n");
        BrmoFramework brmo = null;
        try {
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceRsgbBgt = null;
            DataSource dataSourceTopNL = null;
            if (LaadprocesTransformatieProces.LaadprocesSoorten.BR_TOPNL.getSoort().equalsIgnoreCase(this.config.getSoort())) {
                dataSourceTopNL = ConfigUtil.getDataSourceTopNL();
            }
            if (LaadprocesTransformatieProces.LaadprocesSoorten.BR_BGTLIGHT.getSoort().equalsIgnoreCase(this.config.getSoort())) {
                dataSourceRsgbBgt = ConfigUtil.getDataSourceRsgbBgt();
            }
            brmo = new BrmoFramework(dataSourceStaging, null, dataSourceRsgbBgt, dataSourceTopNL);
            long[] lpIds = null;
            if (LaadprocesTransformatieProces.LaadprocesSoorten.BR_TOPNL.getSoort().equalsIgnoreCase(this.config.getSoort())) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (String type : TopNLDirectoryScanner.subdirectoryNames) {
                    ids.addAll(Arrays.asList(brmo.getLaadProcessenIds("bestand_datum", "ASC", type, "STAGING_OK")));
                }
                lpIds = ArrayUtils.toPrimitive((Long[])ids.toArray(new Long[ids.size()]));
            } else {
                lpIds = ArrayUtils.toPrimitive((Long[])brmo.getLaadProcessenIds("bestand_datum", "ASC", this.config.getSoort(), "STAGING_OK"));
            }
            brmo.setOrderBerichten(!this.config.alsStandTransformeren());
            if (lpIds == null || lpIds.length == 0) {
                msg = "Er zijn geen laadprocessen van soort " + this.config.getSoort() + " en status: 'STAGING_OK' om te transformeren.";
                LOG.info((Object)msg);
                sb.append(msg).append("\n");
                listener.addLog(msg);
            } else {
                listener.updateStatus("Transformeren...");
                Thread t = brmo.toRsgb(RsgbProxy.BerichtSelectMode.BY_LAADPROCES, lpIds, (nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
                t.join();
            }
            if (this.transformErrorOccured) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                msg = "Handmatige transformatie vanuit de laadprocessen pagina is noodzakelijk.";
                sb.append(msg).append("\n");
                LOG.warn((Object)msg);
                msg = String.format("Laadproces transformatie proces met ID %d is niet succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                LOG.error((Object)msg);
                listener.updateStatus("Er is een fout opgetreden.");
            } else {
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                msg = String.format("Laadproces transformatie proces met ID %d is succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                LOG.info((Object)msg);
                listener.updateStatus("Transformatie afgerond.");
            }
            sb.append(msg).append("\n");
            this.listener.addLog(msg);
            this.config.setSamenvatting(msg);
            this.config.setLogfile(sb.toString());
        }
        catch (InterruptedException | BrmoException e) {
            LOG.error((Object)"Fout bij transformeren laadprocessen naar RSGB", e);
            String m = "Fout bij transformeren laadprocessen naar RSGB: " + ExceptionUtils.getMessage((Throwable)e);
            if (e.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            }
            this.config.setLogfile(sb.toString());
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
            Stripersist.getEntityManager().getTransaction().commit();
            Stripersist.getEntityManager().clear();
        }
    }

    static /* synthetic */ boolean access$002(LaadprocesTransformatieUitvoeren x0, boolean x1) {
        x0.transformErrorOccured = x1;
        return x0.transformErrorOccured;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

