/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.persistence.staging.AfgifteNummerScannerProces;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.AfgifteNummerScanner;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.EntityTypeConverter;
import org.stripesstuff.stripersist.Stripersist;

public class AfgifteNummerScanUitvoerenActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final String JSP = "/WEB-INF/jsp/beheer/afgiftenummerscanneruitvoeren.jsp";
    @Validate(converter=EntityTypeConverter.class)
    private AfgifteNummerScannerProces proces;
    private ActionBeanContext context;
    private String exceptionStacktrace;
    private String status;
    private long total;
    private boolean complete;
    private Date start;
    private Date update;
    private StringBuilder log = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    @WaitPage(path="/WEB-INF/jsp/beheer/afgiftenummerscanneruitvoeren.jsp", delay=1000, refresh=1000)
    public Resolution execute() {
        String samenvatting = null;
        if (this.proces == null) {
            this.getContext().getMessages().add(new SimpleMessage("Proces ongeldig!", new Object[0]));
            this.completed();
            return new ForwardResolution(JSP);
        }
        this.proces = (AfgifteNummerScannerProces)Stripersist.getEntityManager().find(AfgifteNummerScannerProces.class, (Object)this.proces.getId());
        AfgifteNummerScanner _proces = (AfgifteNummerScanner)AbstractExecutableProces.getProces((AutomatischProces)this.proces);
        try {
            _proces.execute((ProgressUpdateListener)this);
            this.proces.setOntbrekendeNummersGevonden(_proces.getOntbrekendeNummersGevonden());
            this.getContext().getMessages().add(new SimpleMessage("Afgiftenummer scan is afgerond.", new Object[0]));
            samenvatting = "Er zijn " + (_proces.getOntbrekendeNummersGevonden() ? "" : "geen") + " ontbrekende afgiftenummers geconstateerd.";
            this.getContext().getMessages().add(new SimpleMessage(samenvatting, new Object[0]));
        }
        catch (Exception ex) {
            try {
                this.proces.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                Stripersist.getEntityManager().merge((Object)this.proces);
                this.exception((Throwable)ex);
                samenvatting = "Er is een fout opgetreden tijdens het bepalen van ontbrekende afgiftenummers.";
                this.getContext().getMessages().add(new SimpleError("Er is een fout opgetreden tijdens het bepalen van ontbrekende afgiftenummers. {2}", new Object[]{ex.getMessage()}));
            }
            catch (Throwable throwable) {
                this.completed();
                this.proces.updateSamenvattingEnLogfile(this.log.toString());
                this.proces.setSamenvatting(samenvatting);
                if (Stripersist.getEntityManager().getTransaction().isActive()) {
                    Stripersist.getEntityManager().getTransaction().commit();
                }
                throw throwable;
            }
            this.completed();
            this.proces.updateSamenvattingEnLogfile(this.log.toString());
            this.proces.setSamenvatting(samenvatting);
            if (Stripersist.getEntityManager().getTransaction().isActive()) {
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
        this.completed();
        this.proces.updateSamenvattingEnLogfile(this.log.toString());
        this.proces.setSamenvatting(samenvatting);
        if (Stripersist.getEntityManager().getTransaction().isActive()) {
            Stripersist.getEntityManager().getTransaction().commit();
        }
        return new ForwardResolution(JSP);
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.total = progress;
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public void updateStatus(String status) {
        this.status = status;
    }

    public void addLog(String line) {
        this.log.append(line).append("\n");
    }

    @Before
    public void before() {
        this.start = new Date();
    }

    @After
    public void completed() {
        this.complete = true;
        this.proces.setLastrun(this.update);
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public AfgifteNummerScannerProces getProces() {
        return this.proces;
    }

    public void setProces(AfgifteNummerScannerProces proces) {
        this.proces = proces;
    }

    public String getLog() {
        return this.log.toString();
    }

    public void setLog(String log) {
        this.log = new StringBuilder(log);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

