/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.WebMirrorBAGScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.stripesstuff.stripersist.Stripersist;

public class WebMirrorBAGDirectoryScanner
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(WebMirrorBAGDirectoryScanner.class);
    private final WebMirrorBAGScannerProces config;
    private ProgressUpdateListener listener;
    private BrmoFramework brmo = null;
    private int progress = 0;
    private int aantalZipGeladen = 0;
    private int aantalXMLGeladen = 0;
    private int filterXMLAlVerwerkt = 0;

    public WebMirrorBAGDirectoryScanner(WebMirrorBAGScannerProces config) {
        this.config = config;
        try {
            this.brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), null);
        }
        catch (BrmoException ex) {
            log.fatal((Object)"Initialisatie van BRMO framework is mislukt", (Throwable)ex);
        }
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        String msg = String.format("Initialiseren... %tc", new Date());
        listener.updateStatus(msg);
        listener.addLog(msg);
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        Stripersist.getEntityManager().flush();
        try {
            URI parent;
            String url = this.config.getScanDirectory();
            msg = String.format("Ophalen van de lijst van links van %s.", url);
            listener.addLog(msg);
            Document doc = Jsoup.connect((String)url).timeout(5000).followRedirects(true).ignoreHttpErrors(false).get();
            msg = "De lijst met download links is succesvol opgehaald.";
            listener.updateStatus(msg);
            listener.addLog(msg);
            String expression = ((ClobElement)this.config.getConfig().get("csspath")).getValue();
            Elements links = doc.select(expression);
            URI uri = new URI(url);
            URI uRI = parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
            if (parent.toString().equalsIgnoreCase(links.first().attr("abs:href"))) {
                msg = String.format("Overslaan van (parent) link %s", parent);
                listener.updateStatus(msg);
                listener.addLog(msg);
                log.info((Object)msg);
                links.remove((Object)links.first());
            }
            int items = links.size();
            listener.total((long)items);
            this.progress = 0;
            this.filterXMLAlVerwerkt = 0;
            this.aantalZipGeladen = 0;
            this.aantalXMLGeladen = 0;
            for (int i = 0; i < items; ++i) {
                String berichtUrl = ((Element)links.get(i)).attr("abs:href");
                String bestandsnaam = ((Element)links.get(i)).text();
                this.laadBestand(berichtUrl, bestandsnaam);
                ++this.aantalZipGeladen;
                listener.progress((long)(++this.progress));
            }
            msg = String.format("Klaar met run op %tc.", Calendar.getInstance());
            listener.updateStatus(msg);
            listener.addLog(msg);
            listener.addLog("\n**** resultaat ****\n");
            listener.addLog("Aantal url's gedownloaded: " + this.aantalZipGeladen);
            listener.addLog("Aantal xml's geladen: " + this.aantalXMLGeladen);
            listener.addLog("Aantal xml's die al waren geladen: " + this.filterXMLAlVerwerkt);
            this.config.updateSamenvattingEnLogfile(msg + "\nAantal url's gedownloaded: " + this.aantalZipGeladen + "\nAantal xml's geladen: " + this.aantalXMLGeladen + "\nAantal xml's die al waren geladen: " + this.filterXMLAlVerwerkt);
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setLastrun(new Date());
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().getTransaction().commit();
        }
        catch (MalformedURLException | SocketTimeoutException ex) {
            log.error((Object)ex);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (HttpStatusException ex) {
            msg = String.format("Er is een fout opgetreden bij het uitlezen van de url %s. Status code %s", ex.getUrl(), ex.getStatusCode());
            log.error((Object)msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            listener.exception((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            listener.exception((Throwable)ex);
            String m = "Fout bij inladen van berichten: " + ExceptionUtils.getMessage((Throwable)ex);
            if (ex.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)ex);
            }
            log.error((Object)m, (Throwable)ex);
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
        }
        finally {
            this.config.setLastrun(new Date());
            Stripersist.getEntityManager().merge((Object)this.config);
            if (Stripersist.getEntityManager().getTransaction().getRollbackOnly()) {
                Stripersist.getEntityManager().getTransaction().rollback();
            } else {
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
    }

    private void laadBestand(String sUrl, String naam) throws Exception {
        ZipInputStream zis;
        ZipEntry entry;
        Object msg = "Downloaden " + sUrl;
        this.listener.updateStatus((String)msg);
        this.listener.addLog((String)msg);
        log.info(msg);
        URL url = new URL(sUrl);
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(false);
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.connect();
        InputStream zipData = conn.getInputStream();
        if (this.isArchivingOK()) {
            FileOutputStream archiveFile = new FileOutputStream(new File(this.config.getArchiefDirectory(), naam));
            zipData = new TeeInputStream(zipData, (OutputStream)archiveFile, true);
        }
        if ((entry = (zis = new ZipInputStream(zipData)).getNextEntry()) == null) {
            msg = String.format("  Geen geschikt bestand gevonden in download %s.", sUrl);
            this.listener.addLog((String)msg);
            return;
        }
        while (entry != null) {
            if (!entry.getName().toLowerCase().endsWith(".xml")) {
                msg = "Overslaan zip entry geen XML: " + entry.getName();
                this.listener.updateStatus((String)msg);
                this.listener.addLog((String)msg);
                log.info(msg);
            } else {
                msg = String.format("  Lezen XML bestand: %s uit zip", entry.getName());
                this.listener.updateStatus((String)msg);
                this.listener.addLog((String)msg);
                log.info(msg);
                String bestandNaam = naam + "/" + entry.getName();
                try {
                    this.brmo.loadFromStream("bag", (InputStream)CloseShieldInputStream.wrap((InputStream)zis), bestandNaam, (nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */, this.config.getId());
                    ++this.aantalXMLGeladen;
                }
                catch (BrmoDuplicaatLaadprocesException dup) {
                    ++this.filterXMLAlVerwerkt;
                    msg = dup.getLocalizedMessage();
                    this.listener.updateStatus((String)msg);
                    this.listener.addLog((String)msg);
                    log.info(msg);
                }
                catch (BrmoLeegBestandException ex) {
                    ++this.aantalXMLGeladen;
                    msg = ex.getLocalizedMessage();
                    this.listener.updateStatus((String)msg);
                    this.listener.addLog((String)msg);
                    log.info(msg);
                }
            }
            entry = zis.getNextEntry();
        }
        IOUtils.closeQuietly((InputStream)zis);
    }

    private boolean isArchivingOK() {
        boolean isArchiving;
        String aDir = this.config.getArchiefDirectory();
        boolean bl = isArchiving = aDir != null;
        if (isArchiving) {
            File archiefDirectory = new File(aDir);
            try {
                archiefDirectory.mkdirs();
                if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    String msg = String.format("FOUT: De archief directory '%s' is geen beschrijfbare directory, zipfiles worden niet gearchiveerd.", archiefDirectory);
                    this.listener.addLog(msg);
                    isArchiving = false;
                }
            }
            catch (SecurityException e) {
                String msg = String.format("SecurityException voor archief directory '%s', zipfiles worden niet gearchiveerd.", archiefDirectory);
                this.listener.addLog(msg);
                log.error((Object)msg, (Throwable)e);
                isArchiving = false;
            }
        }
        log.debug((Object)("Archief directory ingesteld op " + aDir));
        return isArchiving;
    }
}

