/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import nl.b3p.brmo.bag2.loader.BAG2Database;
import nl.b3p.brmo.bag2.loader.BAG2ProgressReporter;
import nl.b3p.brmo.bag2.loader.cli.BAG2DatabaseOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoadOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoaderMain;
import nl.b3p.brmo.bag2.schema.BAG2SchemaMapper;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.stripes.BAG2LoadActionBean;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.brmo.sql.dialect.OracleDialect;
import nl.b3p.brmo.sql.dialect.PostGISDialect;
import nl.b3p.jdbc.util.converter.PGConnectionUnwrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

public class BAG2LoadActionBean
implements ActionBean {
    private static final Log LOG = LogFactory.getLog(BAG2LoadActionBean.class);
    private ActionBeanContext context;
    private static final String JSP = "/WEB-INF/jsp/bestand/bag2.jsp";
    private static final String JSP_LOAD = "/WEB-INF/jsp/bestand/bag2load.jsp";
    private String files = "https://service.pdok.nl/kadaster/adressen/atom/v1_0/downloads/lvbag-extract-nl.zip";
    private DataSource rsgbbag;
    private Throwable namingException;
    private boolean connectionOk = false;
    private String connectionString;
    private String databaseName;
    private String databaseUserName;
    private String databaseDialect;
    private Exception connectionException;
    private Date standLoadTechnischeDatum;
    private Date currentTechnischeDatum;
    private Date standLoadTime;
    private boolean loading;
    private Date loadStart;
    private boolean loadResult;
    private Exception loadException;
    private String loadingLog;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public DataSource getRsgbbag() {
        return this.rsgbbag;
    }

    public void setRsgbbag(DataSource rsgbbag) {
        this.rsgbbag = rsgbbag;
    }

    public Throwable getNamingException() {
        return this.namingException;
    }

    public void setNamingException(Throwable namingException) {
        this.namingException = namingException;
    }

    public boolean isConnectionOk() {
        return this.connectionOk;
    }

    public void setConnectionOk(boolean connectionOk) {
        this.connectionOk = connectionOk;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public void setDatabaseUserName(String databaseUserName) {
        this.databaseUserName = databaseUserName;
    }

    public String getDatabaseDialect() {
        return this.databaseDialect;
    }

    public void setDatabaseDialect(String databaseDialect) {
        this.databaseDialect = databaseDialect;
    }

    public Exception getConnectionException() {
        return this.connectionException;
    }

    public void setConnectionException(Exception connectionException) {
        this.connectionException = connectionException;
    }

    public Date getStandLoadTechnischeDatum() {
        return this.standLoadTechnischeDatum;
    }

    public void setStandLoadTechnischeDatum(Date standLoadTechnischeDatum) {
        this.standLoadTechnischeDatum = standLoadTechnischeDatum;
    }

    public Date getCurrentTechnischeDatum() {
        return this.currentTechnischeDatum;
    }

    public void setCurrentTechnischeDatum(Date currentTechnischeDatum) {
        this.currentTechnischeDatum = currentTechnischeDatum;
    }

    public Date getStandLoadTime() {
        return this.standLoadTime;
    }

    public void setStandLoadTime(Date standLoadTime) {
        this.standLoadTime = standLoadTime;
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isLoadResult() {
        return this.loadResult;
    }

    public void setLoadResult(boolean loadResult) {
        this.loadResult = loadResult;
    }

    public String getLoadingLog() {
        return this.loadingLog;
    }

    public void setLoadingLog(String loadingLog) {
        this.loadingLog = loadingLog;
    }

    public Date getLoadStart() {
        return this.loadStart;
    }

    public void setLoadStart(Date loadStart) {
        this.loadStart = loadStart;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void setUpdateTime(Date updateTime) {
    }

    public Exception getLoadException() {
        return this.loadException;
    }

    public void setLoadException(Exception loadException) {
        this.loadException = loadException;
    }

    @Before(on={"form"})
    public void checkDatabase() {
        try {
            this.rsgbbag = ConfigUtil.getDataSourceRsgbBag((boolean)false);
        }
        catch (Exception e) {
            this.namingException = e instanceof BrmoException ? e.getCause() : e;
        }
        if (this.rsgbbag != null) {
            try (Connection c = this.rsgbbag.getConnection();){
                this.connectionOk = true;
                this.connectionString = c.getMetaData().getURL();
                this.databaseName = c.getMetaData().getDatabaseProductVersion();
                if (!this.databaseName.contains(c.getMetaData().getDatabaseProductName())) {
                    this.databaseName = c.getMetaData().getDatabaseProductName() + " " + this.databaseName;
                }
                this.databaseUserName = c.getMetaData().getUserName();
                BAG2Database bag2Database = new BAG2Database(new BAG2DatabaseOptions(), c);
                if (bag2Database.getDialect() instanceof PostGISDialect) {
                    this.databaseDialect = "postgis";
                } else if (bag2Database.getDialect() instanceof OracleDialect) {
                    this.databaseDialect = "oracle";
                } else {
                    throw new IllegalArgumentException("Unknown database dialect");
                }
                String s = bag2Database.getMetadata(BAG2SchemaMapper.Metadata.STAND_LOAD_TECHNISCHE_DATUM);
                if (s != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    this.currentTechnischeDatum = df.parse(bag2Database.getMetadata(BAG2SchemaMapper.Metadata.CURRENT_TECHNISCHE_DATUM));
                    this.standLoadTechnischeDatum = df.parse(s);
                    this.standLoadTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(bag2Database.getMetadata(BAG2SchemaMapper.Metadata.STAND_LOAD_TIME));
                }
            }
            catch (Exception e) {
                this.connectionOk = false;
                this.connectionException = e;
            }
        }
    }

    @DefaultHandler
    public Resolution form() {
        return new ForwardResolution(JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/bestand/bag2load.jsp", delay=1000, refresh=5000)
    public Resolution load() throws Exception {
        this.loading = true;
        this.loadStart = new Date();
        try (Connection rsgbBagConnection = ConfigUtil.getDataSourceRsgbBag((boolean)true).getConnection();){
            BAG2DatabaseOptions databaseOptions = new BAG2DatabaseOptions();
            databaseOptions.setConnectionString(rsgbBagConnection.getMetaData().getURL());
            Connection connection = rsgbBagConnection;
            if (databaseOptions.getConnectionString().startsWith("jdbc:postgresql:")) {
                connection = (Connection)PGConnectionUnwrapper.unwrap((Connection)rsgbBagConnection);
                databaseOptions.setUsePgCopy(true);
            }
            1 bag2Database = new /* Unavailable Anonymous Inner Class!! */;
            BAG2LoaderMain.configureLogging((boolean)false);
            BAG2LoaderMain main = new BAG2LoaderMain();
            BAG2LoadOptions loadOptions = new BAG2LoadOptions();
            main.loadFiles((BAG2Database)bag2Database, databaseOptions, loadOptions, new BAG2ProgressReporter(), (String[])Arrays.stream(this.files.split("\n")).map(String::trim).toArray(String[]::new), null);
            this.loadResult = true;
        }
        catch (Exception e) {
            this.loadResult = false;
            this.loadException = e;
            LOG.error((Object)"Error loading BAG 2.0", (Throwable)e);
        }
        finally {
            this.loading = false;
        }
        return new ForwardResolution(JSP_LOAD);
    }
}

