/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.Date;
import java.util.List;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.persistence.staging.BerichtDoorstuurProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.GDS2OphaalProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.GDS2OphalenProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BerichtDoorsturenProces
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BerichtDoorsturenProces.class);
    private final BerichtDoorstuurProces config;
    private final int defaultCommitPageSize = 1000;
    @Transient
    private ProgressUpdateListener l;

    BerichtDoorsturenProces(BerichtDoorstuurProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.l = listener;
        try {
            this.l.updateStatus("Laden berichten...");
            this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
            int commitPageSize = this.getCommitPageSize();
            String id = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_ophaalproces_id")));
            GDS2OphaalProces proces = (GDS2OphaalProces)Stripersist.getEntityManager().find(GDS2OphaalProces.class, (Object)Long.parseLong(id));
            List berichtIDs = Stripersist.getEntityManager().createQuery("select b.id from Bericht b join b.laadprocesid l where b.status in ('STAGING_OK', 'STAGING_NOK') and l.automatischProces = :proces").setParameter("proces", (Object)proces).getResultList();
            if (berichtIDs.isEmpty()) {
                this.config.setSamenvatting("Geen berichten om door te sturen");
            } else {
                this.l.total((long)berichtIDs.size());
                log.info((Object)String.format("Er zijn %s berichten om door te sturen.", berichtIDs.size()));
                String url = ClobElement.nullSafeGet((ClobElement)((ClobElement)proces.getConfig().get("delivery_endpoint")));
                if (url == null) {
                    this.config.setSamenvatting("GDS2 ophaal proces heeft geen afleveringsendpoint");
                    log.warn((Object)"GDS2 ophaal proces heeft geen afleveringsendpoint.");
                } else {
                    int doorgestuurd = 0;
                    int fouten = 0;
                    int verwerkt = 0;
                    for (Long pkid : berichtIDs) {
                        Bericht b = (Bericht)Stripersist.getEntityManager().find(Bericht.class, (Object)pkid);
                        if (GDS2OphalenProces.doorsturenBericht((AutomatischProces)proces, (ProgressUpdateListener)this.l, (Bericht)b, (String)url)) {
                            this.l.progress((long)(++doorgestuurd));
                        } else {
                            ++fouten;
                        }
                        Stripersist.getEntityManager().merge((Object)b);
                        if (++verwerkt % commitPageSize != 0) continue;
                        log.info((Object)String.format("Tussentijds opslaan van berichten, 'commitPageSize' (%s) is bereikt, totaal aantal verwerkt : %s", commitPageSize, verwerkt));
                        Stripersist.getEntityManager().flush();
                        Stripersist.getEntityManager().getTransaction().commit();
                        Stripersist.getEntityManager().clear();
                    }
                    this.config.setSamenvatting("Berichten doorgestuurd: " + doorgestuurd + ", fouten: " + fouten);
                }
            }
            this.l.updateStatus(this.config.getSamenvatting());
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setLastrun(new Date());
        }
        catch (Exception e) {
            this.config.setLastrun(new Date());
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.l.exception((Throwable)e);
        }
        finally {
            if (Stripersist.getEntityManager().getTransaction().getRollbackOnly()) {
                Stripersist.getEntityManager().getTransaction().rollback();
            } else {
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
    }

    private int getCommitPageSize() {
        int commitPageSize;
        try {
            String s = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("commitPageSize")));
            commitPageSize = Integer.parseInt(s);
            if (commitPageSize < 1 || commitPageSize > 1000) {
                commitPageSize = 1000;
            }
        }
        catch (NumberFormatException nfe) {
            commitPageSize = 1000;
        }
        log.debug((Object)("Instellen van commit page size op: " + commitPageSize));
        return commitPageSize;
    }
}

