/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.nhr.loader.NHRCertificateOptions;
import nl.b3p.brmo.nhr.loader.NHRException;
import nl.b3p.brmo.nhr.loader.NHRLoader;
import nl.b3p.brmo.nhr.loader.cli.NHRLoadUtils;
import nl.b3p.brmo.persistence.staging.NHRInschrijving;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.Dataservice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.stripesstuff.stripersist.Stripersist;

@DisallowConcurrentExecution
public class NHRJob
implements Job {
    private static final Log log = LogFactory.getLog(NHRJob.class);
    private static float averageFetchTime;
    private static long totalFetchCount;
    private static long totalFetchErrorCount;

    public static float getAverageFetchTime() {
        return averageFetchTime;
    }

    public static long getFetchCount() {
        return totalFetchCount;
    }

    public static long getFetchErrorCount() {
        return totalFetchErrorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchOne(Dataservice dataservice, String kvkNummer) throws Exception {
        BrmoFramework brmo = null;
        try {
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            brmo = new BrmoFramework(dataSourceStaging, null, null, null);
            brmo.setOrderBerichten(false);
            NHRLoader.sendSingleRequest((Dataservice)dataservice, (BrmoFramework)brmo, (String)kvkNummer, null);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
    }

    private Dataservice getDataservice() {
        try {
            InitialContext ctx = new InitialContext();
            Boolean isActive = (Boolean)ctx.lookup("java:comp/env/brmo/nhr/active");
            if (!isActive.booleanValue()) {
                return null;
            }
            NHRCertificateOptions certOptions = new NHRCertificateOptions();
            certOptions.setKeystore((String)ctx.lookup("java:comp/env/brmo/nhr/keystorePath"));
            certOptions.setKeystorePassword((String)ctx.lookup("java:comp/env/brmo/nhr/keystorePassword"));
            certOptions.setKeystoreAlias(null);
            certOptions.setTruststore((String)ctx.lookup("java:comp/env/brmo/nhr/truststorePath"));
            certOptions.setTruststorePassword((String)ctx.lookup("java:comp/env/brmo/nhr/truststorePassword"));
            String endpoint = (String)ctx.lookup("java:comp/env/brmo/nhr/endpoint");
            boolean isPreprod = (Boolean)ctx.lookup("java:comp/env/brmo/nhr/endpointIsPreprod");
            return NHRLoadUtils.getDataservice((String)endpoint, (boolean)isPreprod, (NHRCertificateOptions)certOptions);
        }
        catch (Exception e) {
            throw new Error("NHR DataService initializeren mislukt", e);
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Dataservice ds = this.getDataservice();
        if (ds == null) {
            return;
        }
        Integer secondsBetweenFetches = null;
        try {
            InitialContext ctx = new InitialContext();
            secondsBetweenFetches = (Integer)ctx.lookup("java:comp/env/brmo/nhr/secondsBetweenFetches");
        }
        catch (Exception ctx) {
            // empty catch block
        }
        while (true) {
            Stripersist.requestInit();
            EntityManager entityManager = Stripersist.getEntityManager();
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(NHRInschrijving.class);
            Root from = cq.from(NHRInschrijving.class);
            cq.where((Expression)cb.lessThan((Expression)from.get("volgendProberen"), cb.currentTimestamp()));
            List procList = entityManager.createQuery(cq).setMaxResults(20).getResultList();
            if (procList.isEmpty()) break;
            for (NHRInschrijving process : procList) {
                Calendar time;
                long fetchStart = Calendar.getInstance().getTimeInMillis();
                boolean failed = false;
                Throwable exception = null;
                try {
                    this.fetchOne(ds, process.getKvkNummer());
                    process.setException("");
                }
                catch (BrmoDuplicaatLaadprocesException | BrmoLeegBestandException e) {
                    log.info((Object)String.format("KVK nummer %s ophalen mislukt", process.getKvkNummer()), e);
                    exception = e;
                }
                catch (IllegalStateException e) {
                    break;
                }
                catch (NHRException e) {
                    Map errors = e.getErrors();
                    failed = !errors.containsKey("IPD0004") && !errors.containsKey("IPD0005");
                    exception = e;
                }
                catch (Exception e) {
                    failed = true;
                    exception = e;
                }
                if (exception != null) {
                    process.setException(exception.toString());
                }
                if (failed) {
                    log.error((Object)String.format("KVK nummer %s ophalen mislukt (%d keer geprobeerd)", process.getKvkNummer(), process.getProbeerAantal()), exception);
                    ++totalFetchErrorCount;
                    process.setProbeerAantal(Integer.valueOf(process.getProbeerAantal() + 1));
                    time = Calendar.getInstance();
                    process.setLaatstGeprobeerd(new Date());
                    int secondsUntilNextTry = 30 * (int)Math.pow(2.0, Math.min(process.getProbeerAantal() - 1, 10));
                    if (secondsUntilNextTry > 7200) {
                        secondsUntilNextTry = 7200;
                    } else if (secondsUntilNextTry < 30) {
                        secondsUntilNextTry = 30;
                    }
                    time.add(13, secondsUntilNextTry);
                    process.setVolgendProberen(time.getTime());
                    entityManager.merge((Object)process);
                } else if (secondsBetweenFetches == null || secondsBetweenFetches == 0) {
                    entityManager.remove((Object)process);
                } else {
                    time = Calendar.getInstance();
                    time.add(13, secondsBetweenFetches);
                    process.setProbeerAantal(Integer.valueOf(0));
                    process.setVolgendProberen(time.getTime());
                    entityManager.merge((Object)process);
                }
                ++totalFetchCount;
                averageFetchTime = (averageFetchTime * 9.0f + (float)(Calendar.getInstance().getTimeInMillis() - fetchStart)) / 10.0f;
            }
            entityManager.flush();
            if (!entityManager.getTransaction().isActive()) continue;
            entityManager.getTransaction().commit();
            entityManager.getTransaction().begin();
        }
        Stripersist.requestComplete();
    }
}

