/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.NHRInschrijving;
import nl.b3p.brmo.service.jobs.NHRJob;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class NHRActionBean
implements ActionBean {
    private ActionBeanContext context;
    private String[] selectedIds;
    @Validate
    private int start;
    @Validate
    private int limit;
    @Validate
    private String sort;
    @Validate
    private String dir;
    @Validate(required=true, on={"upload"})
    private FileBean file;
    private boolean statusActive;
    private Date statusCertificateExpiry;
    private long statusDaysUntilExpiry;
    private String statusNotification;
    private String statusEndpoint;
    private boolean statusEndpointPreprod;
    private float statusRefetchDays;

    public boolean getStatusActive() {
        return this.statusActive;
    }

    public Date getStatusCertificateExpiry() {
        return this.statusCertificateExpiry;
    }

    public long getStatusDaysUntilExpiry() {
        return this.statusDaysUntilExpiry;
    }

    public String getStatusNotification() {
        return this.statusNotification;
    }

    public String getStatusEndpoint() {
        return this.statusEndpoint;
    }

    public boolean getStatusEndpointPreprod() {
        return this.statusEndpointPreprod;
    }

    public float getStatusRefetchDays() {
        return this.statusRefetchDays;
    }

    public long getFetchCount() {
        return NHRJob.getFetchCount();
    }

    public long getFetchErrorCount() {
        return NHRJob.getFetchErrorCount();
    }

    public float getSecondsPerFetch() {
        return NHRJob.getAverageFetchTime() / 1000.0f;
    }

    public String getEstimatedTime() {
        float totalSeconds = this.getSecondsPerFetch() * (float)this.getPendingCount();
        int hours = (int)(totalSeconds / 3600.0f);
        int minutes = (int)(totalSeconds / 60.0f) % 60;
        int seconds = (int)totalSeconds % 60;
        return String.format("%dh %02dm %02ds", hours, minutes, seconds);
    }

    private void getCertificateStatus() {
        this.statusNotification = "";
        try {
            this.statusActive = (Boolean)InitialContext.doLookup("java:comp/env/brmo/nhr/active");
        }
        catch (NamingException namingException) {
        }
        catch (Exception e) {
            this.statusNotification = this.statusNotification + String.format("nhr/active incorrect: %s\n", e.getMessage());
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream keyStoreFile = new FileInputStream((String)InitialContext.doLookup("java:comp/env/brmo/nhr/keystorePath"));){
                keyStore.load(keyStoreFile, ((String)InitialContext.doLookup("java:comp/env/brmo/nhr/keystorePassword")).toCharArray());
            }
            String alias = keyStore.aliases().nextElement();
            if (alias == null) {
                this.statusNotification = this.statusNotification + "geen bruikbaar certificaat gevonden";
            } else {
                Certificate cert = keyStore.getCertificate(alias);
                Date now = new Date();
                this.statusCertificateExpiry = ((X509Certificate)cert).getNotAfter();
                this.statusDaysUntilExpiry = (this.statusCertificateExpiry.getTime() - now.getTime()) / 86400L;
                if (this.statusCertificateExpiry.before(now)) {
                    this.statusNotification = this.statusNotification + "certificaat is verlopen!\n";
                }
            }
        }
        catch (FileNotFoundException e) {
            this.statusNotification = this.statusNotification + "keystore niet gevonden\n";
        }
        catch (NamingException e) {
            if (this.statusActive) {
                this.statusNotification = this.statusNotification + String.format("geen keystore ingesteld: %s\n", e.getMessage());
            }
        }
        catch (Exception e) {
            this.statusNotification = this.statusNotification + String.format("keystore incorrect: %s\n", e.getMessage());
        }
        try {
            KeyStore trustStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream trustStoreFile = new FileInputStream((String)InitialContext.doLookup("java:comp/env/brmo/nhr/truststorePath"));){
                trustStore.load(trustStoreFile, ((String)InitialContext.doLookup("java:comp/env/brmo/nhr/truststorePassword")).toCharArray());
            }
        }
        catch (FileNotFoundException e) {
            this.statusNotification = this.statusNotification + "truststore niet gevonden\n";
        }
        catch (NamingException e) {
            if (this.statusActive) {
                this.statusNotification = this.statusNotification + String.format("geen truststore ingesteld: %s\n", e.getMessage());
            }
        }
        catch (Exception e) {
            this.statusNotification = this.statusNotification + String.format("truststore incorrect: %s\n", e.getMessage());
        }
        try {
            this.statusEndpoint = (String)InitialContext.doLookup("java:comp/env/brmo/nhr/endpoint");
            this.statusEndpointPreprod = (Boolean)InitialContext.doLookup("java:comp/env/brmo/nhr/endpointIsPreprod");
        }
        catch (Exception e) {
            this.statusNotification = this.statusNotification + String.format("endpoint incorrect: %s\n", e.getMessage());
        }
        try {
            this.statusRefetchDays = (float)((Integer)InitialContext.doLookup("java:comp/env/brmo/nhr/secondsBetweenFetches")).intValue() / 86400.0f;
        }
        catch (Exception e) {
            this.statusNotification = this.statusNotification + String.format("secondsBetweenFetches incorrect: %s\n", e.getMessage());
        }
    }

    @DefaultHandler
    public Resolution list() {
        this.getCertificateStatus();
        return new ForwardResolution("/WEB-INF/jsp/nhr/list.jsp");
    }

    private long getCount() {
        EntityManager entityManager = Stripersist.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root from = cq.from(NHRInschrijving.class);
        cq.select((Selection)cb.count((Expression)from));
        return (Long)entityManager.createQuery(cq).getSingleResult();
    }

    public long getPendingCount() {
        EntityManager entityManager = Stripersist.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root from = cq.from(NHRInschrijving.class);
        cq.select((Selection)cb.count((Expression)from));
        cq.where((Expression)cb.lessThan((Expression)from.get("volgendProberen"), cb.currentTimestamp()));
        return (Long)entityManager.createQuery(cq).getSingleResult();
    }

    public Resolution getGridData() throws BrmoException {
        EntityManager entityManager = Stripersist.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(NHRInschrijving.class);
        Root from = cq.from(NHRInschrijving.class);
        if (this.sort != null) {
            if (this.dir == null || !this.dir.equalsIgnoreCase("desc")) {
                cq.orderBy(new Order[]{cb.asc((Expression)from.get(this.sort))});
            } else {
                cq.orderBy(new Order[]{cb.desc((Expression)from.get(this.sort))});
            }
        }
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.limit <= 0) {
            this.limit = 40;
        }
        List procList = entityManager.createQuery(cq).setMaxResults(this.limit).setFirstResult(this.start).getResultList();
        JSONArray jsonBerichten = new JSONArray();
        for (NHRInschrijving b : procList) {
            jsonBerichten.put((Object)this.laadproces2Json(b));
        }
        JSONObject grid = new JSONObject();
        grid.put("total", this.getCount());
        grid.put("items", (Object)jsonBerichten);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution getLog() {
        NHRInschrijving item;
        EntityManager entityManager = Stripersist.getEntityManager();
        String responseString = this.selectedIds == null || this.selectedIds.length != 1 ? "kan geen logs ophalen voor 0 of meer dan 1 item" : ((item = (NHRInschrijving)entityManager.find(NHRInschrijving.class, (Object)this.selectedIds[0])) == null ? String.format("Log voor KVK nummer %s niet gevonden", this.selectedIds[0]) : item.getException());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution runNow() throws BrmoException {
        EntityManager entityManager = Stripersist.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(NHRInschrijving.class);
        Root from = cq.from(NHRInschrijving.class);
        CriteriaBuilder.In in = cb.in((Expression)from.get("kvkNummer"));
        for (String item : this.selectedIds) {
            in.value((Object)item);
        }
        cq.where((Expression)in);
        List procList = entityManager.createQuery(cq).getResultList();
        for (NHRInschrijving b : procList) {
            b.setVolgendProberen(new Date());
            b.setProbeerAantal(Integer.valueOf(0));
        }
        entityManager.getTransaction().commit();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution upload() throws IOException {
        EntityManager entityManager = Stripersist.getEntityManager();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                NHRInschrijving proces;
                if ((line = line.split(",")[0]).length() < 8) {
                    line = StringUtils.leftPad((String)line, (int)8, (String)"0");
                }
                if ((proces = (NHRInschrijving)entityManager.find(NHRInschrijving.class, (Object)line)) == null) {
                    proces = new NHRInschrijving();
                }
                proces.setDatum(new Date());
                proces.setVolgendProberen(new Date());
                proces.setProbeerAantal(Integer.valueOf(0));
                proces.setKvkNummer(line);
                entityManager.merge((Object)proces);
            }
        }
        this.file.delete();
        entityManager.getTransaction().commit();
        return this.list();
    }

    private JSONObject laadproces2Json(NHRInschrijving laadproces) {
        JSONObject json = new JSONObject();
        json.put("datum", (Object)laadproces.getDatum());
        json.put("laatstGeprobeerd", (Object)laadproces.getLaatstGeprobeerd());
        json.put("volgendProberen", (Object)laadproces.getVolgendProberen());
        json.put("probeerAantal", (Object)laadproces.getProbeerAantal());
        json.put("kvkNummer", (Object)laadproces.getKvkNummer());
        return json;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String[] getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(String[] selectedIds) {
        this.selectedIds = selectedIds;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public FileBean getFile() {
        return this.file;
    }

    public void setFile(FileBean file) {
        this.file = file;
    }
}

