/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.persistence.Transient;
import nl.b3p.brmo.bag2.loader.BAG2Database;
import nl.b3p.brmo.bag2.loader.cli.BAG2DatabaseOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoadOptions;
import nl.b3p.brmo.bag2.loader.cli.BAG2LoaderMain;
import nl.b3p.brmo.bag2.loader.cli.BAG2MutatiesCommand;
import nl.b3p.brmo.bag2.loader.cli.BAG2ProgressOptions;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BAG2MutatieProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.BAG2MutatieProcesRunner;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.jdbc.util.converter.PGConnectionUnwrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BAG2MutatieProcesRunner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(BAG2MutatieProcesRunner.class);
    private final BAG2MutatieProces config;
    @Transient
    private ProgressUpdateListener listener;

    public BAG2MutatieProcesRunner(BAG2MutatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        BAG2LoaderMain.configureLogging((boolean)false);
        if (!this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.WAITING)) {
            if (!this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) return;
        }
        if (this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) {
            listener.addLog("Vorige run is met ERROR status afgerond, opnieuw proberen");
        }
        int exitCode = -1;
        try (Connection rsgbbagConnection = ConfigUtil.getDataSourceRsgbBag().getConnection();){
            BAG2DatabaseOptions databaseOptions = new BAG2DatabaseOptions();
            databaseOptions.setConnectionString(rsgbbagConnection.getMetaData().getURL());
            Connection connection = rsgbbagConnection;
            if (databaseOptions.getConnectionString().startsWith("jdbc:postgresql:")) {
                connection = (Connection)PGConnectionUnwrapper.unwrap((Connection)rsgbbagConnection);
                databaseOptions.setUsePgCopy(true);
            }
            2 bag2Database = new /* Unavailable Anonymous Inner Class!! */;
            BAG2LoaderMain main = new BAG2LoaderMain();
            main.setBag2Database((BAG2Database)bag2Database);
            BAG2MutatiesCommand mutatiesCommand = new BAG2MutatiesCommand();
            mutatiesCommand.setParent(main);
            BAG2LoadOptions loadOptions = new BAG2LoadOptions();
            BAG2DatabaseOptions dbOptions = new BAG2DatabaseOptions();
            listener.updateStatus(AutomatischProces.ProcessingStatus.PROCESSING.toString());
            this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
            String mode = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("mode")));
            String directory = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("directory")));
            String url = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("url")));
            String kadasterUser = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("kadaster-username")));
            String kadasterPassword = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("kadaster-password")));
            String queryParams = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("query")));
            if (!mode.equals("applyFromMirror")) {
                url = "https://bag.kadaster.nl/lvbag/bag-bestanden/api/bestanden";
            }
            if (queryParams == null || queryParams.trim().length() == 0) {
                queryParams = "artikelnummers=2529";
            }
            switch (mode) {
                case "applyFromMirror": {
                    listener.updateStatus("Verwerken van BAG2 mutatiebestanden...");
                    listener.addLog(String.format("Verwerken van BAG2 mutatiebestanden van publieke mirror \"%s\"", url));
                    exitCode = mutatiesCommand.apply(dbOptions, new BAG2ProgressOptions(), null, null, url, queryParams, false);
                    listener.addLog("Einde verwerken BAG2 bestanden");
                    return;
                }
                case "apply": {
                    listener.updateStatus("Verwerken van BAG2 mutatiebestanden...");
                    listener.addLog(String.format("Verwerken van BAG2 mutatiebestanden van BAG Bestanden, gebruikersnaam %s", kadasterUser));
                    exitCode = mutatiesCommand.apply(dbOptions, new BAG2ProgressOptions(), kadasterUser, kadasterPassword, url, queryParams, false);
                    listener.addLog("Einde verwerken BAG2 bestanden");
                    return;
                }
                case "download": {
                    listener.updateStatus("Downloaden van BAG2 mutatiebestanden...");
                    listener.addLog(String.format("Downloaden van BAG2 mutatiebestanden naar directory %s, gebruikersnaam %s", directory, kadasterUser));
                    exitCode = mutatiesCommand.download(false, kadasterUser, kadasterPassword, url, queryParams, directory, "", false);
                    listener.addLog("Einde downloaden BAG2 bestanden");
                    return;
                }
                case "load": {
                    listener.updateStatus("Laden van BAG2 bestanden...");
                    listener.addLog("Laden van BAG2 bestanden uit directory " + directory);
                    exitCode = main.load(dbOptions, loadOptions, new BAG2ProgressOptions(), new String[]{directory}, false);
                    listener.addLog("Einde laden BAG2 bestanden");
                    return;
                }
            }
            return;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e.getLocalizedMessage());
            listener.exception((Throwable)e);
            return;
        }
        catch (SQLException | BrmoException e) {
            LOG.error((Object)"Fout tijdens benaderen BAG2 database", e);
            listener.exception(e);
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Fout tijdens BAG2 proces", (Throwable)e);
            listener.exception((Throwable)e);
            return;
        }
        finally {
            if (exitCode == 0) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                this.config.setLastrun(new Date());
                listener.updateStatus(AutomatischProces.ProcessingStatus.WAITING.toString());
            } else {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                this.config.setLastrun(new Date());
                listener.updateStatus(AutomatischProces.ProcessingStatus.ERROR.toString());
            }
            listener.addLog("BAG2 proces afgerond");
            this.config.setLastrun(new Date());
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
        }
    }
}

