/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.Calendar;
import java.util.Date;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BerichtTransformatieProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BerichtTransformatieUitvoeren
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(BerichtTransformatieUitvoeren.class);
    private final BerichtTransformatieProces config;
    private ProgressUpdateListener l;
    private boolean transformErrorOccured = false;
    private long blockTransformIndicators;
    private long statusMissingFound;

    public BerichtTransformatieUitvoeren(BerichtTransformatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.l = listener;
        this.l.updateStatus("Initialiseren...");
        this.l.addLog(String.format("Initialiseren... %tc", new Date()));
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        Object msg = String.format("Het bericht transformatie proces met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        log.info(msg);
        this.l.addLog((String)msg);
        sb.append((String)msg).append("\n");
        if (this.config.getBlockOnMissingNumbers() && this.shouldBlockTransformationByChecks() && this.shouldBlockTransformationByStatus()) {
            msg = "Er zijn " + this.blockTransformIndicators + " indicaties voor ontbrekende afgiftenummers";
            log.warn(msg);
            this.l.addLog((String)msg);
            sb.append((String)msg).append("\n");
            msg = "Er zijn " + this.statusMissingFound + " laadprocessen met status STAGING_MISSING";
            log.warn(msg);
            this.l.addLog((String)msg);
            sb.append((String)msg).append("\n");
            msg = "De automatische transformatie wordt niet gestart";
            this.l.addLog((String)msg);
            sb.append((String)msg).append("\n");
            this.config.setSamenvatting((String)msg);
            this.config.setLogfile(sb.toString());
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        } else {
            BrmoFramework brmo = null;
            try {
                DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
                DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
                DataSource dataSourceRsgbBrk = ConfigUtil.getDataSourceRsgbBrk();
                brmo = new BrmoFramework(dataSourceStaging, dataSourceRsgb, dataSourceRsgbBrk);
                brmo.setEnablePipeline(true);
                brmo.setOrderBerichten(true);
                brmo.setTransformPipelineCapacity(100);
                Thread t = brmo.toRsgb((nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
                t.join();
                if (this.transformErrorOccured) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    msg = "Handmatige transformatie vanuit de berichten pagina is noodzakelijk.";
                    sb.append((String)msg).append("\n");
                    log.warn(msg);
                    msg = String.format("Bericht transformatie proces met ID %d is niet succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                    log.error(msg);
                } else {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                    msg = String.format("Bericht transformatie proces met ID %d is succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                    log.info(msg);
                }
                sb.append((String)msg).append("\n");
                this.l.addLog((String)msg);
                this.config.setSamenvatting((String)msg);
                this.config.setLogfile(sb.toString());
            }
            catch (InterruptedException | BrmoException t) {
                log.error((Object)"Fout bij transformeren berichten naar RSGB", t);
                String m = "Fout bij transformeren berichten naar RSGB: " + ExceptionUtils.getMessage((Throwable)t);
                if (t.getCause() != null) {
                    m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
                }
                this.config.setLogfile(sb.toString());
                this.config.updateSamenvattingEnLogfile(m);
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            }
            finally {
                if (brmo != null) {
                    brmo.closeBrmoFramework();
                }
            }
        }
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
    }

    private boolean shouldBlockTransformationByChecks() {
        String sql = "select count(config_key) from automatisch_proces_config where config_key='ontbrekendenummersgevonden' and value = 'true' ";
        Object o = Stripersist.getEntityManager().createNativeQuery("select count(config_key) from automatisch_proces_config where config_key='ontbrekendenummersgevonden' and value = 'true' ").getSingleResult();
        this.blockTransformIndicators = ((Number)o).longValue();
        return this.blockTransformIndicators > 0L;
    }

    private boolean shouldBlockTransformationByStatus() {
        String sql = "select count(status) from laadproces where status = 'STAGING_MISSING'";
        Object o = Stripersist.getEntityManager().createNativeQuery("select count(status) from laadproces where status = 'STAGING_MISSING'").getSingleResult();
        this.statusMissingFound = ((Number)o).longValue();
        return this.statusMissingFound > 0L;
    }
}

