/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.persistence.staging.TopNLScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.topnl.TopNLType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class TopNLDirectoryScanner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(TopNLDirectoryScanner.class);
    private final TopNLScannerProces config;
    private final int defaultCommitPageSize = 1000;
    @Transient
    private ProgressUpdateListener listener;
    @Transient
    private Integer filterAlVerwerkt = 0;
    @Transient
    private Integer aantalGeladen = 0;
    @Transient
    private Integer progress = 0;
    public static final String[] subdirectoryNames = new String[]{TopNLType.TOP10NL.getType(), TopNLType.TOP50NL.getType(), TopNLType.TOP100NL.getType(), TopNLType.TOP250NL.getType()};

    public TopNLDirectoryScanner(TopNLScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        String msg = String.format("De TopNL scanner met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.addLog(msg);
        sb.append(msg);
        File scanDirectory = new File(this.config.getScanDirectory());
        if (!scanDirectory.isDirectory() || !scanDirectory.canExecute()) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            msg = String.format("De scan directory '%s' is geen executable directory", scanDirectory);
            this.config.setLogfile(msg);
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.listener.exception((Throwable)new BrmoException(msg));
            return;
        }
        this.config.setLogfile(sb.toString());
        int total = 0;
        HashMap<String, List> filesPerDir = new HashMap<String, List>();
        FilenameFilter ff = (dir, name) -> name.toLowerCase().endsWith(".gml");
        for (String topNLDir : subdirectoryNames) {
            File subdir = new File(scanDirectory, topNLDir);
            List fs = this.getFilesFromDirectory(subdir, ff);
            total += fs.size();
            filesPerDir.put(topNLDir, fs);
        }
        listener.total((long)total);
        for (String topNLDir : subdirectoryNames) {
            List files = (List)filesPerDir.get(topNLDir);
            Collections.sort(files);
            this.processTopNLDirectory(files, scanDirectory, topNLDir);
        }
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private List<File> getFilesFromDirectory(File dir, FilenameFilter ff) {
        File[] dirs;
        ArrayList<File> files = new ArrayList<File>();
        File[] fs = dir.listFiles(ff);
        files.addAll(Arrays.asList(fs));
        for (File d : dirs = dir.listFiles()) {
            if (!d.isDirectory()) continue;
            files.addAll(this.getFilesFromDirectory(d, ff));
        }
        return files;
    }

    private void processTopNLDirectory(List<File> files, File scanDirectory, String soort) {
        StringBuilder sb = new StringBuilder("\n" + this.config.getLogfile());
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        int commitPageSize = this.getCommitPageSize();
        String msg = String.format("Laden van TopNL type %s.", soort);
        LOG.info((Object)msg);
        this.listener.addLog(msg);
        for (File f : files) {
            Integer n;
            if (f.isDirectory()) continue;
            msg = String.format("Bestand %s is gevonden in %s.", f, scanDirectory);
            LOG.info((Object)msg);
            this.listener.addLog(msg);
            sb.append("\n").append(msg).append("\n");
            if (this.isDuplicaatLaadProces(f, soort)) {
                msg = String.format("  Bestand %s is een duplicaat en wordt overgeslagen.", f);
                this.listener.addLog(msg);
                LOG.info((Object)msg);
                sb.append(msg).append("\n");
                Integer n2 = this.filterAlVerwerkt;
                n = this.filterAlVerwerkt = Integer.valueOf(this.filterAlVerwerkt + 1);
            } else {
                LaadProces lp = new LaadProces();
                lp.setBestand_naam(this.getBestandsNaam(f));
                lp.setBestand_datum(this.getBestandsDatum(f));
                lp.setSoort(soort);
                lp.setStatus(LaadProces.STATUS.STAGING_OK);
                lp.setOpmerking(String.format("Type %s bestand geladen van %s op %s", soort, f.getAbsolutePath(), sdf.format(new Date())));
                lp.setAutomatischProces((AutomatischProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.config.getId()));
                Stripersist.getEntityManager().persist((Object)lp);
                Stripersist.getEntityManager().merge((Object)this.config);
                n = this.aantalGeladen;
                Integer n3 = this.aantalGeladen = Integer.valueOf(this.aantalGeladen + 1);
                msg = String.format("  Bestand %s is geladen en heeft status: %s. En is van soort: %s", f, lp.getStatus(), soort);
                LOG.info((Object)msg);
                this.listener.addLog(msg);
                sb.append(msg).append("\n");
                if (this.aantalGeladen % commitPageSize == 0) {
                    LOG.debug((Object)"Tussentijds opslaan van berichten, 'commitPageSize' is bereikt");
                    Stripersist.getEntityManager().flush();
                    Stripersist.getEntityManager().getTransaction().commit();
                    Stripersist.getEntityManager().clear();
                }
            }
            this.progress = this.progress + 1;
            this.listener.progress((long)this.progress.intValue());
        }
        msg = String.format("Klaar met run op %tc", Calendar.getInstance());
        LOG.info((Object)msg);
        this.listener.updateStatus(msg);
        this.listener.addLog(msg);
        sb.append(msg);
        this.listener.addLog("\n\n**** resultaat ****");
        this.listener.addLog("\nAantal bestanden die al waren geladen: " + this.filterAlVerwerkt);
        this.listener.addLog("\nAantal bestanden geladen: " + this.aantalGeladen + "\n");
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLogfile(sb.toString());
        this.config.setLastrun(new Date());
        this.config.updateSamenvattingEnLogfile("Aantal bestanden die al waren verwerkt: " + this.filterAlVerwerkt + "\nAantal bestanden geladen: " + this.aantalGeladen + "\n");
        Stripersist.getEntityManager().merge((Object)this.config);
    }

    private int getCommitPageSize() {
        int commitPageSize;
        try {
            String s = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("commitPageSize")));
            commitPageSize = Integer.parseInt(s);
            if (commitPageSize < 1 || commitPageSize > 1000) {
                commitPageSize = 1000;
            }
        }
        catch (NumberFormatException nfe) {
            commitPageSize = 1000;
        }
        LOG.debug((Object)("Instellen van commit page size op: " + commitPageSize));
        return commitPageSize;
    }
}

