/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AfgifteNummerScannerProces;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BAG2MutatieProces;
import nl.b3p.brmo.persistence.staging.BAGScannerProces;
import nl.b3p.brmo.persistence.staging.BGTLoaderProces;
import nl.b3p.brmo.persistence.staging.BRK2ScannerProces;
import nl.b3p.brmo.persistence.staging.BRKScannerProces;
import nl.b3p.brmo.persistence.staging.BerichtDoorstuurProces;
import nl.b3p.brmo.persistence.staging.BerichtTransformatieProces;
import nl.b3p.brmo.persistence.staging.BerichtstatusRapportProces;
import nl.b3p.brmo.persistence.staging.GDS2OphaalProces;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.persistence.staging.LaadprocesStatusRapportProces;
import nl.b3p.brmo.persistence.staging.LaadprocesTransformatieProces;
import nl.b3p.brmo.persistence.staging.MailRapportageProces;
import nl.b3p.brmo.persistence.staging.MaterializedViewRefresh;
import nl.b3p.brmo.persistence.staging.TopNLScannerProces;
import nl.b3p.brmo.persistence.staging.WebMirrorBAGScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.AfgifteNummerScanner;
import nl.b3p.brmo.service.scanner.BAG2MutatieProcesRunner;
import nl.b3p.brmo.service.scanner.BAGDirectoryScanner;
import nl.b3p.brmo.service.scanner.BGTLoader;
import nl.b3p.brmo.service.scanner.BRK2DirectoryScanner;
import nl.b3p.brmo.service.scanner.BRKDirectoryScanner;
import nl.b3p.brmo.service.scanner.BerichtDoorsturenProces;
import nl.b3p.brmo.service.scanner.BerichtTransformatieUitvoeren;
import nl.b3p.brmo.service.scanner.BerichtstatusRapport;
import nl.b3p.brmo.service.scanner.GDS2OphalenProces;
import nl.b3p.brmo.service.scanner.LaadprocesStatusRapport;
import nl.b3p.brmo.service.scanner.LaadprocesTransformatieUitvoeren;
import nl.b3p.brmo.service.scanner.MailRapportage;
import nl.b3p.brmo.service.scanner.MaterializedViewRefreshUitvoeren;
import nl.b3p.brmo.service.scanner.ProcesExecutable;
import nl.b3p.brmo.service.scanner.TopNLDirectoryScanner;
import nl.b3p.brmo.service.scanner.WebMirrorBAGDirectoryScanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public abstract class AbstractExecutableProces
implements ProcesExecutable {
    private static final Log log = LogFactory.getLog(AbstractExecutableProces.class);
    protected static final int OLD_LOG_LENGTH = 3000;
    volatile boolean active = false;

    public static ProcesExecutable getProces(AutomatischProces config) {
        ProcesExecutable.ProcessingImple imple = ProcesExecutable.ProcessingImple.valueOf((String)config.getClass().getSimpleName());
        switch (1.$SwitchMap$nl$b3p$brmo$service$scanner$ProcesExecutable$ProcessingImple[imple.ordinal()]) {
            case 1: {
                return new BAG2MutatieProcesRunner((BAG2MutatieProces)config);
            }
            case 2: {
                return new BAGDirectoryScanner((BAGScannerProces)config);
            }
            case 3: {
                return new BRK2DirectoryScanner((BRK2ScannerProces)config);
            }
            case 4: {
                return new BRKDirectoryScanner((BRKScannerProces)config);
            }
            case 5: {
                return new MailRapportage((MailRapportageProces)config);
            }
            case 6: {
                return new GDS2OphalenProces((GDS2OphaalProces)config);
            }
            case 7: {
                return new BerichtTransformatieUitvoeren((BerichtTransformatieProces)config);
            }
            case 8: {
                return new BerichtDoorsturenProces((BerichtDoorstuurProces)config);
            }
            case 9: {
                return new WebMirrorBAGDirectoryScanner((WebMirrorBAGScannerProces)config);
            }
            case 10: {
                return new LaadprocesTransformatieUitvoeren((LaadprocesTransformatieProces)config);
            }
            case 11: {
                return new MaterializedViewRefreshUitvoeren((MaterializedViewRefresh)config);
            }
            case 12: {
                return new BerichtstatusRapport((BerichtstatusRapportProces)config);
            }
            case 13: {
                return new LaadprocesStatusRapport((LaadprocesStatusRapportProces)config);
            }
            case 14: {
                return new TopNLDirectoryScanner((TopNLScannerProces)config);
            }
            case 15: {
                return new AfgifteNummerScanner((AfgifteNummerScannerProces)config);
            }
            case 16: {
                return new BGTLoader((BGTLoaderProces)config);
            }
        }
        throw new IllegalArgumentException(imple.name() + " is is geen ondersteund proces...");
    }

    public boolean isRunning() {
        return this.active;
    }

    public void stop() {
        this.active = false;
    }

    public void run() {
        while (this.active) {
            try {
                this.execute();
                Thread.sleep(5000L);
            }
            catch (InterruptedException | BrmoException e) {
                log.error((Object)e.getMessage(), e);
            }
        }
    }

    protected boolean isDuplicaatLaadProces(File input, String soort) {
        log.debug((Object)("Controle voor duplicaat laadproces, soort: '" + soort + "', bestand: " + input.getName()));
        String name = this.getBestandsNaam(input);
        EntityManager em = Stripersist.getEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(LaadProces.class);
        Root from = criteriaQuery.from(LaadProces.class);
        CriteriaQuery select = criteriaQuery.select((Selection)from);
        Predicate _bestand_naam = criteriaBuilder.equal((Expression)from.get("bestand_naam"), (Object)name);
        Predicate _soort = criteriaBuilder.equal((Expression)from.get("soort"), (Object)soort);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)_bestand_naam, (Expression)_soort));
        TypedQuery typedQuery = em.createQuery(select);
        return !typedQuery.getResultList().isEmpty();
    }

    protected String getBestandsNaam(File f) {
        return f.getAbsolutePath();
    }

    protected Date getBestandsDatum(File f) {
        return new Date(f.lastModified());
    }
}

