/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BAGScannerProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BAGDirectoryScanner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(BAGDirectoryScanner.class);
    private final BAGScannerProces config;
    @Transient
    private ProgressUpdateListener listener;

    public BAGDirectoryScanner(BAGScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog).append("\n");
            }
        }
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        Object msg = String.format("De BAG scanner met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info(msg);
        listener.updateStatus((String)msg);
        listener.addLog((String)msg);
        sb.append((String)msg).append("\n");
        this.active = true;
        File scanDirectory = new File(this.config.getScanDirectory());
        if (!scanDirectory.isDirectory() || !scanDirectory.canExecute()) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
            this.active = false;
            msg = String.format("De scan directory '%s' is geen executable directory", scanDirectory);
            LOG.info(msg);
            listener.updateStatus((String)msg);
            listener.addLog((String)msg);
            this.listener.exception((Throwable)new BrmoException((String)msg));
            return;
        }
        String aDir = this.config.getArchiefDirectory();
        boolean isArchiving = aDir != null;
        File archiefDirectory = null;
        if (isArchiving) {
            archiefDirectory = new File(aDir);
            archiefDirectory.mkdirs();
            if (!archiefDirectory.isDirectory() || !archiefDirectory.canWrite()) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                this.active = false;
                msg = String.format("De archief directory '%s' is geen beschrijfbare directory", archiefDirectory);
                LOG.error(msg);
                listener.updateStatus((String)msg);
                listener.addLog((String)msg);
                this.listener.exception((Throwable)new BrmoException((String)msg));
                return;
            }
            if (!scanDirectory.canWrite()) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                this.active = false;
                msg = String.format(String.format("De scan directory '%s' is geen beschrijfbare directory", scanDirectory), new Object[0]);
                LOG.error(msg);
                listener.updateStatus((String)msg);
                listener.addLog((String)msg);
                this.listener.exception((Throwable)new BrmoException((String)msg));
                return;
            }
        }
        File[] files = scanDirectory.listFiles();
        Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
        int filterAlVerwerkt = 0;
        int aantalGeladen = 0;
        int progress = 0;
        if (files.length < 1) {
            msg = String.format("Geen bestanden gevonden in scandirectory: %s.", scanDirectory);
            LOG.info(msg);
            sb.append((String)msg).append("\n");
            listener.updateStatus((String)msg);
            listener.addLog((String)msg);
        }
        listener.total((long)files.length);
        for (File f : files) {
            if (f.isDirectory()) continue;
            msg = String.format("Bestand %s is gevonden in %s.", f, scanDirectory);
            LOG.info(msg);
            sb.append((String)msg).append("\n");
            listener.updateStatus((String)msg);
            listener.addLog((String)msg);
            BrmoFramework brmo = null;
            try {
                if (this.isDuplicaatLaadProces(f, "bag")) {
                    msg = String.format("Bestand %s is een duplicaat en wordt overgeslagen.", f);
                    LOG.info(msg);
                    sb.append((String)msg).append("\n");
                    listener.updateStatus((String)msg);
                    listener.addLog((String)msg);
                    ++filterAlVerwerkt;
                } else {
                    brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), null, null);
                    brmo.loadFromFile("bag", this.getBestandsNaam(f), this.config.getId());
                    msg = String.format("Bestand %s is geladen.", f);
                    LOG.info(msg);
                    sb.append((String)msg).append("\n");
                    listener.updateStatus((String)msg);
                    listener.addLog((String)msg);
                    ++aantalGeladen;
                }
            }
            catch (BrmoDuplicaatLaadprocesException duplicaat) {
                LOG.info((Object)duplicaat.getLocalizedMessage());
                sb.append(duplicaat.getLocalizedMessage()).append("\n");
                ++filterAlVerwerkt;
            }
            catch (BrmoLeegBestandException leegEx) {
                LOG.warn((Object)leegEx.getLocalizedMessage());
                sb.append(leegEx.getLocalizedMessage()).append("\n");
            }
            catch (BrmoException ex) {
                LOG.error((Object)ex.getLocalizedMessage());
                sb.append(ex.getLocalizedMessage()).append("\n");
            }
            finally {
                if (brmo != null) {
                    brmo.closeBrmoFramework();
                }
            }
            if (isArchiving) {
                try {
                    FileUtils.copyFileToDirectory((File)f, (File)archiefDirectory);
                    boolean succes = FileUtils.deleteQuietly((File)f);
                    msg = succes ? String.format("  Bestand %s is naar archief %s verplaatst.", f, archiefDirectory) : String.format("  Bestand %s is naar archief %s verplaatst, maar origineel kon niet worden verwijderd.", f, archiefDirectory);
                }
                catch (IOException e) {
                    msg = String.format("  Bestand %s is NIET naar archief %s verplaatst, oorzaak: (%s).", f, archiefDirectory, e.getLocalizedMessage());
                    LOG.error(msg);
                    listener.updateStatus((String)msg);
                    listener.addLog((String)msg);
                }
                LOG.info(msg);
                listener.updateStatus((String)msg);
                listener.addLog((String)msg);
                sb.append((String)msg).append("\n");
            }
            listener.progress((long)(++progress));
        }
        listener.addLog("\n\n**** resultaat ****");
        listener.addLog("Aantal bestanden die al waren geladen: " + filterAlVerwerkt);
        listener.addLog("Aantal bestanden geladen: " + aantalGeladen + "\n");
        msg = "Aantal bestanden die al waren verwerkt: " + filterAlVerwerkt + ", aantal bestanden geladen: " + aantalGeladen;
        sb.append((String)msg).append("\n");
        LOG.info(msg);
        this.config.setSamenvatting((String)msg);
        msg = String.format("De BAG scanner met ID %d is afgerond op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info(msg);
        listener.updateStatus((String)msg);
        listener.addLog((String)msg);
        sb.append((String)msg).append("\n");
        this.active = false;
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLogfile(sb.toString());
        Stripersist.getEntityManager().merge((Object)this.config);
    }
}

