/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.LaadprocesStatusRapportProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.MailRapportage;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class LaadprocesStatusRapport
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(MailRapportage.class);
    private LaadprocesStatusRapportProces config;
    @Transient
    private ProgressUpdateListener listener;

    public LaadprocesStatusRapport(LaadprocesStatusRapportProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        EntityManager em = Stripersist.getEntityManager();
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        em.merge((Object)this.config);
        em.flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog).append("\n");
            }
        }
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        String msg = String.format("De Laadproces Status Rapportage met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.updateStatus(msg);
        listener.addLog(msg);
        sb.append(msg).append("\n");
        this.active = true;
        LOG.info((Object)"Ophalen Laadproces Status informatie.");
        BrmoFramework brmo = null;
        long aantal = -1L;
        StringBuilder samenvatting = new StringBuilder("Laadproces Status overzicht");
        samenvatting.append("\n");
        try {
            brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), null, null);
            for (LaadProces.STATUS status : LaadProces.STATUS.values()) {
                aantal = brmo.getCountLaadProcessen(null, status.name());
                msg = String.format("Aantal laadprocessen met status %s: %s.", status.name(), aantal);
                sb.append(msg).append("\n");
                samenvatting.append(msg).append("\n");
                LOG.info((Object)msg);
                listener.updateStatus(msg);
                listener.addLog(msg);
            }
        }
        catch (BrmoException ex) {
            LOG.error((Object)ex.getLocalizedMessage());
            listener.exception((Throwable)ex);
            sb.append(ex.getLocalizedMessage()).append("\n");
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
        msg = String.format("De Laadproces Status Rapportage met ID %d is afgerond op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info((Object)msg);
        listener.updateStatus(msg);
        listener.addLog(msg);
        sb.append(msg).append("\n");
        this.config.setSamenvatting(samenvatting.toString());
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLastrun(new Date());
        this.config.setLogfile(sb.toString());
    }
}

