/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AfgifteNummerScannerProces;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverterFactory;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class AfgifteNummerScanner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(AfgifteNummerScanner.class);
    private AfgifteNummerScannerProces config;
    @Transient
    private ProgressUpdateListener listener;
    private boolean ontbrekendeNummersGevonden;

    public static List<String> contractnummers() {
        List<String> list;
        block8: {
            DataSource ds = ConfigUtil.getDataSourceStaging();
            Connection conn = ds.getConnection();
            try {
                GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
                String sql = "select distinct cast(value as varchar(15)) from automatisch_proces_config where config_key = 'gds2_contractnummer'";
                List contractnummers = (List)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, sql, (ResultSetHandler)new ColumnListHandler());
                contractnummers.sort(String::compareToIgnoreCase);
                DbUtils.closeQuietly((Connection)conn);
                list = Collections.unmodifiableList(contractnummers);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassCastException | IllegalArgumentException | UnsupportedOperationException | SQLException | BrmoException ex) {
                    LOG.error((Object)"Ophalen contractnummers is mislukt.", ex);
                    return Collections.emptyList();
                }
            }
            conn.close();
        }
        return list;
    }

    public AfgifteNummerScanner(AfgifteNummerScannerProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Object msg = String.format("De afgiftenummer scanner met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info(msg);
        listener.updateStatus((String)msg);
        listener.addLog((String)msg);
        String contractnummer = this.config.getContracNummer();
        String afgiftenummertype = this.config.getAfgifteNummerType();
        try {
            List afgiftenummers;
            if (afgiftenummertype == null) {
                msg = "Geen afgiftenummertype opgegeven voor opzoeken van ontbrekende afgiftenummers.";
                LOG.warn(msg);
                listener.updateStatus((String)msg);
                listener.addLog((String)msg);
                afgiftenummertype = "";
            }
            if (contractnummer == null) {
                msg = "Geen contractnummer opgegeven voor opzoeken van ontbrekende afgiftenummers.";
                LOG.info(msg);
                listener.updateStatus((String)msg);
                listener.addLog((String)msg);
            }
            if (!(afgiftenummers = this.getOntbrekendeAfgiftenummers(contractnummer, afgiftenummertype)).isEmpty()) {
                Iterator records = afgiftenummers.iterator();
                msg = "Ontbrekende " + afgiftenummertype + "s voor contractnummer: " + contractnummer;
                if (contractnummer == null) {
                    msg = "Ontbrekende " + afgiftenummertype + "s";
                }
                LOG.info(msg);
                listener.addLog((String)msg);
                long totaalToegevoegd = 0L;
                while (records.hasNext()) {
                    Map rec = (Map)records.next();
                    msg = rec.get("eerst_ontbrekend").equals(rec.get("laatst_ontbrekend")) ? afgiftenummertype + " " + rec.get("eerst_ontbrekend") + " ontbreekt (tussen laadproces.id " + rec.get("laatste_aanwezige_id") + " en " + rec.get("eerst_opvolgende_id") + ")" : "Meerdere " + afgiftenummertype + "s ontbreken; eerst ontbrekende " + afgiftenummertype + " " + rec.get("eerst_ontbrekend") + ", laatst ontbrekende " + afgiftenummertype + " " + rec.get("laatst_ontbrekend") + " (tussen laadproces.id " + rec.get("laatste_aanwezige_id") + " en " + rec.get("eerst_opvolgende_id") + ")";
                    LOG.info(msg);
                    listener.addLog((String)msg);
                    if (!this.config.getOntbrekendeAfgiftenummersToevoegen()) continue;
                    msg = "Toevoegen ontbrekende " + afgiftenummertype + "(s)";
                    LOG.debug(msg);
                    listener.addLog((String)msg);
                    listener.updateStatus((String)msg);
                    long aantalToegevoegd = this.insertOntbrekendeAfgiftenummers(((Number)rec.get("eerst_ontbrekend")).longValue(), ((Number)rec.get("laatst_ontbrekend")).longValue(), contractnummer, afgiftenummertype);
                    totaalToegevoegd += aantalToegevoegd;
                    msg = aantalToegevoegd + " ontbrekende " + afgiftenummertype + "(s) toegevoegd";
                    LOG.info(msg);
                    listener.addLog((String)msg);
                    listener.updateStatus((String)msg);
                }
                listener.total(totaalToegevoegd);
                msg = totaalToegevoegd + " ontbrekende " + afgiftenummertype + "(s) toegevoegd";
                LOG.info(msg);
                listener.addLog((String)msg);
                listener.updateStatus((String)msg);
            }
            msg = "Klaar met bepalen ontbrekende " + afgiftenummertype + "s.";
            LOG.info(msg);
            listener.addLog((String)msg);
            listener.updateStatus((String)msg);
            this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
            this.config.setLastrun(new Date());
        }
        catch (SQLException | BrmoException e) {
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            LOG.error((Object)("Fout tijdens scannen voor ontbrekende afgiftenummers van contract nummer: " + contractnummer), e);
            listener.exception(e);
        }
        finally {
            Stripersist.getEntityManager().merge((Object)this.config);
        }
    }

    long insertOntbrekendeAfgiftenummers(long eersteNummer, long laatsteNummer, String contractnummer, String afgiftenummertype) throws BrmoException {
        DataSource ds = ConfigUtil.getDataSourceStaging();
        String sql = "insert into laadproces (status, opmerking, soort, contractafgiftenummer, contractnummer, klantafgiftenummer) values (?,?,?,?,?,?)";
        Long contractafgiftenummer = null;
        Long klantafgiftenummer = null;
        long added = 0L;
        for (long number = eersteNummer; number <= laatsteNummer; ++number) {
            switch (afgiftenummertype) {
                case "contractafgiftenummer": {
                    contractafgiftenummer = number;
                    break;
                }
                default: {
                    klantafgiftenummer = number;
                }
            }
            LOG.debug((Object)("toevoegen " + afgiftenummertype + ": " + number));
            try (Connection conn = ds.getConnection();
                 PreparedStatement stmt = conn.prepareStatement("insert into laadproces (status, opmerking, soort, contractafgiftenummer, contractnummer, klantafgiftenummer) values (?,?,?,?,?,?)", new String[]{"id"});){
                GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
                QueryRunner queryRunner = new QueryRunner(geomToJdbc.isPmdKnownBroken());
                queryRunner.fillStatement(stmt, new Object[]{LaadProces.STATUS.STAGING_MISSING.name(), "Toegevoegd vanwege ontbrekend " + afgiftenummertype, "onbekend", contractafgiftenummer, contractnummer, klantafgiftenummer});
                stmt.executeUpdate();
                ScalarHandler rsh = new ScalarHandler();
                Number lpId = (Number)rsh.handle(stmt.getGeneratedKeys());
                String msg = String.format("Toegevoegd laadproces voor %s %s (contractnummer %s) heeft id: %s.", afgiftenummertype, number, contractnummer, lpId);
                this.listener.addLog(msg);
                this.listener.progress(++added);
                LOG.info((Object)msg);
                continue;
            }
            catch (SQLException s) {
                LOG.error((Object)s);
                this.listener.exception((Throwable)s);
            }
        }
        return added;
    }

    List<Map<String, Object>> getOntbrekendeAfgiftenummers(String contractnummer, String afgiftenummertype) throws BrmoException, SQLException {
        if (contractnummer == null && afgiftenummertype.equalsIgnoreCase("contractafgiftenummer")) {
            throw new BrmoException("Contractnummer voor bepalen van ontbrekende afgiftenummers ontbreekt.");
        }
        DataSource ds = ConfigUtil.getDataSourceStaging();
        try (Connection conn = ds.getConnection();){
            Object sql;
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            switch (afgiftenummertype) {
                case "contractafgiftenummer": {
                    sql = "SELECT    laadproces.contractafgiftenummer + 1 AS eerst_ontbrekend,    MIN(fr.contractafgiftenummer) - 1    AS laatst_ontbrekend,    MIN(laadproces.id)                   AS laatste_aanwezige_id,    MIN(fr.id)                           AS eerst_opvolgende_id FROM    laadproces LEFT JOIN laadproces r ON    laadproces.contractafgiftenummer = r.contractafgiftenummer - 1    AND r.contractnummer = ?  LEFT JOIN laadproces fr ON    laadproces.contractafgiftenummer < fr.contractafgiftenummer     AND fr.contractnummer = ?  WHERE    r.contractafgiftenummer IS NULL    AND fr.contractafgiftenummer IS NOT NULL    AND laadproces.contractnummer = ?  GROUP BY    laadproces.contractafgiftenummer,    r.contractafgiftenummer";
                    break;
                }
                default: {
                    sql = "SELECT    laadproces.klantafgiftenummer + 1 AS eerst_ontbrekend,    MIN(fr.klantafgiftenummer) - 1    AS laatst_ontbrekend,    MIN(laadproces.id)                AS laatste_aanwezige_id,    MIN(fr.id)                        AS eerst_opvolgende_id FROM    laadproces LEFT JOIN laadproces r ON    laadproces.klantafgiftenummer = r.klantafgiftenummer - 1" + (contractnummer == null ? "" : "    AND r.contractnummer = ? ") + " LEFT JOIN laadproces fr ON    laadproces.klantafgiftenummer < fr.klantafgiftenummer" + (contractnummer == null ? "" : "    AND fr.contractnummer = ? ") + " WHERE    r.klantafgiftenummer IS NULL    AND fr.klantafgiftenummer IS NOT NULL" + (contractnummer == null ? "" : "    AND laadproces.contractnummer = ? ") + " GROUP BY    laadproces.klantafgiftenummer,    r.klantafgiftenummer";
                }
            }
            List afgiftenummers = contractnummer == null ? (List)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, (String)sql, (ResultSetHandler)new MapListHandler()) : (List)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, (String)sql, (ResultSetHandler)new MapListHandler(), new Object[]{contractnummer, contractnummer, contractnummer});
            this.ontbrekendeNummersGevonden = !afgiftenummers.isEmpty();
            LOG.debug((Object)("Ontbrekende " + ("".equals(afgiftenummertype) ? "klantafgiftenummer" : afgiftenummertype) + "s voor contractnummer " + contractnummer + ": " + afgiftenummers));
            DbUtils.closeQuietly((Connection)conn);
            List list = afgiftenummers;
            return list;
        }
    }

    public boolean getOntbrekendeNummersGevonden() {
        return this.ontbrekendeNummersGevonden;
    }
}

