/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Transient;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.LaadprocesTransformatieProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.scanner.TopNLDirectoryScanner;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class LaadprocesTransformatieUitvoeren
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(LaadprocesTransformatieUitvoeren.class);
    private final LaadprocesTransformatieProces config;
    @Transient
    private ProgressUpdateListener listener;
    private boolean transformErrorOccured = false;

    public LaadprocesTransformatieUitvoeren(LaadprocesTransformatieProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        listener.updateStatus("Initialiseren...");
        listener.addLog(String.format("Initialiseren... %tc", new Date()));
        this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        StringBuilder sb = new StringBuilder("\n");
        String oldLog = this.config.getLogfile();
        if (oldLog != null) {
            if (oldLog.length() > 3000) {
                sb.append(oldLog.substring(oldLog.length() - 300));
            } else {
                sb.append(oldLog);
            }
        }
        Object msg = String.format("Het laadproces transformatie proces met ID %d is gestart op %tc.", this.config.getId(), Calendar.getInstance());
        LOG.info(msg);
        listener.addLog((String)msg);
        sb.append((String)msg).append("\n");
        BrmoFramework brmo = null;
        try {
            long[] lpIds;
            DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
            DataSource dataSourceTopNL = null;
            if (LaadprocesTransformatieProces.LaadprocesSoorten.BR_TOPNL.getSoort().equalsIgnoreCase(this.config.getSoort())) {
                dataSourceTopNL = ConfigUtil.getDataSourceTopNL();
            }
            brmo = new BrmoFramework(dataSourceStaging, null, null, dataSourceTopNL, null);
            if (LaadprocesTransformatieProces.LaadprocesSoorten.BR_TOPNL.getSoort().equalsIgnoreCase(this.config.getSoort())) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (String type : TopNLDirectoryScanner.subdirectoryNames) {
                    ids.addAll(Arrays.asList(brmo.getLaadProcessenIds("bestand_datum", "ASC", type, "STAGING_OK")));
                }
                lpIds = ArrayUtils.toPrimitive((Long[])ids.toArray(new Long[ids.size()]));
            } else {
                lpIds = ArrayUtils.toPrimitive((Long[])brmo.getLaadProcessenIds("bestand_datum", "ASC", this.config.getSoort(), "STAGING_OK"));
            }
            brmo.setOrderBerichten(!this.config.alsStandTransformeren());
            if (lpIds == null || lpIds.length == 0) {
                msg = "Er zijn geen laadprocessen van soort " + this.config.getSoort() + " en status: 'STAGING_OK' om te transformeren.";
                LOG.info(msg);
                sb.append((String)msg).append("\n");
                listener.addLog((String)msg);
            } else {
                listener.updateStatus("Transformeren...");
                Thread t = brmo.toRsgb(RsgbProxy.BerichtSelectMode.BY_LAADPROCES, lpIds, (nl.b3p.brmo.loader.ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
                t.join();
            }
            if (this.transformErrorOccured) {
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                msg = "Handmatige transformatie vanuit de laadprocessen pagina is noodzakelijk.";
                sb.append((String)msg).append("\n");
                LOG.warn(msg);
                msg = String.format("Laadproces transformatie proces met ID %d is niet succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                LOG.error(msg);
                listener.updateStatus("Er is een fout opgetreden.");
            } else {
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                msg = String.format("Laadproces transformatie proces met ID %d is succesvol afgerond op %tc.", this.config.getId(), Calendar.getInstance());
                LOG.info(msg);
                listener.updateStatus("Transformatie afgerond.");
            }
            sb.append((String)msg).append("\n");
            this.listener.addLog((String)msg);
            this.config.setSamenvatting((String)msg);
            this.config.setLogfile(sb.toString());
        }
        catch (InterruptedException | BrmoException e) {
            LOG.error((Object)"Fout bij transformeren laadprocessen naar RSGB", e);
            String m = "Fout bij transformeren laadprocessen naar RSGB: " + ExceptionUtils.getMessage((Throwable)e);
            if (e.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            }
            this.config.setLogfile(sb.toString());
            this.config.updateSamenvattingEnLogfile(m);
            this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
            Stripersist.getEntityManager().merge((Object)this.config);
            Stripersist.getEntityManager().flush();
            Stripersist.getEntityManager().getTransaction().commit();
            Stripersist.getEntityManager().clear();
        }
    }
}

