/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.advancedfunctions.AdvancedFunctionProcess;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.WozBericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.StagingRowHandler;
import nl.b3p.brmo.loader.xml.WozXMLReader;
import nl.b3p.brmo.service.stripes.AdvancedFunctionsActionBean;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverterFactory;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
public class AdvancedFunctionsActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log LOG = LogFactory.getLog(AdvancedFunctionsActionBean.class);
    private static final String JSP = "/WEB-INF/jsp/transform/advancedfunctions.jsp";
    private static final String JSP_PROGRESS = "/WEB-INF/jsp/transform/advancedfunctionsprogress.jsp";
    private ActionBeanContext context;
    private List<AdvancedFunctionProcess> advancedFunctionProcesses;
    @Validate(required=true, on={"perform"})
    private String advancedFunctionProcessName;
    private double progress;
    private long total;
    private long processed;
    private boolean complete;
    private Date start;
    private Date update;
    private String exceptionStacktrace;
    private final String NHR_FIX_TYPERING = "Fix 'typering' en 'clazz' van nHR persoon";
    private final String NHR_ARCHIVING = "Opschonen en archiveren van nHR berichten met status RSGB_OK, ouder dan 3 maanden";
    private final String NHR_REMOVAL = "Verwijderen van nHR berichten met status ARCHIVE";
    private final String NHR_OPNIEUW_VERWERKEN = "Opnieuw verwerken van nHR berichten";
    private final String WOZ_OPNIEUW_VERWERKING = "Originele WOZ berichten opnieuw verwerken";

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public List<AdvancedFunctionProcess> getAdvancedFunctionProcesses() {
        return this.advancedFunctionProcesses;
    }

    public void setAdvancedFunctionProcesses(List<AdvancedFunctionProcess> advancedFunctionProcesses) {
        this.advancedFunctionProcesses = advancedFunctionProcesses;
    }

    public String getAdvancedFunctionProcessName() {
        return this.advancedFunctionProcessName;
    }

    public void setAdvancedFunctionProcessName(String advancedFunctionProcessName) {
        this.advancedFunctionProcessName = advancedFunctionProcessName;
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void populateAdvancedFunctionProcesses() {
        this.advancedFunctionProcesses = Arrays.asList(new AdvancedFunctionProcess("Opschonen en archiveren van nHR berichten met status RSGB_OK, ouder dan 3 maanden", "nhr", Bericht.STATUS.RSGB_OK.toString()), new AdvancedFunctionProcess("Verwijderen van nHR berichten met status ARCHIVE", "nhr", Bericht.STATUS.ARCHIVE.toString()), new AdvancedFunctionProcess("Fix 'typering' en 'clazz' van nHR persoon", "nhr", null), new AdvancedFunctionProcess("Opnieuw verwerken van nHR berichten", "nhr", null), new AdvancedFunctionProcess("Originele WOZ berichten opnieuw verwerken", "woz", null));
    }

    @DefaultHandler
    public Resolution form() {
        return new ForwardResolution(this.complete ? JSP_PROGRESS : JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/transform/advancedfunctionsprogress.jsp", delay=1000, refresh=1000)
    public Resolution perform() {
        AdvancedFunctionProcess process = null;
        for (AdvancedFunctionProcess p : this.advancedFunctionProcesses) {
            if (!p.getName().equals(this.advancedFunctionProcessName)) continue;
            process = p;
            break;
        }
        if (process == null) {
            this.getContext().getMessages().add(new SimpleMessage("Ongeldig proces", new Object[0]));
            return new ForwardResolution(JSP);
        }
        this.start = new Date();
        LOG.info((Object)("Start process: " + process.getName()));
        this.processed = 0L;
        try {
            switch (process.getName()) {
                case "Opschonen en archiveren van nHR berichten met status RSGB_OK, ouder dan 3 maanden": {
                    this.cleanupBerichten(process.getConfig(), "nhr");
                    break;
                }
                case "Verwijderen van nHR berichten met status ARCHIVE": {
                    this.deleteBerichten(process.getConfig(), "nhr");
                    break;
                }
                case "Opnieuw verwerken van nHR berichten": {
                    this.replayNHRVerwerking(process.getSoort(), process.getConfig());
                    break;
                }
                case "Fix 'typering' en 'clazz' van nHR persoon": {
                    this.fixNHRTypering(process.getSoort(), process.getConfig());
                    break;
                }
                case "Originele WOZ berichten opnieuw verwerken": {
                    this.replayWOZVerwerking();
                }
            }
            if (this.exceptionStacktrace == null) {
                this.getContext().getMessages().add(new SimpleMessage("Geavanceerde functie afgerond.", new Object[0]));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Fout bij uitvoeren geavanceerde functie", t);
            String m = "Fout bij uitvoeren geavanceerde functie: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            this.complete = true;
        }
        return new ForwardResolution(JSP_PROGRESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayWOZVerwerking() throws Exception {
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        StagingProxy stagingProxy = new StagingProxy(dataSourceStaging);
        try (Connection conn = dataSourceStaging.getConnection();){
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            Number o = (Number)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, "SELECT count(*) FROM eerder_geladen_woz", (ResultSetHandler)new ScalarHandler());
            int count = o.intValue();
            this.total((long)count);
            LOG.info((Object)("Aantal te verwerken WOZ berichten: " + count));
            int batch = 10000;
            String selectSql = "SELECT id, br_orgineel_xml, laadprocesid, datum FROM eerder_geladen_woz";
            for (int offset = 0; offset < count; offset += batch) {
                LOG.info((Object)("Ophalen WOZ berichten vanaf offset: " + offset + " tot: " + (offset + batch) + " van: " + count));
                PreparedStatement ps = conn.prepareStatement(geomToJdbc.buildPaginationSql("SELECT id, br_orgineel_xml, laadprocesid, datum FROM eerder_geladen_woz", offset, batch));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    LOG.trace((Object)("Verwerken WOZ bericht voor laadprocesid: " + rs.getLong("laadprocesid") + " met id: " + rs.getLong("id")));
                    ByteArrayInputStream origineelXMLInputStream = new ByteArrayInputStream(rs.getString("br_orgineel_xml").getBytes(StandardCharsets.UTF_8));
                    WozXMLReader reader = new WozXMLReader((InputStream)origineelXMLInputStream, null, stagingProxy);
                    while (reader.hasNext()) {
                        Bericht existingBericht;
                        WozBericht b = reader.next();
                        b.setLaadProcesId(Long.valueOf(rs.getLong("laadprocesid")));
                        b.setStatus(Bericht.STATUS.STAGING_OK);
                        b.setStatusDatum(new Date());
                        b.setSoort("woz");
                        b.setOpmerking("Herstel van eerder geladen WOZ bericht");
                        if (null == b.getObjectRef()) {
                            b.setStatus(Bericht.STATUS.STAGING_NOK);
                            b.setOpmerking("Er kon geen object_ref bepaald worden uit de natuurlijke sleutel van het bericht.");
                        }
                        if ((existingBericht = b.getVolgordeNummer() == 1 ? stagingProxy.getBerichtById(Long.valueOf(rs.getLong("id"))) : stagingProxy.getExistingBericht((Bericht)b)) == null) {
                            stagingProxy.writeBericht((Bericht)b);
                            continue;
                        }
                        b.setId(existingBericht.getId());
                        stagingProxy.updateBericht((Bericht)b);
                    }
                    ++this.processed;
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)ps);
                this.progress(this.processed);
            }
        }
        finally {
            stagingProxy.closeStagingProxy();
            LOG.info((Object)"Originele WOZ berichten opnieuw verwerken afgerond.");
        }
    }

    public void cleanupBerichten(String config, String soort) throws Exception {
        boolean offset = false;
        int progress = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -3);
        String countsql = "select count(*) from bericht where soort='" + soort + "'  and status='" + config + "' and status_datum < ? ";
        Number o = (Number)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler(), new Object[]{new Timestamp(c.getTimeInMillis())});
        if (o instanceof BigDecimal) {
            this.total(o.longValue());
        } else if (o instanceof Integer) {
            this.total(o.longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        do {
            LOG.debug((Object)String.format("Ophalen berichten batch met offset %d, limit %d, tot datum %tc, voortgang %d", 0, batch, c, progress));
            Object sql = "select * from bericht where soort='" + soort + "'  and status='" + config + "' and status_datum < ?  order by id ";
            sql = geomToJdbc.buildPaginationSql((String)sql, 0, batch);
            LOG.debug((Object)("SQL voor ophalen berichten batch: " + (String)sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, (String)sql, arg_0 -> AdvancedFunctionsActionBean.lambda$cleanupBerichten$0((RowProcessor)processor, geomToJdbc, conn, processed, arg_0), new Object[]{new Timestamp(c.getTimeInMillis())});
            this.progress((long)(progress += processed.intValue()));
            if (e == null) continue;
            DbUtils.closeQuietly((Connection)conn);
            throw e;
        } while (processed.intValue() > 0);
        DbUtils.closeQuietly((Connection)conn);
    }

    public void deleteBerichten(String config, String soort) throws Exception {
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        String countsql = "select count(*) from bericht WHERE soort='" + soort + "'  AND status='" + config + "'";
        Number o = (Number)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler());
        if (o instanceof BigDecimal) {
            this.total(o.longValue());
        } else if (o instanceof Integer) {
            this.total(o.longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        LOG.debug((Object)("Totaal te verwijderen " + config + " berichten: " + o));
        o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "DELETE FROM bericht WHERE soort='" + soort + "'  AND status='" + config + "'");
        if (o instanceof BigDecimal) {
            this.progress(o.longValue());
        } else if (o instanceof Integer) {
            this.progress(o.longValue());
        } else {
            this.progress(((Long)o).longValue());
        }
        DbUtils.closeQuietly((Connection)conn);
    }

    public void replayNHRVerwerking(String soort, String status) throws SQLException, BrmoException, Exception {
        int offset = 0;
        int batch = 1000;
        MutableInt processed = new MutableInt(0);
        DataSource dataSourceStaging = ConfigUtil.getDataSourceStaging();
        DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
        Connection conn = dataSourceStaging.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        StagingRowHandler processor = new StagingRowHandler();
        LOG.debug((Object)("staging datasource: " + dataSourceStaging));
        LOG.debug((Object)("rsgb datasource: " + dataSourceRsgb));
        String countsql = "select count(id) from bericht where soort='" + soort + "' and status='" + status + "'";
        LOG.debug((Object)("SQL voor tellen van berichten batch: " + countsql));
        Number o = (Number)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler());
        LOG.debug((Object)("Totaal te verwerken verwijder berichten: " + o));
        if (o instanceof BigDecimal) {
            this.total(o.longValue());
        } else if (o instanceof Integer) {
            this.total(o.longValue());
        } else {
            this.total(((Long)o).longValue());
        }
        StagingProxy staging = new StagingProxy(dataSourceStaging);
        RsgbProxy rsgb = new RsgbProxy(dataSourceRsgb, null, staging, Bericht.STATUS.RSGB_NOK, (ProgressUpdateListener)this);
        rsgb.setErrorState(this.getContext().getServletContext().getInitParameter("error.state"));
        rsgb.setOrderBerichten(true);
        rsgb.init();
        do {
            LOG.debug((Object)String.format("Ophalen berichten batch met offset %d, limit %d", offset, batch));
            Object sql = "select * from bericht where soort='" + soort + "' and status='" + status + "' order by id";
            sql = geomToJdbc.buildPaginationSql((String)sql, offset, batch);
            LOG.debug((Object)("SQL voor ophalen berichten batch: " + (String)sql));
            processed.setValue(0);
            Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, (String)sql, arg_0 -> AdvancedFunctionsActionBean.lambda$replayNHRVerwerking$1((RowProcessor)processor, geomToJdbc, conn, rsgb, processed, arg_0));
            this.progress((long)(offset += processed.intValue()));
            if (e == null) continue;
            DbUtils.closeQuietly((Connection)conn);
            throw e;
        } while (processed.intValue() > 0);
        DbUtils.closeQuietly((Connection)conn);
        rsgb.close();
    }

    public void fixNHRTypering(String soort, String status) throws SQLException, BrmoException, Exception {
        MutableInt _processed = new MutableInt(0);
        DataSource dataSourceRsgb = ConfigUtil.getDataSourceRsgb();
        Connection conn = dataSourceRsgb.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
        String was = "'INGESCHREVEN NIET-NATUURLIJK PERSOON'";
        String wordt = "'INGESCHREVEN NIET-NATUURLIJK PERSOON'".replace("'", "");
        int typeringColWidth = 35;
        1 tables = new /* Unavailable Anonymous Inner Class!! */;
        for (Map.Entry table : tables.entrySet()) {
            int offset = 0;
            int batch = 1000;
            String _was = ((String)table.getValue()).equalsIgnoreCase("typering") ? "'" + "'INGESCHREVEN NIET-NATUURLIJK PERSOON'".substring(0, 35) : "''INGESCHREVEN NIET-NATUURLIJK PERSOON''";
            String _wordt = ((String)table.getValue()).equalsIgnoreCase("typering") ? wordt.substring(0, 35) : wordt;
            String countsql = "select count(*) from " + (String)table.getKey() + " where " + (String)table.getValue() + " = '" + _was + "'";
            LOG.debug((Object)("SQL voor tellen van berichten batch: " + countsql));
            Number o = (Number)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, countsql, (ResultSetHandler)new ScalarHandler());
            LOG.info((Object)("Totaal te bewerken records in tabel/kolom: " + table + " is: " + o));
            if (o instanceof BigDecimal) {
                this.total(this.total + o.longValue());
            } else if (o instanceof Integer) {
                this.total(this.total + o.longValue());
            } else {
                this.total(this.total + (Long)o);
            }
            do {
                LOG.debug((Object)String.format("Update berichten batch met offset %d, limit %d", offset, batch));
                Object sql = "select * from " + (String)table.getKey() + " where " + (String)table.getValue() + " = '" + _was + "'";
                sql = geomToJdbc.buildPaginationSql((String)sql, offset, batch);
                LOG.trace((Object)("SQL voor ophalen berichten batch: " + (String)sql));
                _processed.setValue(0);
                Exception e = (Exception)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, (String)sql, rs -> {
                    while (rs.next()) {
                        try {
                            new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "update " + (String)table.getKey() + " set " + (String)table.getValue() + " = '" + _wordt + "' where " + (String)table.getValue() + " = '" + _was + "'");
                        }
                        catch (Exception e1) {
                            return e1;
                        }
                        _processed.increment();
                    }
                    return null;
                });
                offset += _processed.intValue();
                this.progress(this.processed + (long)_processed.intValue());
                if (e == null) continue;
                DbUtils.closeQuietly((Connection)conn);
                throw e;
            } while (_processed.intValue() > 0);
        }
        DbUtils.closeQuietly((Connection)conn);
    }

    private static /* synthetic */ Exception lambda$replayNHRVerwerking$1(RowProcessor processor, GeometryJdbcConverter geomToJdbc, Connection conn, RsgbProxy rsgb, MutableInt processed, ResultSet rs) throws SQLException {
        while (rs.next()) {
            try {
                Bericht bericht = (Bericht)processor.toBean(rs, Bericht.class);
                LOG.debug((Object)("Opnieuw verwerken van bericht: " + bericht));
                String oudeOpmerkingen = bericht.getOpmerking();
                bericht.setStatus(Bericht.STATUS.STAGING_OK);
                new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "update bericht set status_datum = ?, status = ? where id = ?", new Object[]{new Timestamp(bericht.getStatusDatum().getTime()), bericht.getStatus().toString(), bericht.getId()});
                rsgb.handle(bericht, rsgb.transformToTableData(bericht), true);
                bericht.setOpmerking("Opnieuw verwerkt met geavanceerde functies optie.\nNieuwe verwerkingslog (oude log daaronder)\n" + bericht.getOpmerking() + "\n\nOude verwerkingslog\n\n" + oudeOpmerkingen);
                bericht.setStatusDatum(new Date());
                new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "update bericht set opmerking = ? where id = ?", new Object[]{bericht.getOpmerking(), bericht.getId()});
            }
            catch (Exception e1) {
                return e1;
            }
            processed.increment();
        }
        return null;
    }

    private static /* synthetic */ Exception lambda$cleanupBerichten$0(RowProcessor processor, GeometryJdbcConverter geomToJdbc, Connection conn, MutableInt processed, ResultSet rs) throws SQLException {
        while (rs.next()) {
            try {
                Bericht bericht = (Bericht)processor.toBean(rs, Bericht.class);
                bericht.setBrOrgineelXml("opgeschoond");
                bericht.setBrXml("opgeschoond");
                bericht.setOpmerking("opgeschoond, status was: " + bericht.getStatus().toString());
                bericht.setStatus(Bericht.STATUS.ARCHIVE);
                bericht.setStatusDatum(new Date());
                new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, "update bericht set status_datum = ?, status = ?, opmerking = ?, br_xml = ?, br_orgineel_xml = ? where id = ?", new Object[]{new Timestamp(bericht.getStatusDatum().getTime()), bericht.getStatus().toString(), bericht.getOpmerking(), bericht.getBrXml(), bericht.getBrOrgineelXml(), bericht.getId()});
            }
            catch (Exception e1) {
                return e1;
            }
            processed.increment();
        }
        return null;
    }
}

