/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.File;
import java.util.Date;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;

@StrictBinding
public class BasisregistratieBigFileLoadActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final Log log = LogFactory.getLog(BasisregistratieBigFileLoadActionBean.class);
    private ActionBeanContext context;
    @Validate(required=true)
    private String basisregistratie;
    @Validate(required=true)
    private String filename;
    private long totalBytes;
    private long processedBytes;
    private double progress;
    private String progressDisplay;
    private boolean complete;
    private Date start;
    private Date update;

    @DefaultHandler
    @DontValidate
    public Resolution form() {
        return new ForwardResolution("/WEB-INF/jsp/bestand/form.jsp");
    }

    public void total(long bytes) {
        this.totalBytes = bytes;
    }

    public void progress(long bytes) {
        this.processedBytes = bytes;
        this.progress = 100.0 / (double)this.totalBytes * (double)this.processedBytes;
        this.progressDisplay = FileUtils.byteCountToDisplaySize((long)this.processedBytes);
        this.update = new Date();
    }

    public void exception(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WaitPage(path="/WEB-INF/jsp/bestand/bigfile.jsp", delay=1000, refresh=1000)
    public Resolution load() throws BrmoException {
        this.start = new Date();
        try {
            File f = new File(this.filename);
            if (!f.exists() || !f.canRead() || f.length() == 0L) {
                this.getContext().getMessages().add(new SimpleMessage("Bestand bestaat niet, is leeg of kan niet worden gelezen", new Object[0]));
                ForwardResolution forwardResolution = new ForwardResolution("/WEB-INF/jsp/bestand/bigfile.jsp");
                return forwardResolution;
            }
            DataSource ds = ConfigUtil.getDataSourceStaging();
            BrmoFramework brmo = new BrmoFramework(ds, null, null);
            brmo.loadFromFile(this.basisregistratie, this.filename, (ProgressUpdateListener)this, null);
            this.getContext().getMessages().add(new SimpleMessage("Klaar met inladen", new Object[0]));
        }
        catch (Throwable t) {
            log.error((Object)"Fout bij inladen bestand van server", t);
            String m = "Fout bij inladen bestand: " + ExceptionUtils.getMessage((Throwable)t);
            if (t.getCause() != null) {
                m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            }
            this.getContext().getMessages().add(new SimpleMessage(m, new Object[0]));
        }
        finally {
            this.complete = true;
        }
        return new ForwardResolution("/WEB-INF/jsp/bestand/bigfile.jsp");
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getBasisregistratie() {
        return this.basisregistratie;
    }

    public void setBasisregistratie(String basisregistratie) {
        this.basisregistratie = basisregistratie;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public void setProcessedBytes(long processedBytes) {
        this.processedBytes = processedBytes;
    }

    public String getProgressDisplay() {
        return this.progressDisplay;
    }

    public void setProgressDisplay(String progressDisplay) {
        this.progressDisplay = progressDisplay;
    }
}

