/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.TransactionRequiredException;
import javax.persistence.Transient;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.KVKMutatieserviceProces;
import nl.b3p.brmo.persistence.staging.NHRInschrijving;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.gds2.GDS2Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class KVKMutatieserviceProcesRunner
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(KVKMutatieserviceProcesRunner.class);
    private final KVKMutatieserviceProces config;
    private int pages;
    private String ophalenVanaf = "";
    private String ophalenTot = "";
    private final Set<String> kvkNummers = new HashSet();
    @Transient
    private ProgressUpdateListener listener;

    public static Log getLog() {
        return LOG;
    }

    public KVKMutatieserviceProcesRunner(KVKMutatieserviceProces config) {
        this.config = config;
    }

    public void execute() {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        listener.updateStatus("KVK Mutatieservice proces gestart op %tc.".formatted(new Date()));
        if (this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.WAITING) || this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) {
            if (this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) {
                listener.addLog("Vorige run is met ERROR status afgerond, opnieuw proberen");
            }
            try {
                listener.updateStatus(AutomatischProces.ProcessingStatus.PROCESSING.toString());
                this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
                Stripersist.getEntityManager().merge((Object)this.config);
                LOG.debug((Object)"Gebruik %s als apikey en %s als abonnementId.".formatted(this.config.getConfig().get("apikey"), this.config.getConfig().get("abonnementId")));
                GregorianCalendar tot = GDS2Util.getDatumTijd((String)ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("tot"))));
                String sVanaf = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("vanaf")));
                GregorianCalendar vanaf = tot != null && ("-1".equals(sVanaf) || "-2".equals(sVanaf) || "-3".equals(sVanaf)) ? GDS2Util.getDatumTijd((String)ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("tot"))), (int)Integer.parseInt(sVanaf)) : GDS2Util.getDatumTijd((String)sVanaf);
                this.ophalenVanaf = vanaf == null ? "" : vanaf.toZonedDateTime().format(DateTimeFormatter.ISO_INSTANT);
                this.ophalenTot = tot == null ? "" : tot.toZonedDateTime().format(DateTimeFormatter.ISO_INSTANT);
                this.getPageFromAPI(1);
                this.config.setSamenvatting("Er zijn %d pagina's van de KVK Mutatieservice opgehaald en verwerkt.".formatted(this.pages));
                this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                listener.updateStatus("KVK Mutatieservice proces voltooid op %tc.".formatted(new Date()));
            }
            catch (Exception e) {
                listener.exception((Throwable)e);
                listener.updateStatus(AutomatischProces.ProcessingStatus.ERROR.toString());
                listener.addLog(e.getMessage());
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            }
            finally {
                this.config.setLastrun(new Date());
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
            }
        } else {
            listener.addLog("KVK Mutatieservice proces is al bezig, geen actie nodig.");
            LOG.info((Object)"KVK Mutatieservice proces is al bezig, geen actie nodig.");
        }
    }

    private void getPageFromAPI(int pagina) throws JSONException, IllegalArgumentException, TransactionRequiredException, IOException, BrmoException {
        String API_URL_PARAMS = "%s%s?pagina=%d&vanaf=%s&tot=%s";
        String url = String.format("%s%s?pagina=%d&vanaf=%s&tot=%s", ((ClobElement)this.config.getConfig().get("apiurl")).getValue(), ((ClobElement)this.config.getConfig().get("abonnementId")).getValue(), pagina, this.ophalenVanaf, this.ophalenTot);
        LOG.debug((Object)("Requesting KVK Mutatieservice API: " + url));
        this.listener.progress((long)pagina);
        this.listener.updateStatus("Ophalen van pagina %d van %d van KVK mutaties.".formatted(pagina, this.pages));
        LOG.info((Object)"Ophalen van pagina %d van %d van KVK mutaties.".formatted(pagina, this.pages));
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("apikey", ((ClobElement)this.config.getConfig().get("apikey")).getValue()).header("Accept", "application/json").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                String errorMsg = "Ophalen van mutatiedata is mislukt met statuscode %s en melding: %s".formatted(response.statusCode(), StringEscapeUtils.escapeHtml4((String)response.body().replaceAll("<[^>]*>", "")));
                this.listener.updateStatus(AutomatischProces.ProcessingStatus.ERROR.toString());
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                throw new BrmoException(errorMsg);
            }
            this.parseApiResponse(response.body());
        }
        catch (InterruptedException | JSONException e) {
            LOG.error((Object)"Fout tijdens benaderen KVK Mutatieservice API data", e);
            this.listener.addLog("Fout tijdens benaderen KVK Mutatieservice API data: " + e.getMessage());
            this.listener.exception(e);
        }
    }

    private void parseApiResponse(String responseBody) throws JSONException, IllegalArgumentException, TransactionRequiredException, BrmoException, IOException {
        LOG.debug((Object)("Parsing API response: " + responseBody));
        JSONObject jsonObject = new JSONObject(responseBody);
        this.pages = jsonObject.getInt("totaalPaginas");
        int pagina = jsonObject.getInt("pagina");
        this.listener.total((long)this.pages);
        LOG.debug((Object)"Aantal signalen op pagina %d: %d".formatted(pagina, jsonObject.getInt("aantal")));
        JSONArray signalen = jsonObject.getJSONArray("signalen");
        for (int i = 0; i < signalen.length(); ++i) {
            JSONObject signaal = signalen.getJSONObject(i);
            String kvkNummer = signaal.getString("kvknummer");
            if (!this.kvkNummers.add(kvkNummer)) continue;
            this.listener.addLog("KVK nummer %s toegevoegd van pagina %d.".formatted(kvkNummer, pagina));
        }
        if (pagina < this.pages) {
            this.getPageFromAPI(pagina + 1);
        } else {
            this.listener.addLog("Alle %d pagina's KVK mutaties zijn opgehaald.".formatted(this.pages));
            this.storeKvkNummers();
        }
    }

    private void storeKvkNummers() throws IllegalArgumentException, TransactionRequiredException {
        for (String kvkNummer : this.kvkNummers) {
            NHRInschrijving inschrijving = (NHRInschrijving)Stripersist.getEntityManager().find(NHRInschrijving.class, (Object)kvkNummer);
            if (inschrijving == null) {
                inschrijving = new NHRInschrijving(kvkNummer);
            } else {
                inschrijving.setDatum(new Date());
                inschrijving.setVolgendProberen(new Date());
                inschrijving.setProbeerAantal(Integer.valueOf(0));
            }
            Stripersist.getEntityManager().merge((Object)inschrijving);
        }
        this.listener.addLog("Er zijn %s unieke KVK nummers met mutatie opgeslagen of bijgewerkt.".formatted(this.kvkNummers.size()));
    }
}

