/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.Transient;
import nl.b3p.brmo.bgt.loader.BGTDatabase;
import nl.b3p.brmo.bgt.loader.cli.BGTLoaderMain;
import nl.b3p.brmo.bgt.loader.cli.CLIOptions;
import nl.b3p.brmo.bgt.loader.cli.DatabaseOptions;
import nl.b3p.brmo.bgt.loader.cli.DownloadCommand;
import nl.b3p.brmo.bgt.loader.cli.ExtractSelectionOptions;
import nl.b3p.brmo.bgt.loader.cli.LoadOptions;
import nl.b3p.brmo.bgt.schema.BGTSchemaMapper;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.BGTLoaderProces;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.BGTLoader;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.jdbc.util.converter.PGConnectionUnwrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class BGTLoader
extends AbstractExecutableProces {
    private static final Log LOG = LogFactory.getLog(BGTLoader.class);
    private final BGTLoaderProces config;
    @Transient
    private ProgressUpdateListener listener;

    public BGTLoader(BGTLoaderProces config) {
        this.config = config;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        this.listener = listener;
        BGTLoaderMain.configureLogging((boolean)false);
        if (this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.WAITING) || this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) {
            if (this.config.getStatus().equals((Object)AutomatischProces.ProcessingStatus.ERROR)) {
                listener.addLog("Vorige run is met ERROR status afgerond, opnieuw proberen");
            }
            int exitCode = -1;
            try (Connection rsgbbgtConnection = ConfigUtil.getDataSourceRsgbBgt().getConnection();){
                String initialLoadDeltaId;
                DatabaseOptions databaseOptions = new DatabaseOptions();
                databaseOptions.setConnectionString(rsgbbgtConnection.getMetaData().getURL());
                Connection connection = rsgbbgtConnection;
                if (databaseOptions.getConnectionString().startsWith("jdbc:postgresql:")) {
                    connection = (Connection)PGConnectionUnwrapper.unwrap((Connection)rsgbbgtConnection);
                    databaseOptions.setUsePgCopy(true);
                }
                2 bgtDatabase = new /* Unavailable Anonymous Inner Class!! */;
                LoadOptions loadOptions = new LoadOptions();
                loadOptions.setIncludeHistory("true".equals(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("include-history")))));
                loadOptions.setCreateSchema("true".equals(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("create-schema")))));
                loadOptions.setLinearizeCurves("true".equals(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("linearize-curves")))));
                ExtractSelectionOptions extractSelectionOptions = new ExtractSelectionOptions();
                extractSelectionOptions.setGeoFilterWkt(ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("geo-filter"))));
                boolean noGeoFilter = StringUtils.isEmpty((CharSequence)ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("geo-filter"))));
                String fTypes = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("feature-types")));
                extractSelectionOptions.setFeatureTypes(Arrays.asList(fTypes.split(",")));
                DownloadCommand downloadCommand = new DownloadCommand();
                downloadCommand.setBGTDatabase((BGTDatabase)bgtDatabase);
                listener.updateStatus(AutomatischProces.ProcessingStatus.PROCESSING.toString());
                this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
                try {
                    initialLoadDeltaId = bgtDatabase.getMetadata(BGTSchemaMapper.Metadata.INITIAL_LOAD_DELTA_ID);
                }
                catch (SQLException e) {
                    initialLoadDeltaId = null;
                }
                if (initialLoadDeltaId == null) {
                    listener.updateStatus("Ophalen BGT stand...");
                    listener.addLog("Ophalen BGT stand gestart op " + String.valueOf(new Date()));
                    exitCode = downloadCommand.initial(databaseOptions, loadOptions, extractSelectionOptions, noGeoFilter, null, new CLIOptions(), false);
                    listener.updateStatus("Einde ophalen BGT stand");
                    listener.addLog("Einde ophalen BGT stand");
                } else {
                    listener.updateStatus("Ophalen BGT mutaties...");
                    listener.addLog("Ophalen BGT mutaties gestart op " + String.valueOf(new Date()));
                    exitCode = downloadCommand.update(databaseOptions, new CLIOptions(), null, false, false);
                    listener.updateStatus("Einde ophalen BGT mutaties");
                    listener.addLog("Einde ophalen BGT mutaties");
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e.getLocalizedMessage());
                listener.exception((Throwable)e);
            }
            catch (SQLException | BrmoException e) {
                LOG.error((Object)"Fout tijdens benaderen BGT database", e);
                listener.exception(e);
            }
            catch (Exception e) {
                LOG.error((Object)"Fout tijdens laden BGT", (Throwable)e);
                listener.exception((Throwable)e);
            }
            finally {
                if (exitCode == 0) {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
                    this.config.setLastrun(new Date());
                    listener.updateStatus(AutomatischProces.ProcessingStatus.WAITING.toString());
                } else {
                    this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                    this.config.setLastrun(new Date());
                    listener.updateStatus(AutomatischProces.ProcessingStatus.ERROR.toString());
                }
                listener.addLog("BGT laden afgerond op " + String.valueOf(new Date()));
                this.config.setLastrun(new Date());
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
            }
        }
    }
}

