/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.scanner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import javax.xml.ws.BindingProvider;
import nl.b3p.brmo.loader.entity.Brk2Bericht;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.xml.Brk2SnapshotXMLReader;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.Bericht;
import nl.b3p.brmo.persistence.staging.ClobElement;
import nl.b3p.brmo.persistence.staging.GDS2OphaalProces;
import nl.b3p.brmo.persistence.staging.LaadProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import nl.b3p.brmo.service.util.TrustManagerDelegate;
import nl.b3p.brmo.soap.util.LogMessageHandler;
import nl.b3p.gds2.GDS2Util;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragenresultaat.v20170401.BestandenlijstOpvragenResultaatType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstresultaat.afgifte.v20170401.AfgifteType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20170401.AfgifteSelectieCriteriaType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20170401.BestandKenmerkenType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20170401.FilterDatumTijdType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20170401.KlantAfgiftenummerReeksType;
import nl.kadaster.schemas.gds2.imgds.baseurl.v20170401.BaseURLType;
import nl.kadaster.schemas.gds2.service.afgifte.v20170401.Gds2AfgifteServiceV20170401;
import nl.kadaster.schemas.gds2.service.afgifte.v20170401.Gds2AfgifteServiceV20170401Service;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenResponse;
import nl.logius.digikoppeling.gb._2010._10.DataReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
public class GDS2OphalenProces
extends AbstractExecutableProces {
    private static final Log log = LogFactory.getLog(GDS2OphalenProces.class);
    private final GDS2OphaalProces config;
    @Transient
    private ProgressUpdateListener l;
    @Transient
    private SSLContext context;
    private static final int BESTANDENLIJST_ATTEMPTS = 5;
    private static final int BESTANDENLIJST_RETRY_WAIT = 10000;
    private static final int AFGIFTE_DOWNLOAD_ATTEMPTS = 5;
    private static final int AFGIFTE_DOWNLOAD_RETRY_WAIT = 3000;

    public GDS2OphalenProces(GDS2OphaalProces config) {
        this.config = config;
    }

    public static Log getLog() {
        return log;
    }

    public void execute() throws BrmoException {
        this.execute((ProgressUpdateListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressUpdateListener listener) {
        block40: {
            this.l = listener;
            try {
                BestandenlijstOpvragenResponse response;
                String alGerapporteerd;
                String artikelnummer;
                this.l.updateStatus("Initialiseren...");
                Date startDate = new Date();
                this.l.addLog(String.format("Initialiseren GDS2 ophalen proces %d... %tc", this.config.getId(), startDate));
                this.config.updateSamenvattingEnLogfile(String.format("Het GDS2 ophalen proces is gestart op %tc.", startDate));
                this.config.setStatus(AutomatischProces.ProcessingStatus.PROCESSING);
                this.config.setLastrun(startDate);
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
                BestandenlijstOpvragenRequest request = new BestandenlijstOpvragenRequest();
                BestandenlijstOpvragenType verzoek = new BestandenlijstOpvragenType();
                AfgifteSelectieCriteriaType criteria = new AfgifteSelectieCriteriaType();
                request.setVerzoek(verzoek);
                verzoek.setAfgifteSelectieCriteria(criteria);
                criteria.setBestandKenmerken(new BestandKenmerkenType());
                String contractnummer = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_contractnummer")));
                if (contractnummer != null) {
                    log.debug((Object)("GDS2 contractnummer is: " + contractnummer));
                    criteria.getBestandKenmerken().setContractnummer(contractnummer);
                }
                if ((artikelnummer = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_artikelnummer")))) != null) {
                    log.debug((Object)("GDS2 artikelnummer is: " + artikelnummer));
                    this.l.addLog("GDS2 artikelnummer is: " + artikelnummer);
                    criteria.getBestandKenmerken().setArtikelnummer(artikelnummer);
                }
                if (!"true".equals(alGerapporteerd = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_al_gerapporteerde_afgiftes"))))) {
                    criteria.setNogNietGerapporteerd(Boolean.valueOf(true));
                }
                GregorianCalendar tot = GDS2Util.getDatumTijd((String)ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("totdatum"))));
                String sVanaf = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("vanafdatum")));
                GregorianCalendar vanaf = tot != null && "-1".equals(sVanaf) | "-2".equals(sVanaf) | "-3".equals(sVanaf) ? GDS2Util.getDatumTijd((String)ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("totdatum"))), (int)Integer.parseInt(sVanaf)) : GDS2Util.getDatumTijd((String)sVanaf);
                ArrayList afgiftes = new ArrayList();
                int hoogsteKlantAfgifteNummer = -1;
                Gds2AfgifteServiceV20170401 gds2 = this.initGDS2();
                this.l.updateStatus("Uitvoeren SOAP request naar Kadaster...");
                boolean afgifteNummerGebaseerdOphalen = false;
                if (vanaf == null && tot == null) {
                    KlantAfgiftenummerReeksType afgiftenummers = new KlantAfgiftenummerReeksType();
                    String nr = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("klantafgiftenummer_vanaf")));
                    if (StringUtils.isNotBlank((CharSequence)nr)) {
                        BigInteger afgifteNrVanaf = new BigInteger(nr);
                        afgiftenummers.setKlantAfgiftenummerVanaf(afgifteNrVanaf);
                        log.info((Object)("Ophalen vanaf klant afgifte nummer: " + String.valueOf(afgifteNrVanaf)));
                        this.l.addLog("Ophalen vanaf klant afgifte nummer: " + String.valueOf(afgifteNrVanaf));
                        nr = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("klantafgiftenummer_totenmet")));
                        if (StringUtils.isNotBlank((CharSequence)nr)) {
                            BigInteger afgifteNrTM = new BigInteger(nr);
                            afgiftenummers.setKlantAfgiftenummerTotmet(afgifteNrTM);
                            log.info((Object)("Ophalen tot en met klant afgifte nummer: " + String.valueOf(afgifteNrTM)));
                            this.l.addLog("Ophalen tot en met klant afgifte nummer: " + String.valueOf(afgifteNrTM));
                        }
                        criteria.setKlantAfgiftenummerReeks(afgiftenummers);
                        afgifteNummerGebaseerdOphalen = true;
                    }
                }
                if (afgifteNummerGebaseerdOphalen) {
                    this.l.addLog("GDS2 verzoek voor afgiftenummers vanaf: " + String.valueOf(criteria.getKlantAfgiftenummerReeks().getKlantAfgiftenummerVanaf()));
                    this.l.addLog("GDS2 verzoek voor afgiftenummers tot-en-met: " + String.valueOf(criteria.getKlantAfgiftenummerReeks().getKlantAfgiftenummerTotmet()));
                    response = GDS2Util.retryBestandenLijstOpvragen((Gds2AfgifteServiceV20170401)gds2, (BestandenlijstOpvragenRequest)request, (int)5, (long)10000L);
                    hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
                    boolean hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
                    int aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
                    if (aantalInAntwoord > 0) {
                        afgiftes.addAll(response.getAntwoord().getBestandenLijst().getAfgifte());
                    }
                    this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                    this.l.addLog("Meer afgiftes beschikbaar: " + hasMore);
                    while (hasMore) {
                        criteria.getKlantAfgiftenummerReeks().setKlantAfgiftenummerVanaf(criteria.getKlantAfgiftenummerReeks().getKlantAfgiftenummerVanaf().add(BigInteger.valueOf(aantalInAntwoord)));
                        this.l.addLog("GDS2 verzoek voor afgiftenummers vanaf: " + String.valueOf(criteria.getKlantAfgiftenummerReeks().getKlantAfgiftenummerVanaf()));
                        this.l.addLog("GDS2 verzoek voor afgiftenummers tot-en-met: " + String.valueOf(criteria.getKlantAfgiftenummerReeks().getKlantAfgiftenummerTotmet()));
                        response = GDS2Util.retryBestandenLijstOpvragen((Gds2AfgifteServiceV20170401)gds2, (BestandenlijstOpvragenRequest)request, (int)5, (long)10000L);
                        hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
                        aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
                        hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
                        this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                        this.l.addLog("Meer afgiftes beschikbaar: " + hasMore);
                        if (aantalInAntwoord <= 0) continue;
                        afgiftes.addAll(response.getAntwoord().getBestandenLijst().getAfgifte());
                    }
                } else {
                    GregorianCalendar currentMoment = null;
                    boolean parseblePeriod = false;
                    int loopType = 5;
                    int loopMax = 180;
                    int loopNum = 0;
                    boolean reducePeriod = false;
                    boolean increasePeriod = false;
                    if (vanaf != null && tot != null && vanaf.before(tot)) {
                        parseblePeriod = true;
                        currentMoment = vanaf;
                    }
                    boolean morePeriods2Process = false;
                    do {
                        this.l.addLog("\n*** start periode ***");
                        if (parseblePeriod) {
                            if (reducePeriod) {
                                switch (loopType) {
                                    case 5: {
                                        currentMoment.add(loopType, -1);
                                        loopType = 11;
                                        this.l.addLog("* Verklein loop periode naar uur");
                                        break;
                                    }
                                    case 11: {
                                        currentMoment.add(loopType, -1);
                                        loopType = 12;
                                        this.l.addLog("* Verklein loop periode naar minuut");
                                        break;
                                    }
                                    default: {
                                        this.l.addLog("Niet alle gevraagde berichten zijn opgehaald");
                                    }
                                }
                                reducePeriod = false;
                            }
                            if (increasePeriod) {
                                switch (loopType) {
                                    case 11: {
                                        loopType = 5;
                                        this.l.addLog("* Vergroot loop periode naar dag");
                                        break;
                                    }
                                    case 12: {
                                        loopType = 11;
                                        this.l.addLog("* Vergroot loop periode naar uur");
                                        break;
                                    }
                                }
                                increasePeriod = false;
                            }
                            FilterDatumTijdType d = new FilterDatumTijdType();
                            d.setDatumTijdVanaf(GDS2Util.getXMLDatumTijd((GregorianCalendar)currentMoment));
                            this.l.addLog(String.format("Datum vanaf: %tc", currentMoment.getTime()));
                            currentMoment.add(loopType, 1);
                            d.setDatumTijdTotmet(GDS2Util.getXMLDatumTijd((GregorianCalendar)currentMoment));
                            this.l.addLog(String.format("Datum tot: %tc", currentMoment.getTime()));
                            criteria.setPeriode(d);
                            switch (loopType) {
                                case 11: {
                                    if (currentMoment.get(loopType) != 0) break;
                                    increasePeriod = true;
                                    break;
                                }
                                case 12: {
                                    if (currentMoment.get(loopType) != 0) break;
                                    increasePeriod = true;
                                    break;
                                }
                                default: {
                                    ++loopNum;
                                }
                            }
                            morePeriods2Process = currentMoment.before(tot) && loopNum < loopMax;
                        }
                        verzoek.setAfgifteSelectieCriteria(criteria);
                        response = GDS2Util.retryBestandenLijstOpvragen((Gds2AfgifteServiceV20170401)gds2, (BestandenlijstOpvragenRequest)request, (int)5, (long)10000L);
                        hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
                        int aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
                        this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                        boolean hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
                        this.l.addLog("Meer afgiftes beschikbaar: " + hasMore);
                        if (hasMore && "true".equals(alGerapporteerd)) {
                            reducePeriod = true;
                            morePeriods2Process = true;
                            increasePeriod = false;
                            if (parseblePeriod) continue;
                            morePeriods2Process = false;
                        }
                        if (aantalInAntwoord > 0) {
                            afgiftes.addAll(response.getAntwoord().getBestandenLijst().getAfgifte());
                        }
                        int moreCount = 0;
                        String dontGetMoreConfig = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("gds2_niet_gerapporteerde_afgiftes_niet_ophalen")));
                        while (hasMore && !"true".equals(dontGetMoreConfig)) {
                            this.l.updateStatus("Uitvoeren SOAP request naar Kadaster voor meer afgiftes..." + moreCount++);
                            criteria.setNogNietGerapporteerd(Boolean.valueOf(true));
                            response = GDS2Util.retryBestandenLijstOpvragen((Gds2AfgifteServiceV20170401)gds2, (BestandenlijstOpvragenRequest)request, (int)5, (long)10000L);
                            hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
                            List afgifteLijst = response.getAntwoord().getBestandenLijst().getAfgifte();
                            for (AfgifteType t : afgiftes) {
                                Iterator iterator;
                                if (t.getDigikoppelingExternalDatareferences() == null || t.getDigikoppelingExternalDatareferences().getDataReference() == null || !(iterator = t.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) continue;
                                DataReference dr = (DataReference)iterator.next();
                                log.info((Object)("GDS2url te downloaden: " + dr.getTransport().getLocation().getSenderUrl().getValue()));
                            }
                            afgiftes.addAll(afgifteLijst);
                            aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
                            this.l.addLog("Aantal in antwoord: " + aantalInAntwoord);
                            hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
                            this.l.addLog("Nog meer afgiftes beschikbaar: " + hasMore);
                        }
                    } while (morePeriods2Process);
                }
                this.l.total((long)afgiftes.size());
                this.l.addLog("Totaal aantal op te halen berichten: " + afgiftes.size());
                this.l.addLog("Hoogste klant afgifte nummer: " + hoogsteKlantAfgifteNummer);
                this.config.getConfig().put("hoogste_afgiftenummer", new ClobElement("" + hoogsteKlantAfgifteNummer));
                String soort = this.config.getConfig().getOrDefault("gds2_br_soort", new ClobElement("brk")).getValue();
                if (soort.equals("brk2")) {
                    this.verwerkAfgiftes(afgiftes, GDS2Util.getCertificaatBaseURL((BestandenlijstOpvragenResultaatType)response.getAntwoord()), soort);
                    break block40;
                }
                throw new BrmoException("Onbekende basisregistratie soort: " + soort);
            }
            catch (Exception e) {
                log.error((Object)"Fout bij ophalen van GDS2 berichten", (Throwable)e);
                this.config.setLastrun(new Date());
                this.config.setSamenvatting("Er is een fout opgetreden, details staan in de logs");
                this.config.setStatus(AutomatischProces.ProcessingStatus.ERROR);
                String m = "Fout bij ophalen van GDS2 berichten: " + ExceptionUtils.getMessage((Throwable)e);
                if (e.getCause() != null) {
                    m = m + ", oorzaak: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
                }
                this.l.addLog(m);
                this.l.exception((Throwable)e);
            }
            finally {
                if (Stripersist.getEntityManager().getTransaction().getRollbackOnly()) {
                    Stripersist.getEntityManager().getTransaction().rollback();
                } else {
                    Stripersist.getEntityManager().merge((Object)this.config);
                    Stripersist.getEntityManager().getTransaction().commit();
                }
                this.l.updateStatus("Uitvoeren SOAP request naar Kadaster afgerond");
            }
        }
    }

    private String getLaadprocesBestandsnaam(AfgifteType a) {
        return a.getBestand().getBestandsnaam() + " (" + a.getAfgifteID() + ")";
    }

    private boolean isAfgifteAlGeladen(AfgifteType a) {
        try {
            Stripersist.getEntityManager().createQuery("select 1 from LaadProces lp where lp.bestand_naam = :n").setParameter("n", (Object)this.getLaadprocesBestandsnaam(a)).getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    private Bericht laadAfgifte(AfgifteType a, String url, String brkSoort) throws Exception {
        Object input;
        EntityManager em = Stripersist.getEntityManager();
        Object msg = "Downloaden " + url;
        this.l.updateStatus((String)msg);
        this.l.addLog((String)msg);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int attempt = 0;
        while (true) {
            try {
                URLConnection connection = new URL(url).openConnection();
                if (connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.context.getSocketFactory());
                }
                input = (InputStream)connection.getContent();
                IOUtils.copy((InputStream)input, (OutputStream)bos);
            }
            catch (Exception e) {
                if (++attempt == 5) {
                    this.l.addLog("Fout bij laatste poging downloaden afgifte: " + e.getClass().getName() + ": " + e.getMessage());
                    throw e;
                }
                this.l.addLog("Fout bij poging " + attempt + " om afgifte te downloaden: " + e.getClass().getName() + ": " + e.getMessage());
                Thread.sleep(3000L);
                this.l.addLog("Uitvoeren poging " + (attempt + 1) + " om afgifte " + url + " te downloaden...");
                continue;
            }
            break;
        }
        LaadProces lp = new LaadProces();
        lp.setBestand_naam(this.getLaadprocesBestandsnaam(a));
        lp.setKlantafgiftenummer(a.getKlantAfgiftenummer());
        lp.setContractafgiftenummer(a.getContractAfgiftenummer());
        lp.setArtikelnummer(a.getBestandKenmerken().getArtikelnummer());
        lp.setContractnummer(a.getBestandKenmerken().getContractnummer());
        lp.setAfgifteid(a.getAfgifteID());
        lp.setAfgiftereferentie(a.getAfgiftereferentie());
        lp.setBestandsreferentie(a.getBestand().getBestandsreferentie());
        lp.setBeschikbaar_tot(a.getBeschikbaarTot().toGregorianCalendar().getTime());
        lp.setBestand_naam_hersteld(a.getBestand().getBestandsnaam());
        if (a.getDigikoppelingExternalDatareferences() != null && a.getDigikoppelingExternalDatareferences().getDataReference() != null && (input = a.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) {
            DataReference dr = (DataReference)input.next();
            lp.setBestand_datum(dr.getLifetime().getCreationTime().getValue().toGregorianCalendar().getTime());
        }
        lp.setSoort(brkSoort);
        lp.setStatus(LaadProces.STATUS.STAGING_OK);
        lp.setStatus_datum(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        lp.setOpmerking("GDS2 download van " + url + " op " + sdf.format(new Date()));
        lp.setAutomatischProces((AutomatischProces)em.find(AutomatischProces.class, (Object)this.config.getId()));
        Bericht b = new Bericht();
        b.setLaadprocesid(lp);
        b.setDatum(lp.getBestand_datum());
        b.setSoort(brkSoort);
        b.setStatus_datum(new Date());
        ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null && !entry.getName().toLowerCase().endsWith(".xml")) {
            msg = "Overslaan zip entry geen XML: " + entry.getName();
            this.l.addLog((String)msg);
            entry = zip.getNextEntry();
        }
        if (entry == null) {
            msg = "Geen geschikt XML bestand gevonden in zip bestand!";
            this.l.addLog((String)msg);
            return null;
        }
        b.setBr_orgineel_xml(IOUtils.toString((InputStream)zip, (Charset)StandardCharsets.UTF_8));
        if (log.isDebugEnabled()) {
            String fName = File.createTempFile(lp.getBestand_naam(), ".xml").getAbsolutePath();
            log.debug((Object)("Dump xml bericht naar: " + fName));
            IOUtils.write((String)b.getBr_orgineel_xml(), (Writer)new FileWriter(fName, StandardCharsets.UTF_8));
        }
        try {
            Brk2SnapshotXMLReader reader2 = new Brk2SnapshotXMLReader((InputStream)new ByteArrayInputStream(b.getBr_orgineel_xml().getBytes(StandardCharsets.UTF_8)));
            Brk2Bericht parsedBericht = reader2.next();
            String brXML = parsedBericht.getBrXml();
            Date brDatum = parsedBericht.getDatum();
            Integer brVolgordeNummer = parsedBericht.getVolgordeNummer();
            String brObjectRef = parsedBericht.getObjectRef();
            if (null != brDatum) {
                b.setDatum(brDatum);
            }
            b.setBr_xml(brXML);
            b.setVolgordenummer(brVolgordeNummer);
            if (null != brObjectRef && !brObjectRef.isBlank()) {
                b.setObject_ref(brObjectRef);
                b.setStatus(Bericht.STATUS.STAGING_OK);
                b.setOpmerking("Klaar voor verwerking.");
            } else {
                b.setStatus(Bericht.STATUS.STAGING_NOK);
                b.setOpmerking("Object Ref niet gevonden in bericht-xml, neem contact op met leverancier.");
            }
        }
        catch (Exception e) {
            b.setStatus(Bericht.STATUS.STAGING_NOK);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            b.setOpmerking("Fout bij parsen BRK bericht: " + String.valueOf(sw));
        }
        try {
            em.persist((Object)lp);
            em.persist((Object)b);
            em.merge((Object)this.config);
            em.flush();
            em.getTransaction().commit();
            em.clear();
        }
        catch (PersistenceException pe) {
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            em.getTransaction().rollback();
            em.getTransaction().begin();
            lp.setId(null);
            log.warn((Object)("Opslaan van bericht uit laadproces " + lp.getBestand_naam() + " is mislukt."), (Throwable)pe);
            log.warn((Object)("Duplicaat bericht: " + b.getObject_ref() + ":" + b.getBr_orgineel_xml() + "(" + b.getBr_xml() + ")"));
            lp.setOpmerking(lp.getOpmerking() + ": Fout, duplicaat bericht. Berichtinhoud: \n\n" + b.getBr_xml());
            b = null;
            lp.setStatus(LaadProces.STATUS.STAGING_DUPLICAAT);
            lp.setAutomatischProces((AutomatischProces)em.find(AutomatischProces.class, (Object)this.config.getId()));
            em.merge((Object)this.config);
            em.persist((Object)lp);
            em.flush();
            em.getTransaction().commit();
            em.clear();
        }
        return b;
    }

    public static boolean doorsturenBericht(AutomatischProces proces, ProgressUpdateListener l, Bericht b, String endpoint) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            Object msg;
            if (endpoint == null || endpoint.length() < 1) {
                return false;
            }
            URL url = new URL(endpoint);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", "" + b.getBr_orgineel_xml().length());
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            IOUtils.copy((InputStream)IOUtils.toInputStream((String)b.getBr_orgineel_xml(), (Charset)StandardCharsets.UTF_8), (OutputStream)conn.getOutputStream());
            conn.disconnect();
            if (conn.getResponseCode() == 200 || conn.getResponseCode() == 201 || conn.getResponseCode() == 202) {
                msg = "Bericht " + b.getObject_ref() + " op " + sdf.format(new Date()) + " doorgestuurd naar " + endpoint;
                b.setStatus(Bericht.STATUS.STAGING_FORWARDED);
            } else {
                msg = String.format("HTTP foutcode bij doorsturen bericht %s op %s naar endpoint %s: %s", b.getObject_ref(), sdf.format(new Date()), endpoint, conn.getResponseCode() + ": " + conn.getResponseMessage());
                b.setStatus(Bericht.STATUS.STAGING_NOK);
            }
            b.setOpmerking((String)msg);
            l.addLog((String)msg);
            return b.getStatus() == Bericht.STATUS.STAGING_FORWARDED;
        }
        catch (Exception e) {
            String msg = String.format("Fout bij doorsturen bericht op %s naar endpoint %s: %s", sdf.format(new Date()), endpoint, String.valueOf(e.getClass()) + ": " + e.getMessage());
            b.setOpmerking(msg);
            b.setStatus(Bericht.STATUS.STAGING_NOK);
            l.addLog(msg);
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private void verwerkAfgiftes(List<AfgifteType> afgiftes, BaseURLType baseUrl, String soort) throws Exception {
        int filterAlVerwerkt = 0;
        int aantalGeladen = 0;
        int aantalDoorgestuurd = 0;
        int progress = 0;
        ArrayList<Long> geladenBerichtIds = new ArrayList<Long>();
        String doorsturenUrl = ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("delivery_endpoint")));
        for (AfgifteType a : afgiftes) {
            String url = GDS2Util.getAfgifteURL((AfgifteType)a, (BaseURLType)baseUrl);
            if (null != url && !url.isBlank()) {
                if (this.isAfgifteAlGeladen(a)) {
                    ++filterAlVerwerkt;
                } else {
                    Bericht b = this.laadAfgifte(a, url, soort);
                    if (b != null && doorsturenUrl != null) {
                        geladenBerichtIds.add(b.getId());
                    }
                    ++aantalGeladen;
                }
            }
            this.l.progress((long)(++progress));
        }
        if (doorsturenUrl != null && !geladenBerichtIds.isEmpty()) {
            this.l.addLog("Doorsturen van de opgehaalde berichten, in totaal " + geladenBerichtIds.size());
            this.l.total((long)geladenBerichtIds.size());
            progress = 0;
            for (Long bId : geladenBerichtIds) {
                Bericht b = (Bericht)Stripersist.getEntityManager().find(Bericht.class, (Object)bId);
                this.l.updateStatus("Doorsturen bericht: " + b.getObject_ref());
                GDS2OphalenProces.doorsturenBericht((AutomatischProces)this.config, (ProgressUpdateListener)this.l, (Bericht)b, (String)doorsturenUrl);
                Stripersist.getEntityManager().merge((Object)b);
                Stripersist.getEntityManager().merge((Object)this.config);
                Stripersist.getEntityManager().flush();
                Stripersist.getEntityManager().getTransaction().commit();
                Stripersist.getEntityManager().clear();
                ++aantalDoorgestuurd;
                this.l.progress((long)(++progress));
            }
        }
        this.l.addLog("\n\n**** resultaat ****\n");
        this.l.addLog("Aantal afgiftes die al waren verwerkt: " + filterAlVerwerkt);
        this.l.addLog("\nAantal afgiftes geladen: " + aantalGeladen);
        this.l.addLog("\nAantal afgiftes doorgestuurd: " + aantalDoorgestuurd + "\n");
        this.l.addLog(String.format("Het GDS2 ophalen proces met ID %d is afgerond op %tc", this.config.getId(), Calendar.getInstance()));
        this.config.updateSamenvattingEnLogfile(String.format("Het GDS2 ophalen proces, gestart op %tc, is afgerond op %tc. \nAantal afgiftes die al waren verwerkt: %d\nAantal afgiftes geladen: %d\nAantal afgiftes doorgestuurd: %d\nHoogste klantafgiftenummer: %s", this.config.getLastrun(), Calendar.getInstance(), filterAlVerwerkt, aantalGeladen, aantalDoorgestuurd, ClobElement.nullSafeGet((ClobElement)((ClobElement)this.config.getConfig().get("hoogste_afgiftenummer")))));
        this.config.setStatus(AutomatischProces.ProcessingStatus.WAITING);
        this.config.setLastrun(new Date());
        Stripersist.getEntityManager().merge((Object)this.config);
        Stripersist.getEntityManager().flush();
        Stripersist.getEntityManager().getTransaction().commit();
        Stripersist.getEntityManager().clear();
    }

    private Gds2AfgifteServiceV20170401 initGDS2() throws Exception {
        Gds2AfgifteServiceV20170401 gds2 = new Gds2AfgifteServiceV20170401Service().getAGds2AfgifteServiceV20170401();
        BindingProvider bp = (BindingProvider)gds2;
        Map ctxt = bp.getRequestContext();
        List handlerChain = bp.getBinding().getHandlerChain();
        handlerChain.add(new LogMessageHandler());
        bp.getBinding().setHandlerChain(handlerChain);
        String endpoint = (String)ctxt.get("javax.xml.ws.service.endpoint.address");
        this.l.addLog("Kadaster endpoint: " + endpoint);
        this.l.updateStatus("Laden keys...");
        this.l.addLog("Initializing KeyManagerFactory");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("jks");
        char[] thePassword = "changeit".toCharArray();
        PrivateKey privateKey = GDS2Util.getPrivateKeyFromPEM((String)((ClobElement)this.config.getConfig().get("gds2_privkey")).getValue());
        Certificate certificate = GDS2Util.getCertificateFromPEM((String)((ClobElement)this.config.getConfig().get("gds2_pubkey")).getValue());
        ks.load(null);
        ks.setKeyEntry("thekey", privateKey, thePassword, new Certificate[]{certificate});
        kmf.init(ks, thePassword);
        this.l.updateStatus("Opzetten SSL context...");
        this.context = this.createSslContext(kmf);
        Client client = ClientProxy.getClient((Object)gds2);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        TLSClientParameters tlsClientParameters = new TLSClientParameters();
        tlsClientParameters.setSSLSocketFactory(this.context.getSocketFactory());
        http.setTlsClientParameters(tlsClientParameters);
        return gds2;
    }

    private SSLContext createSslContext(KeyManagerFactory kmf) throws KeyStoreException, IOException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
        this.l.addLog("Loading PKIX Overheid keystore");
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(GDS2Util.class.getResourceAsStream("/pkioverheid.jks"), "changeit".toCharArray());
        this.l.addLog("Initializing default TrustManagerFactory");
        TrustManagerFactory javaDefaultTrustManager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        javaDefaultTrustManager.init((KeyStore)null);
        X509TrustManager defaultX509TrustManager = null;
        for (TrustManager t : javaDefaultTrustManager.getTrustManagers()) {
            if (!(t instanceof X509TrustManager)) continue;
            defaultX509TrustManager = (X509TrustManager)t;
            break;
        }
        this.l.addLog("Initializing PKIX TrustManagerFactory");
        TrustManagerFactory customCaTrustManager = TrustManagerFactory.getInstance("PKIX");
        customCaTrustManager.init(ks);
        this.l.addLog("Initializing SSLContext");
        sslContext.init(kmf.getKeyManagers(), new TrustManager[]{new TrustManagerDelegate((X509TrustManager)customCaTrustManager.getTrustManagers()[0], defaultX509TrustManager)}, null);
        return sslContext;
    }
}

