/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.web.stripes.DirectResponseResolution;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UrlBinding(value="/post/{basisregistratie}")
@StrictBinding
public class BasisregistratieServiceActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(BasisregistratieServiceActionBean.class);
    private ActionBeanContext context;
    @Validate
    private String basisregistratie;
    private static final int ZIP_HEADER = 1347093252;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getBasisregistratie() {
        return this.basisregistratie;
    }

    public void setBasisregistratie(String basisregistratie) {
        this.basisregistratie = basisregistratie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution read() {
        HttpServletRequest req = this.getContext().getRequest();
        if (!req.getMethod().equals("POST")) {
            return new DirectResponseResolution(405, "Only POST allowed\n");
        }
        if ((long)req.getContentLength() > ConfigUtil.MAX_UPLOAD_SIZE) {
            return new DirectResponseResolution(413, String.format("Maximum upload size of %s exceeded\n", FileUtils.byteCountToDisplaySize((Number)ConfigUtil.MAX_UPLOAD_SIZE)));
        }
        BrmoFramework brmo = null;
        try {
            DataSource ds = ConfigUtil.getDataSourceStaging();
            brmo = new BrmoFramework(ds, null, null);
            BufferedInputStream in = new BufferedInputStream((InputStream)req.getInputStream());
            ((InputStream)in).mark(4);
            int header = new DataInputStream(in).readInt();
            ((InputStream)in).reset();
            String unzippedFile = null;
            if (header == 1347093252) {
                String sanitizedEntryName;
                ZipInputStream zip = new ZipInputStream(in);
                ZipEntry entry = zip.getNextEntry();
                while (entry != null && !entry.getName().toLowerCase().endsWith(".xml")) {
                    sanitizedEntryName = entry.getName().replace('\n', ' ').replace('\r', ' ');
                    log.warn((Object)("Overslaan zip entry geen XML: " + sanitizedEntryName));
                    entry = zip.getNextEntry();
                }
                if (entry == null) {
                    throw new BrmoException("Geen geschikt XML bestand gevonden in zip bestand ");
                }
                sanitizedEntryName = entry.getName().replace('\n', ' ').replace('\r', ' ');
                log.debug((Object)("Lezen XML bestand uit zip: " + sanitizedEntryName));
                unzippedFile = entry.getName();
                brmo.loadFromStream(this.basisregistratie, (InputStream)zip, this.getUniqueFilename(brmo), (Long)null);
            } else {
                brmo.loadFromStream(this.basisregistratie, (InputStream)in, this.getUniqueFilename(brmo), (Long)null);
            }
            log.info((Object)String.format("Stored %s data received via service endpoint", this.basisregistratie));
            DirectResponseResolution directResponseResolution = new DirectResponseResolution(200, "Data successfully received" + (String)(header == 1347093252 ? ", unzipped \"" + unzippedFile + "\"" : "") + " and stored\n");
            return directResponseResolution;
        }
        catch (Exception e) {
            log.error((Object)"Fout bij ontvangen basisregistratiegegevens via directe POST", (Throwable)e);
            DirectResponseResolution directResponseResolution = new DirectResponseResolution(500, String.format("Error receiving data: %s\n", ExceptionUtils.getRootCauseMessage((Throwable)e)));
            return directResponseResolution;
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
    }

    private String getUniqueFilename(BrmoFramework brmo) throws Exception {
        String name;
        boolean wait = false;
        do {
            name = "Upload op " + this.sdf.format(new Date());
            if (!wait) {
                wait = true;
                continue;
            }
            Thread.sleep(10L);
        } while (brmo.getLaadProcesIdByFileName(name) != null);
        return name;
    }
}

