/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.KVKMutatieserviceProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.KVKMutatieserviceProcesRunner;
import nl.b3p.brmo.service.scanner.ProcesExecutable;
import nl.b3p.brmo.service.scanner.ProgressUpdateListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.plugin.waitpage.WaitPage;
import org.stripesstuff.stripersist.EntityTypeConverter;
import org.stripesstuff.stripersist.Stripersist;

public class KVKMutatiesOphalenActionBean
implements ActionBean,
ProgressUpdateListener {
    private static final String JSP = "/WEB-INF/jsp/beheer/kvkmutatieserviceprocesuitvoeren.jsp";
    private static final Log LOG = LogFactory.getLog(KVKMutatiesOphalenActionBean.class);
    @Validate(converter=EntityTypeConverter.class)
    private KVKMutatieserviceProces proces;
    private ActionBeanContext context;
    private String exceptionStacktrace;
    private String status;
    private long total;
    private long processed;
    private double progress;
    private boolean complete;
    private int logLineCounter = 0;
    private Date start;
    private Date update;
    private StringBuilder log = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    @WaitPage(path="/WEB-INF/jsp/beheer/kvkmutatieserviceprocesuitvoeren.jsp", delay=1000, refresh=1000)
    public Resolution execute() {
        if (this.proces == null) {
            String samenvatting = "Geen geldig KVK Mutatieservice proces opgegeven.";
            this.getContext().getMessages().add(new SimpleMessage(samenvatting, new Object[0]));
            LOG.warn((Object)samenvatting);
            this.completed();
            return new ForwardResolution(JSP);
        }
        this.proces = (KVKMutatieserviceProces)Stripersist.getEntityManager().find(AutomatischProces.class, (Object)this.proces.getId());
        ProcesExecutable runner = AbstractExecutableProces.getProces((AutomatischProces)this.proces);
        try {
            runner.execute((ProgressUpdateListener)this);
        }
        catch (Exception ex) {
            this.proces.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.exception((Throwable)ex);
            String samenvatting = "Er is een fout opgetreden tijdens het ophalen van KVK mutaties.";
            this.addLog(samenvatting);
            this.getContext().getMessages().add(new SimpleError("Er is een fout opgetreden tijdens het ophalen van KVK mutaties. {2}", new Object[]{ex.getMessage()}));
        }
        finally {
            this.completed();
            this.proces.updateSamenvattingEnLogfile(this.log.toString());
            Stripersist.getEntityManager().merge((Object)this.proces);
            Stripersist.getEntityManager().flush();
            if (Stripersist.getEntityManager().getTransaction().isActive()) {
                Stripersist.getEntityManager().getTransaction().commit();
            }
        }
        return new ForwardResolution(JSP);
    }

    public void total(long total) {
        this.total = total;
    }

    public void progress(long progress) {
        this.processed = progress;
        if (this.total != 0L) {
            this.progress = 100.0 / (double)this.total * (double)this.processed;
        }
        this.update = new Date();
    }

    public void exception(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.exceptionStacktrace = sw.toString();
    }

    public void updateStatus(String status) {
        this.status = status;
    }

    public void addLog(String line) {
        if (this.logLineCounter > 3000) {
            for (int removeline = 0; removeline < 150; ++removeline) {
                this.log.delete(0, this.log.indexOf("\n") + 1);
            }
            this.log.trimToSize();
            this.logLineCounter = this.log.toString().split("\n").length;
        }
        this.log.append(line).append("\n");
        ++this.logLineCounter;
        KVKMutatieserviceProcesRunner.getLog().info((Object)line);
    }

    @Before
    public void before() {
        this.start = new Date();
    }

    @After
    public void completed() {
        this.complete = true;
        this.proces.setLastrun(this.update == null ? new Date() : this.update);
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public KVKMutatieserviceProces getProces() {
        return this.proces;
    }

    public void setProces(KVKMutatieserviceProces proces) {
        this.proces = proces;
    }

    public String getLog() {
        return this.log.toString();
    }

    public void setLog(String log) {
        this.log = new StringBuilder(log);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setExceptionStacktrace(String exceptionStacktrace) {
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getUpdate() {
        return this.update;
    }

    public void setUpdate(Date update) {
        this.update = update;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getProcessed() {
        return this.processed;
    }

    public void setProcessed(long processed) {
        this.processed = processed;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }
}

