/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogMessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Log LOG = LogFactory.getLog(LogMessageHandler.class);

    public Set<QName> getHeaders() {
        return Collections.EMPTY_SET;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (LOG.isTraceEnabled()) {
            try {
                Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
                String prefix = "<<< ";
                if (outboundProperty.booleanValue()) {
                    prefix = ">>> ";
                }
                Iterator i = context.getMessage().getMimeHeaders().getAllHeaders();
                while (i.hasNext()) {
                    MimeHeader h = (MimeHeader)i.next();
                    LOG.trace((Object)(prefix + " " + h.getName() + ": " + h.getValue()));
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                context.getMessage().writeTo((OutputStream)bos);
                LOG.trace((Object)(prefix + " " + bos.toString("UTF-8")));
            }
            catch (IOException | SOAPException ex) {
                LOG.trace((Object)ex);
            }
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

