/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.db;

import com.vividsolutions.jts.io.ParseException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.b3p.brmo.soap.eigendom.BenoemdObject;
import nl.b3p.brmo.soap.eigendom.BenoemdObjecten;
import nl.b3p.brmo.soap.eigendom.Brondocumenten;
import nl.b3p.brmo.soap.eigendom.Document;
import nl.b3p.brmo.soap.eigendom.EigendomMutatie;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieException;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieRequest;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieResponse;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieService;
import nl.b3p.brmo.soap.eigendom.HistorischeRelatie;
import nl.b3p.brmo.soap.eigendom.HistorischeRelaties;
import nl.b3p.brmo.soap.eigendom.MutatieEntry;
import nl.b3p.brmo.soap.eigendom.MutatieListRequest;
import nl.b3p.brmo.soap.eigendom.MutatieListResponse;
import nl.b3p.brmo.soap.eigendom.ZakelijkRecht;
import nl.b3p.brmo.soap.eigendom.ZakelijkeRechten;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EigendomInfo {
    private static final Log log = LogFactory.getLog(EigendomInfo.class);
    private static final String JNDI_NAME = "java:comp/env";
    private static final String JDBC_NAME_RSGB = "jdbc/brmo/rsgb";
    private static final String JDBC_NAME_STAGING = "jdbc/brmo/staging";
    private static final String DB_POSTGRES = "postgres";
    private static final String DB_ORACLE = "oracle";
    private static final String DB_MSSQL = "mssql";
    private static final String ID = "id";
    private static final String FROMDATE = "fromDate";
    private static final String TODATE = "toDate";
    private static final String OBJECT_PREFIX = "objectPrefix";
    private static final String IDENTIFICATIE = "identificatie";
    private static final String NAMESPACE = "namespace";
    public static final String MAXAANTALRESULTATEN = "MaxAantalResultaten";
    public static final Integer DBMAXRESULTS = 10000;
    private static DataSource stagingDs = null;
    private static DataSource rsgbDs = null;

    public static EigendomMutatieResponse createEigendomMutatieResponse(Map<String, Object> eigendomMutatieContext) throws EigendomMutatieException {
        EigendomMutatieResponse eir = new EigendomMutatieResponse();
        try {
            ArrayList entries = EigendomInfo.findEigendomMutatie(eigendomMutatieContext);
            for (EigendomMutatie e : entries) {
                eir.getEigendomMutatie().add(e);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(EigendomInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            eir.setTimestamp(now);
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(EigendomMutatieService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return eir;
    }

    public static MutatieListResponse createMutatieListResponse(Map<String, Object> mutatieListContext) throws EigendomMutatieException {
        MutatieListResponse mlr = new MutatieListResponse();
        try {
            ArrayList entries = EigendomInfo.findMutatieEntries(mutatieListContext);
            for (MutatieEntry e : entries) {
                mlr.getMutatieEntry().add(e);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(EigendomInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        XMLGregorianCalendar now = null;
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            now = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            mlr.setTimestamp(now);
        }
        catch (DatatypeConfigurationException ex) {
            Logger.getLogger(EigendomInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return mlr;
    }

    public static Map<String, Object> createMutatieListContext(MutatieListRequest request) throws EigendomMutatieException {
        HashMap<String, Object> searchContext = new HashMap<String, Object>();
        if (request == null) {
            return searchContext;
        }
        if (request.getFromDate() != null) {
            Timestamp fromDate = null;
            XMLGregorianCalendar xmlFromDate = request.getFromDate();
            if (xmlFromDate != null) {
                fromDate = new Timestamp(xmlFromDate.toGregorianCalendar().getTimeInMillis());
            }
            searchContext.put("fromDate", fromDate);
        }
        if (request.getToDate() != null) {
            Timestamp toDate = null;
            XMLGregorianCalendar xmlToDate = request.getToDate();
            if (xmlToDate != null) {
                toDate = new Timestamp(xmlToDate.toGregorianCalendar().getTimeInMillis());
            }
            searchContext.put("toDate", toDate);
        }
        if (request.getObjectprefix() != null) {
            String objectprefix = request.getObjectprefix();
            searchContext.put("objectPrefix", objectprefix);
        }
        return searchContext;
    }

    public static Map<String, Object> createEigendomMutatieContext(EigendomMutatieRequest request) throws EigendomMutatieException {
        String[] sa;
        HashMap<String, Object> searchContext = new HashMap<String, Object>();
        if (request == null) {
            return searchContext;
        }
        if (request.getIdentificatie() != null) {
            sa = request.getIdentificatie().split(":");
            if (sa.length != 2) {
                throw new EigendomMutatieException("Ongeldige invoer", "De identificatie moet bestaan uit een getal met een namespace gescheiden door ':', zoals VBO:0000001!");
            }
            if (!sa[0].equalsIgnoreCase("VBO") && !sa[0].equalsIgnoreCase("NL.KAD.OnroerendeZaak")) {
                throw new EigendomMutatieException("Ongeldige invoer", "Geldige namespaces zijn: VBO en NL.KAD.OnroerendeZaak");
            }
            searchContext.put("namespace", sa[0]);
        } else {
            throw new EigendomMutatieException("Ongeldige invoer", "Voor het opvragen is een identificatie vereist!");
        }
        searchContext.put("identificatie", sa[1]);
        if (request.getMaxAantalResultaten() != null) {
            Integer maxNum = request.getMaxAantalResultaten();
            if (maxNum > 100) {
                throw new EigendomMutatieException("Ongeldige invoer", "Er kunnen maximaal 100 objecten opgevraagd worden");
            }
            searchContext.put("MaxAantalResultaten", maxNum);
        }
        return searchContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<MutatieEntry> findMutatieEntries(Map<String, Object> searchContext) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceStaging();
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder sql = EigendomInfo.createSelectStagingSQL(searchContext, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm = EigendomInfo.addParamsSQL((PreparedStatement)stm, searchContext);
            rs = stm.executeQuery();
            ArrayList<MutatieEntry> entries = new ArrayList<MutatieEntry>();
            while (rs.next()) {
                MutatieEntry entry = new MutatieEntry();
                entry.setObjectRef(rs.getString("object_ref"));
                GregorianCalendar gcalendar = new GregorianCalendar();
                gcalendar.setTime(rs.getTimestamp("datum"));
                XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcalendar);
                entry.setDatum(xmlDate);
                entry.setVolgnummer(rs.getString("volgordenummer"));
                gcalendar.setTime(rs.getTimestamp("status_datum"));
                xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcalendar);
                entry.setStatusDatum(xmlDate);
                entries.add(entry);
            }
            ArrayList<MutatieEntry> arrayList = entries;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<EigendomMutatie> findEigendomMutatie(Map<String, Object> searchContext) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            sql = EigendomInfo.createSelectRsgbSQL(searchContext, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm = EigendomInfo.addParamsSQL((PreparedStatement)stm, searchContext);
            rs = stm.executeQuery();
            ArrayList<EigendomMutatie> entries = new ArrayList<EigendomMutatie>();
            while (rs.next()) {
                EigendomMutatie entry = new EigendomMutatie();
                if (rs.getString("app_appartementsindex") != null) {
                    entry.setAppartementsindex(rs.getString("app_appartementsindex"));
                }
                if (rs.getString("app_gemeentecode") != null) {
                    entry.setGemeentecode(rs.getString("app_gemeentecode"));
                }
                if (rs.getString("app_identif") != null) {
                    entry.setIdentificatienummer(rs.getString("app_identif"));
                }
                if (rs.getString("app_perceelnummer") != null) {
                    entry.setPerceelnummer(rs.getString("app_perceelnummer"));
                }
                if (rs.getString("app_sectie") != null) {
                    entry.setSectie(rs.getString("app_sectie"));
                }
                if (rs.getString("perceel_gemeentecode") != null) {
                    entry.setGemeentecode(rs.getString("perceel_gemeentecode"));
                }
                if (rs.getString("perceel_identif") != null) {
                    entry.setIdentificatienummer(rs.getString("perceel_identif"));
                }
                if (rs.getString("perceel_perceelnummer") != null) {
                    entry.setPerceelnummer(rs.getString("perceel_perceelnummer"));
                }
                if (rs.getString("perceel_sectie") != null) {
                    entry.setSectie(rs.getString("perceel_sectie"));
                }
                long kad_id = rs.getLong("kad_identif");
                String vo_id = null;
                if (rs.getString("vo_identif") != null) {
                    vo_id = rs.getString("vo_identif");
                }
                Brondocumenten bdbo = EigendomInfo.findBrondocumenten((String)Long.toString(kad_id));
                entry.setBrondocumenten(bdbo);
                BenoemdObjecten bon = EigendomInfo.findBenoemdObjecten((String)vo_id);
                entry.setBenoemdObjecten(bon);
                HistorischeRelaties hrs = EigendomInfo.findHistorischeRelaties((long)kad_id);
                entry.setHistorischeRelaties(hrs);
                ZakelijkeRechten zrn = EigendomInfo.findZakelijkeRechten((long)kad_id);
                entry.setZakelijkeRechten(zrn);
                entries.add(entry);
            }
            ArrayList<EigendomMutatie> arrayList = entries;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Brondocumenten findBrondocumenten(String value) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" bd.identificatie as identificatie,  ");
            resultNames.append(" bd.datum as datum ");
            StringBuilder fromSQL = new StringBuilder(" brondocument bd ");
            StringBuilder whereSQL = new StringBuilder();
            whereSQL.append(" (bd.tabel = 'APP_RE' or bd.tabel = 'KAD_PERCEEL' or bd.tabel = 'verblijfsobject') ");
            whereSQL.append(" and bd.tabel_identificatie = ? ");
            sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm.setString(1, value);
            rs = stm.executeQuery();
            Brondocumenten bdbo = new Brondocumenten();
            while (rs.next()) {
                Document entry = new Document();
                if (rs.getString("identificatie") != null) {
                    entry.setValue(rs.getString("identificatie"));
                }
                if (rs.getString("datum") != null) {
                    entry.setDatum(rs.getString("datum"));
                }
                bdbo.getDocument().add(entry);
            }
            Brondocumenten brondocumenten = bdbo;
            return brondocumenten;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BenoemdObjecten findBenoemdObjecten(String vo_id) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" gobjd.gebruiksdoel_gebouwd_obj as gebruiksdoel,  ");
            resultNames.append(" gobj.oppervlakte_obj as oppervlakte, ");
            resultNames.append(" gobj.sc_identif as identificatie ");
            StringBuilder fromSQL = new StringBuilder();
            fromSQL.append(" gebouwd_obj_gebruiksdoel gobjd ");
            fromSQL.append(" INNER JOIN gebouwd_obj gobj ");
            fromSQL.append(" ON (gobjd.fk_gbo_sc_identif = gobj.sc_identif) ");
            StringBuilder whereSQL = new StringBuilder(" gobj.sc_identif = ? ");
            sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm.setString(1, vo_id);
            rs = stm.executeQuery();
            BenoemdObjecten bon = new BenoemdObjecten();
            while (rs.next()) {
                BenoemdObject entry = new BenoemdObject();
                if (rs.getString("gebruiksdoel") != null) {
                    entry.setGebouwdObjectGebruiksdoel(rs.getString("gebruiksdoel"));
                }
                if (rs.getString("oppervlakte") != null) {
                    entry.setGebouwdObjectOppervlakte(rs.getString("oppervlakte"));
                }
                if (rs.getString("identificatie") != null) {
                    entry.setIdentificatienummer(rs.getString("identificatie"));
                }
                Brondocumenten bdn = EigendomInfo.findBrondocumenten((String)vo_id);
                entry.setBrondocumenten(bdn);
                bon.getBenoemdObject().add(entry);
            }
            BenoemdObjecten benoemdObjecten = bon;
            return benoemdObjecten;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HistorischeRelaties findHistorischeRelaties(long value) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" hr.fk_sc_rh_koz_kad_identif as identificatie,  ");
            resultNames.append(" hr.aard as aard ");
            StringBuilder fromSQL = new StringBuilder(" kad_onrrnd_zk_his_rel hr ");
            StringBuilder whereSQL = new StringBuilder(" hr.fk_sc_lh_koz_kad_identif = ? ");
            sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm.setLong(1, value);
            rs = stm.executeQuery();
            HistorischeRelaties hrs = new HistorischeRelaties();
            while (rs.next()) {
                HistorischeRelatie entry = new HistorischeRelatie();
                if (rs.getString("aard") != null) {
                    entry.setAard(rs.getString("aard"));
                }
                entry.setIdentificatienummer(Long.toString(rs.getLong("identificatie")));
                hrs.getHistorischeRelatie().add(entry);
            }
            HistorischeRelaties historischeRelaties = hrs;
            return historischeRelaties;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZakelijkeRechten findZakelijkeRechten(long kad_id) throws Exception {
        ZakelijkeRechten zrn = new ZakelijkeRechten();
        EigendomInfo.addZakelijkeRechten((ZakelijkeRechten)zrn, (long)kad_id, null);
        long grondperceel_kad_id = 0L;
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" gpa.perceel_identif as perceel_identif ");
            StringBuilder fromSQL = new StringBuilder(" v_bd_app_re_all_kad_perceel gpa ");
            StringBuilder whereSQL = new StringBuilder();
            whereSQL.append(" gpa.app_re_identif = ? ");
            sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm.setString(1, Long.toString(kad_id));
            rs = stm.executeQuery();
            if (rs.next()) {
                grondperceel_kad_id = rs.getLong("perceel_identif");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (grondperceel_kad_id != 0L) {
            EigendomInfo.addZakelijkeRechten((ZakelijkeRechten)zrn, (long)grondperceel_kad_id, (String)"grondperceel");
        }
        return zrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZakelijkeRechten addZakelijkeRechten(ZakelijkeRechten zrn, long kad_id, String type) throws Exception {
        DataSource ds = EigendomInfo.getDataSourceRsgb();
        StringBuilder sql = null;
        Statement stm = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" zr.kadaster_identif as identificatie,  ");
            resultNames.append(" ar.omschr_aard_verkregenr_recht as aardrecht, ");
            resultNames.append(" zr.fk_8pes_sc_identif as subject_id, ");
            resultNames.append(" zr.ar_teller as teller, ");
            resultNames.append(" zr.ar_noemer as noemer, ");
            resultNames.append(" inp.bsn as bsn, ");
            resultNames.append(" innp.rsin as rsin, ");
            resultNames.append(" su.kvk_nummer as kvk ");
            StringBuilder fromSQL = new StringBuilder("  zak_recht zr ");
            fromSQL.append(" LEFT OUTER JOIN aard_verkregen_recht ar ");
            fromSQL.append(" ON (zr.fk_3avr_aand = ar.aand) ");
            fromSQL.append(" INNER JOIN subject su ");
            fromSQL.append(" ON (su.identif = zr.fk_8pes_sc_identif) ");
            fromSQL.append(" LEFT OUTER JOIN ingeschr_nat_prs inp ");
            fromSQL.append(" ON (su.identif = inp.sc_identif) ");
            fromSQL.append(" LEFT OUTER JOIN ingeschr_niet_nat_prs innp ");
            fromSQL.append(" ON (su.identif = innp.sc_identif)  ");
            StringBuilder whereSQL = new StringBuilder();
            if (type != null && type.equals("grondperceel")) {
                whereSQL.append(" zr.fk_3avr_aand = '3' ");
            } else {
                whereSQL.append(" zr.kadaster_identif like 'NL.KAD.Tenaamstelling%' ");
            }
            whereSQL.append(" and zr.fk_7koz_kad_identif = ? ");
            sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            stm = conn.prepareStatement(sql.toString());
            stm.setLong(1, kad_id);
            rs = stm.executeQuery();
            while (rs.next()) {
                ZakelijkRecht entry = new ZakelijkRecht();
                if (rs.getString("identificatie") != null) {
                    entry.setIdentificatienummer(rs.getString("identificatie"));
                }
                if (rs.getString("aardrecht") != null) {
                    entry.setAardRecht(rs.getString("aardrecht"));
                }
                if (rs.getString("subject_id") != null) {
                    entry.setBSN(rs.getString("subject_id"));
                }
                if (rs.getString("bsn") != null) {
                    entry.setBSN(rs.getString("bsn"));
                }
                if (rs.getString("noemer") != null) {
                    entry.setNoemer(rs.getString("noemer"));
                }
                if (rs.getString("teller") != null) {
                    entry.setTeller(rs.getString("teller"));
                }
                zrn.getZakelijkRecht().add(entry);
            }
            ZakelijkeRechten zakelijkeRechten = zrn;
            return zakelijkeRechten;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private static StringBuilder createSelectRsgbSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = (Integer)searchContext.get("MaxAantalResultaten");
        if (maxrows == null) {
            maxrows = DBMAXRESULTS;
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        } else if (maxrows > DBMAXRESULTS) {
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        }
        maxrows = maxrows + 1;
        StringBuilder resultNames = new StringBuilder();
        resultNames.append("koz.kad_identif as kad_identif, ");
        resultNames.append("ar.ka_appartementsindex as app_appartementsindex, ");
        resultNames.append("ar.ka_kad_gemeentecode as app_gemeentecode, ");
        resultNames.append("ar.sc_kad_identif as app_identif, ");
        resultNames.append("ar.ka_perceelnummer as app_perceelnummer, ");
        resultNames.append("ar.ka_sectie as app_sectie, ");
        resultNames.append("kp.ka_kad_gemeentecode as perceel_gemeentecode, ");
        resultNames.append("kp.sc_kad_identif as perceel_identif, ");
        resultNames.append("kp.ka_perceelnummer as perceel_perceelnummer, ");
        resultNames.append("kp.ka_sectie as perceel_sectie, ");
        resultNames.append("vo.sc_identif as vo_identif");
        StringBuilder fromSQL = new StringBuilder(" kad_onrrnd_zk koz ");
        fromSQL.append("LEFT OUTER JOIN kad_perceel kp ");
        fromSQL.append("ON ( koz.kad_identif = kp.sc_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN app_re ar ");
        fromSQL.append("ON ( koz.kad_identif = ar.sc_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN benoemd_obj_kad_onrrnd_zk bokoz ");
        fromSQL.append("ON ( koz.kad_identif = bokoz.fk_nn_rh_koz_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN verblijfsobj vo ");
        fromSQL.append("ON ( bokoz.fk_nn_lh_tgo_identif = vo.sc_identif) ");
        StringBuilder whereSQL = EigendomInfo.createWhereRsgbSQL(searchContext);
        return EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, searchContext, (String)dbType);
    }

    private static StringBuilder createSelectStagingSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = (Integer)searchContext.get("MaxAantalResultaten");
        if (maxrows == null) {
            maxrows = DBMAXRESULTS;
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        } else if (maxrows > DBMAXRESULTS) {
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        }
        maxrows = maxrows + 1;
        StringBuilder resultNames = new StringBuilder();
        resultNames.append(" b.object_ref as object_ref, ");
        resultNames.append(" b.datum as datum, ");
        resultNames.append(" b.volgordenummer as volgordenummer, ");
        resultNames.append(" b.status_datum as status_datum");
        StringBuilder fromSQL = new StringBuilder(" bericht b ");
        StringBuilder whereSQL = EigendomInfo.createWhereStagingSQL(searchContext);
        return EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, searchContext, (String)dbType);
    }

    private static StringBuilder createSelectSQL(StringBuilder resultNames, StringBuilder fromSQL, StringBuilder whereSQL, Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = DBMAXRESULTS;
        if (searchContext != null) {
            maxrows = (Integer)searchContext.get("MaxAantalResultaten");
            if (maxrows == null) {
                maxrows = DBMAXRESULTS;
                searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
            } else if (maxrows > DBMAXRESULTS) {
                searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
            }
        }
        maxrows = maxrows + 1;
        StringBuilder sql = new StringBuilder();
        switch (dbType) {
            case "postgres": {
                sql.append(" SELECT ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                sql.append(" LIMIT ");
                sql.append(maxrows);
                return sql;
            }
            case "oracle": {
                sql.append(" SELECT ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                StringBuilder tempSql = new StringBuilder();
                tempSql.append(" SELECT * FROM ( ");
                tempSql.append((CharSequence)sql);
                tempSql.append(" ) WHERE ROWNUM <= ");
                tempSql.append(maxrows);
                sql = tempSql;
                return sql;
            }
            case "mssql": {
                sql.append(" SELECT ");
                sql.append(" TOP ");
                sql.append(" ( ");
                sql.append(maxrows);
                sql.append(" ) ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                return sql;
            }
        }
        throw new UnsupportedOperationException("Unknown database!");
    }

    private static StringBuilder createWhereRsgbSQL(Map<String, Object> searchContext) throws ParseException {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        String condition = null;
        if (searchContext.get("namespace").equals("VBO")) {
            condition = "    vo.sc_identif = ? ";
        } else if (searchContext.get("namespace").equals("NL.KAD.OnroerendeZaak")) {
            condition = "    koz.kad_identif = ? ";
            Long i = null;
            if (searchContext.get("identificatie") instanceof String) {
                String id = (String)searchContext.get("identificatie");
                try {
                    i = Long.parseLong(id);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"Identificatie is geen nummer. ", (Throwable)nfe);
                }
                searchContext.put("identificatie", i);
            }
        }
        EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("identificatie"), (StringBuilder)sql, (String)condition);
        return sql;
    }

    private static StringBuilder createWhereStagingSQL(Map<String, Object> searchContext) throws ParseException {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        String condition = "    b.object_ref like ? ";
        first = EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("objectPrefix"), (StringBuilder)sql, (String)condition);
        condition = "    b.status_datum >= ? ";
        first = EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("fromDate"), (StringBuilder)sql, (String)condition);
        condition = "    b.status_datum <= ? ";
        EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("toDate"), (StringBuilder)sql, (String)condition);
        return sql;
    }

    private static boolean addTerm(boolean first, Object o, StringBuilder sql, String condition) {
        if (!(o == null || o instanceof String && ((String)o).isEmpty())) {
            if (!first) {
                sql.append("AND ");
            }
            sql.append(condition);
            first = false;
        }
        return first;
    }

    private static PreparedStatement addParamsSQL(PreparedStatement stm, Map<String, Object> searchContext) throws SQLException {
        int index = 1;
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("objectPrefix"), (PreparedStatement)stm);
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("fromDate"), (PreparedStatement)stm);
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("toDate"), (PreparedStatement)stm);
        EigendomInfo.addParam((int)index, (Object)searchContext.get("identificatie"), (PreparedStatement)stm);
        return stm;
    }

    private static int addParam(int index, Object o, PreparedStatement stm) throws SQLException {
        if (!(o == null || o instanceof String && ((String)o).isEmpty())) {
            if (o instanceof String) {
                stm.setString(index++, "" + (String)o + "%");
            } else if (o instanceof Timestamp) {
                stm.setTimestamp(index++, (Timestamp)o);
            } else {
                stm.setObject(index++, o);
            }
        }
        return index;
    }

    private static DataSource getDataSourceRsgb() throws Exception {
        if (rsgbDs != null) {
            return rsgbDs;
        }
        try {
            InitialContext ic = new InitialContext();
            Context xmlContext = (Context)ic.lookup("java:comp/env");
            rsgbDs = (DataSource)xmlContext.lookup("jdbc/brmo/rsgb");
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb db. ", (Throwable)ex);
            throw ex;
        }
        return rsgbDs;
    }

    private static DataSource getDataSourceStaging() throws Exception {
        if (stagingDs != null) {
            return stagingDs;
        }
        try {
            InitialContext ic = new InitialContext();
            Context xmlContext = (Context)ic.lookup("java:comp/env");
            stagingDs = (DataSource)xmlContext.lookup("jdbc/brmo/staging");
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb db. ", (Throwable)ex);
            throw ex;
        }
        return stagingDs;
    }

    private static String getDbType(Connection conn) throws SQLException {
        String databaseProductName = conn.getMetaData().getDatabaseProductName();
        if (databaseProductName.contains("PostgreSQL")) {
            return "postgres";
        }
        if (databaseProductName.contains("Oracle")) {
            return "oracle";
        }
        if (databaseProductName.contains("Microsoft")) {
            return "mssql";
        }
        throw new UnsupportedOperationException("Unknown database: " + conn.getMetaData().getDatabaseProductName());
    }
}

