/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.brk;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlType;
import nl.b3p.brmo.soap.brk.AdressenResponse;
import nl.b3p.brmo.soap.brk.RechtenResponse;
import nl.b3p.brmo.soap.brk.RelatiesResponse;
import nl.b3p.brmo.soap.db.BrkInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlType
public class KadOnrndZkInfoResponse {
    private static final Log LOG = LogFactory.getLog(KadOnrndZkInfoResponse.class);
    private String gemeentecode;
    private String sectie;
    private String perceelnummer;
    private String appReVolgnummer;
    private String identificatie;
    private String aandSoortGrootte;
    private String begrenzingPerceel;
    private Float groottePerceel;
    private String omschr_deelperceel;
    private String aardCultuurOnbebouwd;
    private Date datumBeginGeldigheid;
    private Date datumEindeGeldigheid;
    private Float bedrag;
    private Integer koopjaar;
    private Boolean meerOnroerendgoed;
    private String type;
    private AdressenResponse adressen;
    private RechtenResponse rechten;
    private RelatiesResponse relaties;

    public String getGemeentecode() {
        return this.gemeentecode;
    }

    public void setGemeentecode(String gemeentecode) {
        this.gemeentecode = gemeentecode;
    }

    public String getSectie() {
        return this.sectie;
    }

    public void setSectie(String sectie) {
        this.sectie = sectie;
    }

    public String getPerceelnummer() {
        return this.perceelnummer;
    }

    public void setPerceelnummer(String perceelnummer) {
        this.perceelnummer = perceelnummer;
    }

    public String getAppReVolgnummer() {
        return this.appReVolgnummer;
    }

    public void setAppReVolgnummer(String appReVolgnummer) {
        this.appReVolgnummer = appReVolgnummer;
    }

    public String getIdentificatie() {
        return this.identificatie;
    }

    public void setIdentificatie(String identificatie) {
        this.identificatie = identificatie;
    }

    public String getAandSoortGrootte() {
        return this.aandSoortGrootte;
    }

    public void setAandSoortGrootte(String aandSoortGrootte) {
        this.aandSoortGrootte = aandSoortGrootte;
    }

    public String getBegrenzingPerceel() {
        return this.begrenzingPerceel;
    }

    public void setBegrenzingPerceel(String begrenzingPerceel) {
        this.begrenzingPerceel = begrenzingPerceel;
    }

    public Float getGroottePerceel() {
        return this.groottePerceel;
    }

    public void setGroottePerceel(Float groottePerceel) {
        this.groottePerceel = groottePerceel;
    }

    public String getOmschr_deelperceel() {
        return this.omschr_deelperceel;
    }

    public void setOmschr_deelperceel(String omschr_deelperceel) {
        this.omschr_deelperceel = omschr_deelperceel;
    }

    public String getAardCultuurOnbebouwd() {
        return this.aardCultuurOnbebouwd;
    }

    public void setAardCultuurOnbebouwd(String aardCultuurOnbebouwd) {
        this.aardCultuurOnbebouwd = aardCultuurOnbebouwd;
    }

    public Date getDatumBeginGeldigheid() {
        return this.datumBeginGeldigheid;
    }

    public void setDatumBeginGeldigheid(Date datumBeginGeldigheid) {
        this.datumBeginGeldigheid = datumBeginGeldigheid;
    }

    public Date getDatumEindeGeldigheid() {
        return this.datumEindeGeldigheid;
    }

    public void setDatumEindeGeldigheid(Date datumEindeGeldigheid) {
        this.datumEindeGeldigheid = datumEindeGeldigheid;
    }

    public Float getBedrag() {
        return this.bedrag;
    }

    public void setBedrag(Float bedrag) {
        this.bedrag = bedrag;
    }

    public Integer getKoopjaar() {
        return this.koopjaar;
    }

    public void setKoopjaar(Integer koopjaar) {
        this.koopjaar = koopjaar;
    }

    public Boolean isMeerOnroerendgoed() {
        return this.meerOnroerendgoed;
    }

    public void setMeerOnroerendgoed(Boolean meerOnroerendgoed) {
        this.meerOnroerendgoed = meerOnroerendgoed;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AdressenResponse getAdressen() {
        return this.adressen;
    }

    public void setAdressen(AdressenResponse adressen) {
        this.adressen = adressen;
    }

    public RechtenResponse getRechten() {
        return this.rechten;
    }

    public void setRechten(RechtenResponse rechten) {
        this.rechten = rechten;
    }

    public RelatiesResponse getRelaties() {
        return this.relaties;
    }

    public void setRelaties(RelatiesResponse relaties) {
        this.relaties = relaties;
    }

    private static StringBuilder createFullColumnsSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("    app_re.ka_sectie AS app_re_sectie,");
        sql.append("    app_re.ka_perceelnummer  AS app_re_perceelnummer,");
        sql.append("    app_re.ka_kad_gemeentecode AS app_re_kad_gemeentecode,");
        sql.append("    app_re.ka_appartementsindex,");
        sql.append("    kad_perceel.ka_sectie,");
        sql.append("    kad_perceel.ka_perceelnummer,");
        sql.append("    kad_perceel.ka_kad_gemeentecode,");
        sql.append("    kad_perceel.ka_deelperceelnummer,");
        sql.append("    kad_onrrnd_zk.dat_beg_geldh,");
        sql.append("    kad_onrrnd_zk.datum_einde_geldh,");
        sql.append("    kad_onrrnd_zk.kad_identif,");
        sql.append("    kad_perceel.aand_soort_grootte,");
        sql.append("    kad_onrrnd_zk.cu_aard_cultuur_onbebouwd,");
        sql.append("    kad_onrrnd_zk.lr_bedrag,");
        sql.append("    kad_perceel.begrenzing_perceel,");
        sql.append("    kad_perceel.grootte_perceel,");
        sql.append("    kad_onrrnd_zk.ks_koopjaar,");
        sql.append("    kad_onrrnd_zk.ks_meer_onroerendgoed,");
        sql.append("    kad_perceel.omschr_deelperceel ");
        return sql;
    }

    private static StringBuilder createFromSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("    kad_onrrnd_zk ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    kad_perceel ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = kad_perceel.sc_kad_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    app_re ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = app_re.sc_kad_identif) ");
        return sql;
    }

    private static StringBuilder createWhereSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("    kad_onrrnd_zk.kad_identif = ? ");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KadOnrndZkInfoResponse getRecord(Long id, Map<String, Object> searchContext) throws Exception {
        DataSource ds = BrkInfo.getDataSourceRsgb();
        Statement stm = null;
        Connection connRsgb = null;
        ResultSet rs = null;
        try {
            connRsgb = ds.getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            sql.append((CharSequence)KadOnrndZkInfoResponse.createFullColumnsSQL());
            sql.append("FROM ");
            sql.append((CharSequence)KadOnrndZkInfoResponse.createFromSQL());
            sql.append("WHERE ");
            sql.append((CharSequence)KadOnrndZkInfoResponse.createWhereSQL());
            LOG.trace((Object)sql);
            LOG.trace((Object)id);
            stm = connRsgb.prepareStatement(sql.toString());
            stm.setLong(1, id);
            rs = stm.executeQuery();
            KadOnrndZkInfoResponse koz = new KadOnrndZkInfoResponse();
            if (rs.next()) {
                koz.setIdentificatie(Long.toString(rs.getLong("kad_identif")));
                koz.setAandSoortGrootte(rs.getString("aand_soort_grootte"));
                koz.setAardCultuurOnbebouwd(rs.getString("cu_aard_cultuur_onbebouwd"));
                koz.setBedrag(Float.valueOf(rs.getFloat("lr_bedrag")));
                koz.setDatumBeginGeldigheid((Date)rs.getDate("dat_beg_geldh"));
                koz.setDatumEindeGeldigheid((Date)rs.getDate("datum_einde_geldh"));
                koz.setKoopjaar(Integer.valueOf(rs.getInt("ks_koopjaar")));
                koz.setMeerOnroerendgoed(Boolean.valueOf(rs.getString("ks_meer_onroerendgoed").equalsIgnoreCase("J")));
                String type = "perceel";
                if (rs.getString("ka_appartementsindex") != null) {
                    type = "appartement";
                }
                koz.setType(type);
                if (type.equalsIgnoreCase("appartement")) {
                    koz.setGemeentecode(rs.getString("app_re_kad_gemeentecode"));
                    koz.setPerceelnummer(rs.getString("app_re_perceelnummer"));
                    koz.setSectie(rs.getString("app_re_sectie"));
                    koz.setAppReVolgnummer(rs.getString("ka_appartementsindex"));
                } else {
                    koz.setGemeentecode(rs.getString("ka_kad_gemeentecode"));
                    koz.setPerceelnummer(rs.getString("ka_perceelnummer"));
                    koz.setSectie(rs.getString("ka_sectie"));
                    koz.setGroottePerceel(Float.valueOf(rs.getFloat("grootte_perceel")));
                    koz.setOmschr_deelperceel(rs.getString("omschr_deelperceel"));
                }
                koz.setRechten(RechtenResponse.getRechtenByKoz((Long)id, searchContext));
                Boolean at = (Boolean)searchContext.get("AdressenToevoegen");
                if (at != null && at.booleanValue()) {
                    koz.setAdressen(AdressenResponse.getAdressenByKoz((Long)id));
                }
            } else {
                KadOnrndZkInfoResponse kadOnrndZkInfoResponse = null;
                return kadOnrndZkInfoResponse;
            }
            KadOnrndZkInfoResponse kadOnrndZkInfoResponse = koz;
            return kadOnrndZkInfoResponse;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (connRsgb != null) {
                connRsgb.close();
            }
        }
    }
}

