/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.brmo.soap.brk.BrkInfoRequest;
import nl.b3p.brmo.soap.brk.BrkInfoResponse;
import nl.b3p.brmo.soap.brk.KadOnrndZkInfoRequest;
import nl.b3p.brmo.soap.brk.KadOnrndZkInfoResponse;
import nl.b3p.brmo.soap.brk.PerceelAdresInfoRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class BrkInfo {
    private static final Log LOG = LogFactory.getLog(BrkInfo.class);
    private static final String JNDI_NAME = "java:comp/env";
    private static final String JDBC_NAME_RSGB = "jdbc/brmo/rsgb";
    public static final String DB_POSTGRES = "postgres";
    public static final String DB_ORACLE = "oracle";
    public static final String DB_MSSQL = "mssql";
    public static final String APPREVOLGNUMMER = "appReVolgnummer";
    public static final String WOONPLAATS = "gemeenteNaam";
    public static final String GEMEENTECODE = "gemeentecode";
    public static final String HUISNUMMER = "huisnummer";
    public static final String IDENTIFICATIE = "identificatie";
    public static final String PERCEELNUMMER = "perceelnummer";
    public static final String POSTCODE = "postcode";
    public static final String SECTIE = "sectie";
    public static final String STRAATNAAM = "straatNaam";
    public static final String SUBJECTNAAM = "subjectNaam";
    public static final String ZOEKGEBIED = "zoekgebied";
    public static final String BUFFERLENGTE = "bufferLengte";
    public static final String MAXAANTALRESULTATEN = "MaxAantalResultaten";
    public static final String ADRESSENTOEVOEGEN = "AdressenToevoegen";
    public static final String GEVOELIGEINFOOPHALEN = "GevoeligeInfoOphalen";
    public static final String SUBJECTSTOEVOEGEN = "SubjectsToevoegen";
    public static final Integer DBMAXRESULTS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Long> findKozIDs(Map<String, Object> searchContext) throws SQLException, ParseException, NamingException, BrmoException {
        DataSource ds = ConfigUtil.getDataSourceRsgb();
        Statement stm = null;
        Connection connRsgb = null;
        ResultSet rs = null;
        try {
            connRsgb = ds.getConnection();
            String dbType = BrkInfo.getDbType((Connection)connRsgb);
            StringBuilder sql = BrkInfo.createSelectSQL(searchContext, (String)dbType);
            LOG.trace((Object)sql);
            LOG.trace(searchContext);
            stm = connRsgb.prepareStatement(sql.toString());
            stm = BrkInfo.addParamsSQL((PreparedStatement)stm, searchContext, (String)dbType);
            rs = stm.executeQuery();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (rs.next()) {
                ids.add(rs.getLong("identificatie"));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (connRsgb != null) {
                connRsgb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer countResults(Map<String, Object> searchContext) throws Exception {
        DataSource ds = ConfigUtil.getDataSourceRsgb();
        Statement stm = null;
        Connection connRsgb = null;
        ResultSet rs = null;
        try {
            connRsgb = ds.getConnection();
            String dbType = BrkInfo.getDbType((Connection)connRsgb);
            StringBuilder sql = BrkInfo.createCountSQL(searchContext, (String)dbType);
            LOG.trace((Object)sql);
            LOG.trace(searchContext);
            stm = connRsgb.prepareStatement(sql.toString());
            stm = BrkInfo.addParamsSQL((PreparedStatement)stm, searchContext, (String)dbType);
            rs = stm.executeQuery();
            if (rs.next()) {
                Integer n = rs.getInt("aantal");
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (connRsgb != null) {
                connRsgb.close();
            }
        }
    }

    private static StringBuilder createSelectSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = (Integer)searchContext.get("MaxAantalResultaten");
        if (maxrows == null) {
            maxrows = DBMAXRESULTS;
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        } else if (maxrows > DBMAXRESULTS) {
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        }
        maxrows = maxrows + 1;
        StringBuilder sql = new StringBuilder();
        switch (dbType) {
            case "postgres": {
                sql.append("SELECT ");
                sql.append("    DISTINCT kad_onrrnd_zk.kad_identif AS identificatie ");
                sql.append("FROM ");
                sql.append((CharSequence)BrkInfo.createFromSQL());
                sql.append("WHERE ");
                sql.append((CharSequence)BrkInfo.createWhereSQL(searchContext, (String)dbType));
                sql.append("LIMIT ");
                sql.append(maxrows);
                return sql;
            }
            case "oracle": {
                sql.append("SELECT ");
                sql.append("    DISTINCT kad_onrrnd_zk.kad_identif AS identificatie ");
                sql.append("FROM ");
                sql.append((CharSequence)BrkInfo.createFromSQL());
                sql.append("WHERE ");
                sql.append((CharSequence)BrkInfo.createWhereSQL(searchContext, (String)dbType));
                StringBuilder tempSql = new StringBuilder();
                tempSql.append("SELECT * FROM ( ");
                tempSql.append((CharSequence)sql);
                tempSql.append(" ) WHERE ROWNUM <= ");
                tempSql.append(maxrows);
                sql = tempSql;
                return sql;
            }
            case "mssql": {
                sql.append("SELECT ");
                sql.append("TOP ");
                sql.append("( ");
                sql.append(maxrows);
                sql.append(") ");
                sql.append("    DISTINCT kad_onrrnd_zk.kad_identif AS identificatie ");
                sql.append("FROM ");
                sql.append((CharSequence)BrkInfo.createFromSQL());
                sql.append("WHERE ");
                sql.append((CharSequence)BrkInfo.createWhereSQL(searchContext, (String)dbType));
                return sql;
            }
        }
        throw new UnsupportedOperationException("Unknown database!");
    }

    private static StringBuilder createCountSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append("    COUNT(DISTINCT kad_onrrnd_zk.kad_identif) AS aantal ");
        sql.append("FROM ");
        sql.append((CharSequence)BrkInfo.createFromSQL());
        sql.append("WHERE ");
        sql.append((CharSequence)BrkInfo.createWhereSQL(searchContext, (String)dbType));
        return sql;
    }

    private static StringBuilder createFromSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("    kad_onrrnd_zk ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    kad_perceel ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = kad_perceel.sc_kad_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    app_re ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = app_re.sc_kad_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    zak_recht ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = zak_recht.fk_7koz_kad_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    niet_nat_prs ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        zak_recht.fk_8pes_sc_identif = niet_nat_prs.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    nat_prs ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        zak_recht.fk_8pes_sc_identif = nat_prs.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    ander_nat_prs ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        nat_prs.sc_identif = ander_nat_prs.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    ingeschr_nat_prs ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        nat_prs.sc_identif = ingeschr_nat_prs.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    ingeschr_niet_nat_prs ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        niet_nat_prs.sc_identif = ingeschr_niet_nat_prs.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    benoemd_obj_kad_onrrnd_zk ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        kad_onrrnd_zk.kad_identif = ");
        sql.append("        benoemd_obj_kad_onrrnd_zk.fk_nn_rh_koz_kad_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    verblijfsobj ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        benoemd_obj_kad_onrrnd_zk.fk_nn_lh_tgo_identif = verblijfsobj.sc_identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    addresseerb_obj_aand ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        verblijfsobj.fk_11nra_sc_identif = addresseerb_obj_aand.identif) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    gem_openb_rmte ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        addresseerb_obj_aand.fk_7opr_identifcode = gem_openb_rmte.identifcode) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    openb_rmte_wnplts ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        gem_openb_rmte.identifcode = openb_rmte_wnplts.fk_nn_lh_opr_identifcode) ");
        sql.append("LEFT OUTER JOIN ");
        sql.append("    wnplts ");
        sql.append("ON ");
        sql.append("    ( ");
        sql.append("        openb_rmte_wnplts.fk_nn_rh_wpl_identif = wnplts.identif) ");
        return sql;
    }

    private static StringBuilder createWhereSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        String condition = "    kad_onrrnd_zk.kad_identif = ? ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("identificatie"), (StringBuilder)sql, (String)condition);
        condition = "   (    nat_prs.nm_geslachtsnaam like ?     OR niet_nat_prs.naam like ?)";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("subjectNaam"), (StringBuilder)sql, (String)condition);
        first = BrkInfo.addGeoTerm((boolean)first, (StringBuilder)sql, searchContext, (String)dbType);
        condition = "app_re.ka_appartementsindex like ? ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("appReVolgnummer"), (StringBuilder)sql, (String)condition);
        condition = "   (    app_re.ka_kad_gemeentecode like ?     OR kad_perceel.ka_kad_gemeentecode like ?) ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("gemeentecode"), (StringBuilder)sql, (String)condition);
        condition = "   (    app_re.ka_perceelnummer like ?     OR kad_perceel.ka_perceelnummer like ?) ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("perceelnummer"), (StringBuilder)sql, (String)condition);
        condition = "   (    app_re.ka_sectie like ?     OR kad_perceel.ka_sectie like ?) ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("sectie"), (StringBuilder)sql, (String)condition);
        condition = "wnplts.naam like ? ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("gemeenteNaam"), (StringBuilder)sql, (String)condition);
        condition = "gem_openb_rmte.naam_openb_rmte like ? ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("straatNaam"), (StringBuilder)sql, (String)condition);
        condition = "addresseerb_obj_aand.huinummer = ? ";
        first = BrkInfo.addTerm((boolean)first, (Object)searchContext.get("huisnummer"), (StringBuilder)sql, (String)condition);
        condition = "addresseerb_obj_aand.postcode like ? ";
        BrkInfo.addTerm((boolean)first, (Object)searchContext.get("postcode"), (StringBuilder)sql, (String)condition);
        return sql;
    }

    private static boolean addTerm(boolean first, Object o, StringBuilder sql, String condition) {
        if (o != null) {
            if (!first) {
                sql.append("AND ");
            }
            sql.append(condition);
            first = false;
        }
        return first;
    }

    private static boolean addGeoTerm(boolean first, StringBuilder sql, Map<String, Object> searchContext, String dbType) throws ParseException {
        String condition;
        String zg = (String)searchContext.get("zoekgebied");
        if (zg == null) {
            return first;
        }
        WKTReader r = new WKTReader();
        Geometry g = r.read(zg);
        Integer bl = (Integer)searchContext.get("bufferLengte");
        switch (dbType) {
            case "postgres": {
                if (bl != null) {
                    condition = "ST_Intersects(kad_perceel.begrenzing_perceel, ST_Buffer(ST_GeomFromEWKT('SRID=28992;" + zg + "'), " + bl + ") ) ";
                    break;
                }
                condition = "ST_Intersects(kad_perceel.begrenzing_perceel, ST_GeomFromEWKT('SRID=28992;" + zg + "') ) ";
                break;
            }
            case "oracle": {
                if (bl != null) {
                    condition = "SDO_GEOM.RELATE(kad_perceel.begrenzing_perceel, 'ANYINTERACT', SDO_GEOM.SDO_BUFFER(SDO_GEOMETRY(('" + zg + "'), 28992), 2, " + bl + "), 0.005 )  = 'TRUE' ";
                    break;
                }
                condition = "SDO_GEOM.RELATE(kad_perceel.begrenzing_perceel, 'ANYINTERACT', SDO_GEOMETRY(('" + zg + "'), 28992), 0.005 ) = 'TRUE' ";
                break;
            }
            case "mssql": {
                if (bl != null) {
                    String condition2 = "kad_perceel.begrenzing_perceel.STIntersects( STGeomFromText('" + zg + "',28992).STBuffer(" + bl + ") ) ";
                } else {
                    condition = "kad_perceel.begrenzing_perceel.STIntersects( STGeomFromText('" + zg + "',28992) ) ";
                    break;
                }
            }
            default: {
                throw new UnsupportedOperationException("Unknown database!");
            }
        }
        if (!first) {
            sql.append("AND ");
        }
        sql.append(condition);
        first = false;
        return first;
    }

    private static PreparedStatement addParamsSQL(PreparedStatement stm, Map<String, Object> searchContext, String dbType) throws SQLException {
        int index = 1;
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("identificatie"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("subjectNaam"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("subjectNaam"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("appReVolgnummer"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("gemeentecode"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("gemeentecode"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("perceelnummer"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("perceelnummer"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("sectie"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("sectie"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("gemeenteNaam"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("straatNaam"), (PreparedStatement)stm, (String)dbType);
        index = BrkInfo.addParam((int)index, (Object)searchContext.get("huisnummer"), (PreparedStatement)stm, (String)dbType);
        BrkInfo.addParam((int)index, (Object)searchContext.get("postcode"), (PreparedStatement)stm, (String)dbType);
        return stm;
    }

    private static int addParam(int index, Object o, PreparedStatement stm, String dbType) throws SQLException {
        if (o != null) {
            if (o instanceof String) {
                stm.setString(index++, "%" + (String)o + "%");
            } else {
                stm.setObject(index++, o);
            }
        }
        return index;
    }

    public static String getDbType(Connection connRsgb) throws SQLException {
        String databaseProductName = connRsgb.getMetaData().getDatabaseProductName();
        if (databaseProductName.contains("PostgreSQL")) {
            return "postgres";
        }
        if (databaseProductName.contains("Oracle")) {
            return "oracle";
        }
        if (databaseProductName.contains("Microsoft")) {
            return "mssql";
        }
        throw new UnsupportedOperationException("Unknown database: " + connRsgb.getMetaData().getDatabaseProductName());
    }

    public static Map<String, Object> createSearchContext(BrkInfoRequest request) {
        PerceelAdresInfoRequest pa;
        KadOnrndZkInfoRequest koz;
        HashMap<String, Object> searchContext = new HashMap<String, Object>();
        if (request == null) {
            return searchContext;
        }
        if (request.getSubjectNaam() != null) {
            searchContext.put("subjectNaam", request.getSubjectNaam());
        }
        if (request.getZoekgebied() != null) {
            searchContext.put("zoekgebied", request.getZoekgebied());
        }
        if (request.getBufferAfstand() != null) {
            searchContext.put("bufferLengte", request.getBufferAfstand());
        }
        if ((koz = request.getKadOnrndZk()) != null) {
            if (koz.getIdentificatie() != null) {
                searchContext.put("identificatie", Long.parseLong(koz.getIdentificatie()));
            }
            if (koz.getAppReVolgnummer() != null) {
                searchContext.put("appReVolgnummer", koz.getAppReVolgnummer());
            }
            if (koz.getGemeentecode() != null) {
                searchContext.put("gemeentecode", koz.getGemeentecode());
            }
            if (koz.getPerceelnummer() != null) {
                searchContext.put("perceelnummer", koz.getPerceelnummer());
            }
            if (koz.getSectie() != null) {
                searchContext.put("sectie", koz.getSectie());
            }
        }
        if ((pa = request.getPerceelAdres()) != null) {
            if (pa.getWoonplaatsNaam() != null) {
                searchContext.put("gemeenteNaam", pa.getWoonplaatsNaam());
            }
            if (pa.getHuisnummer() != null) {
                searchContext.put("huisnummer", pa.getHuisnummer());
            }
            if (pa.getPostcode() != null) {
                searchContext.put("postcode", pa.getPostcode());
            }
            if (pa.getStraatNaam() != null) {
                searchContext.put("straatNaam", pa.getStraatNaam());
            }
        }
        if (!searchContext.isEmpty()) {
            if (request.getMaxAantalResultaten() != null) {
                searchContext.put("MaxAantalResultaten", request.getMaxAantalResultaten());
            }
            if (request.getAdressenToevoegen() != null) {
                searchContext.put("AdressenToevoegen", request.getAdressenToevoegen());
            }
            if (request.getGevoeligeInfoOphalen() != null) {
                searchContext.put("GevoeligeInfoOphalen", request.getGevoeligeInfoOphalen());
            }
            if (request.getSubjectsToevoegen() != null) {
                searchContext.put("SubjectsToevoegen", request.getSubjectsToevoegen());
            }
        }
        return searchContext;
    }

    public static BrkInfoResponse createResponse(List<Long> ids, Map<String, Object> searchContext) throws Exception {
        BrkInfoResponse result = new BrkInfoResponse();
        Boolean at = (Boolean)searchContext.get("SubjectsToevoegen");
        if (at != null && at.booleanValue() && (at = (Boolean)searchContext.get("GevoeligeInfoOphalen")) != null && at.booleanValue()) {
            result.setBevatGevoeligeInfo(Boolean.valueOf(true));
        }
        result.setTimestamp(new Date());
        for (Long id : ids) {
            KadOnrndZkInfoResponse koz = KadOnrndZkInfoResponse.getRecord((Long)id, searchContext);
            result.addKadOnrndZk(koz);
        }
        return result;
    }
}

