/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.brmo.soap.eigendom.BenoemdObjecten;
import nl.b3p.brmo.soap.eigendom.Brondocumenten;
import nl.b3p.brmo.soap.eigendom.EigendomMutatie;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieException;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieRequest;
import nl.b3p.brmo.soap.eigendom.EigendomMutatieResponse;
import nl.b3p.brmo.soap.eigendom.HistorischeRelaties;
import nl.b3p.brmo.soap.eigendom.MutatieEntry;
import nl.b3p.brmo.soap.eigendom.MutatieListRequest;
import nl.b3p.brmo.soap.eigendom.MutatieListResponse;
import nl.b3p.brmo.soap.eigendom.ZakelijkeRechten;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.io.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class EigendomInfo {
    private static final Log LOG = LogFactory.getLog(EigendomInfo.class);
    private static final String DB_POSTGRES = "postgres";
    private static final String DB_ORACLE = "oracle";
    private static final String DB_MSSQL = "mssql";
    private static final String ID = "id";
    private static final String FROMDATE = "fromDate";
    private static final String TODATE = "toDate";
    private static final String OBJECT_PREFIX = "objectPrefix";
    private static final String IDENTIFICATIE = "identificatie";
    private static final String NAMESPACE = "namespace";
    public static final String MAXAANTALRESULTATEN = "MaxAantalResultaten";
    public static final Integer DBMAXRESULTS = 10000;

    public static EigendomMutatieResponse createEigendomMutatieResponse(Map<String, Object> eigendomMutatieContext) throws EigendomMutatieException {
        EigendomMutatieResponse eir = new EigendomMutatieResponse();
        try {
            ArrayList entries = EigendomInfo.findEigendomMutatie(eigendomMutatieContext);
            for (EigendomMutatie e : entries) {
                eir.getEigendomMutatie().add(e);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"EigendomMutatie opzoeken is mislukt.", (Throwable)ex);
        }
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            eir.setTimestamp(now);
        }
        catch (DatatypeConfigurationException ex) {
            LOG.error((Object)"Datatype configuratie fout tijdens instellen datum.", (Throwable)ex);
        }
        return eir;
    }

    public static MutatieListResponse createMutatieListResponse(Map<String, Object> mutatieListContext) throws EigendomMutatieException {
        MutatieListResponse mlr = new MutatieListResponse();
        try {
            ArrayList entries = EigendomInfo.findMutatieEntries(mutatieListContext);
            for (MutatieEntry e : entries) {
                mlr.getMutatieEntry().add(e);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"MutatieEntry opzoeken is mislukt.", (Throwable)ex);
        }
        XMLGregorianCalendar now = null;
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            now = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            mlr.setTimestamp(now);
        }
        catch (DatatypeConfigurationException ex) {
            LOG.error((Object)"Datatype configuratie fout tijdens instellen datum.", (Throwable)ex);
        }
        return mlr;
    }

    public static Map<String, Object> createMutatieListContext(MutatieListRequest request) throws EigendomMutatieException {
        HashMap<String, Object> searchContext = new HashMap<String, Object>();
        if (request == null) {
            return searchContext;
        }
        if (request.getFromDate() != null) {
            Timestamp fromDate = null;
            XMLGregorianCalendar xmlFromDate = request.getFromDate();
            if (xmlFromDate != null) {
                fromDate = new Timestamp(xmlFromDate.toGregorianCalendar().getTimeInMillis());
            }
            searchContext.put("fromDate", fromDate);
        }
        if (request.getToDate() != null) {
            Timestamp toDate = null;
            XMLGregorianCalendar xmlToDate = request.getToDate();
            if (xmlToDate != null) {
                toDate = new Timestamp(xmlToDate.toGregorianCalendar().getTimeInMillis());
            }
            searchContext.put("toDate", toDate);
        }
        if (request.getObjectprefix() != null) {
            String objectprefix = request.getObjectprefix();
            searchContext.put("objectPrefix", objectprefix);
        }
        return searchContext;
    }

    public static Map<String, Object> createEigendomMutatieContext(EigendomMutatieRequest request) throws EigendomMutatieException {
        String[] sa;
        HashMap<String, Object> searchContext = new HashMap<String, Object>();
        if (request == null) {
            return searchContext;
        }
        if (request.getIdentificatie() != null) {
            sa = request.getIdentificatie().split(":");
            if (sa.length != 2) {
                throw new EigendomMutatieException("Ongeldige invoer", "De identificatie moet bestaan uit een getal met een namespace gescheiden door ':', zoals VBO:0000001!");
            }
            if (!sa[0].equalsIgnoreCase("VBO") && !sa[0].equalsIgnoreCase("NL.KAD.OnroerendeZaak")) {
                throw new EigendomMutatieException("Ongeldige invoer", "Geldige namespaces zijn: VBO en NL.KAD.OnroerendeZaak");
            }
            searchContext.put("namespace", sa[0]);
        } else {
            throw new EigendomMutatieException("Ongeldige invoer", "Voor het opvragen is een identificatie vereist!");
        }
        searchContext.put("identificatie", sa[1]);
        if (request.getMaxAantalResultaten() != null) {
            Integer maxNum = request.getMaxAantalResultaten();
            if (maxNum > 100) {
                throw new EigendomMutatieException("Ongeldige invoer", "Er kunnen maximaal 100 objecten opgevraagd worden");
            }
            searchContext.put("MaxAantalResultaten", maxNum);
        }
        return searchContext;
    }

    /*
     * Exception decompiling
     */
    private static ArrayList<MutatieEntry> findMutatieEntries(Map<String, Object> searchContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ArrayList<EigendomMutatie> findEigendomMutatie(Map<String, Object> searchContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Brondocumenten findBrondocumenten(String value) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static BenoemdObjecten findBenoemdObjecten(String vo_id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static HistorischeRelaties findHistorischeRelaties(long value) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZakelijkeRechten findZakelijkeRechten(long kad_id) throws Exception {
        ZakelijkeRechten zrn = new ZakelijkeRechten();
        EigendomInfo.addZakelijkeRechten((ZakelijkeRechten)zrn, (long)kad_id, null);
        long grondperceel_kad_id = 0L;
        DataSource ds = ConfigUtil.getDataSourceRsgb();
        PreparedStatement stm = null;
        ResultSet rs = null;
        try (Connection conn = ds.getConnection();){
            String dbType = EigendomInfo.getDbType((Connection)conn);
            StringBuilder resultNames = new StringBuilder();
            resultNames.append(" gpa.perceel_identif as perceel_identif ");
            StringBuilder fromSQL = new StringBuilder(" mb_util_app_re_kad_perceel gpa ");
            if (dbType.equalsIgnoreCase("mssql")) {
                fromSQL = new StringBuilder(" vb_util_app_re_kad_perceel gpa ");
            }
            StringBuilder whereSQL = new StringBuilder(" gpa.app_re_identif = ? ");
            StringBuilder sql = EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, null, (String)dbType);
            LOG.trace((Object)sql);
            LOG.trace((Object)kad_id);
            stm = conn.prepareStatement(sql.toString());
            stm.setString(1, Long.toString(kad_id));
            rs = stm.executeQuery();
            if (rs.next()) {
                grondperceel_kad_id = rs.getLong("perceel_identif");
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(stm);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stm);
        if (grondperceel_kad_id != 0L) {
            EigendomInfo.addZakelijkeRechten((ZakelijkeRechten)zrn, (long)grondperceel_kad_id, (String)"grondperceel");
        }
        return zrn;
    }

    /*
     * Exception decompiling
     */
    private static ZakelijkeRechten addZakelijkeRechten(ZakelijkeRechten zrn, long kad_id, String type) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StringBuilder createSelectRsgbSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = (Integer)searchContext.get("MaxAantalResultaten");
        if (maxrows == null) {
            maxrows = DBMAXRESULTS;
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        } else if (maxrows > DBMAXRESULTS) {
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        }
        maxrows = maxrows + 1;
        StringBuilder resultNames = new StringBuilder();
        resultNames.append("koz.kad_identif as kad_identif, ");
        resultNames.append("ar.ka_appartementsindex as app_appartementsindex, ");
        resultNames.append("ar.ka_kad_gemeentecode as app_gemeentecode, ");
        resultNames.append("ar.sc_kad_identif as app_identif, ");
        resultNames.append("ar.ka_perceelnummer as app_perceelnummer, ");
        resultNames.append("ar.ka_sectie as app_sectie, ");
        resultNames.append("kp.ka_kad_gemeentecode as perceel_gemeentecode, ");
        resultNames.append("kp.sc_kad_identif as perceel_identif, ");
        resultNames.append("kp.ka_perceelnummer as perceel_perceelnummer, ");
        resultNames.append("kp.ka_sectie as perceel_sectie, ");
        resultNames.append("vo.sc_identif as vo_identif");
        StringBuilder fromSQL = new StringBuilder(" kad_onrrnd_zk koz ");
        fromSQL.append("LEFT OUTER JOIN kad_perceel kp ");
        fromSQL.append("ON ( koz.kad_identif = kp.sc_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN app_re ar ");
        fromSQL.append("ON ( koz.kad_identif = ar.sc_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN benoemd_obj_kad_onrrnd_zk bokoz ");
        fromSQL.append("ON ( koz.kad_identif = bokoz.fk_nn_rh_koz_kad_identif) ");
        fromSQL.append("LEFT OUTER JOIN verblijfsobj vo ");
        fromSQL.append("ON ( bokoz.fk_nn_lh_tgo_identif = vo.sc_identif) ");
        StringBuilder whereSQL = EigendomInfo.createWhereRsgbSQL(searchContext);
        return EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, searchContext, (String)dbType);
    }

    private static StringBuilder createSelectStagingSQL(Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = (Integer)searchContext.get("MaxAantalResultaten");
        if (maxrows == null) {
            maxrows = DBMAXRESULTS;
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        } else if (maxrows > DBMAXRESULTS) {
            searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
        }
        maxrows = maxrows + 1;
        StringBuilder resultNames = new StringBuilder();
        resultNames.append(" b.object_ref as object_ref, ");
        resultNames.append(" b.datum as datum, ");
        resultNames.append(" b.volgordenummer as volgordenummer, ");
        resultNames.append(" b.status_datum as status_datum");
        StringBuilder fromSQL = new StringBuilder(" bericht b ");
        StringBuilder whereSQL = EigendomInfo.createWhereStagingSQL(searchContext);
        return EigendomInfo.createSelectSQL((StringBuilder)resultNames, (StringBuilder)fromSQL, (StringBuilder)whereSQL, searchContext, (String)dbType);
    }

    private static StringBuilder createSelectSQL(StringBuilder resultNames, StringBuilder fromSQL, StringBuilder whereSQL, Map<String, Object> searchContext, String dbType) throws ParseException {
        Integer maxrows = DBMAXRESULTS;
        if (searchContext != null) {
            maxrows = (Integer)searchContext.get("MaxAantalResultaten");
            if (maxrows == null) {
                maxrows = DBMAXRESULTS;
                searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
            } else if (maxrows > DBMAXRESULTS) {
                searchContext.put("MaxAantalResultaten", DBMAXRESULTS);
            }
        }
        maxrows = maxrows + 1;
        StringBuilder sql = new StringBuilder();
        switch (dbType) {
            case "postgres": {
                sql.append(" SELECT ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                sql.append(" LIMIT ");
                sql.append(maxrows);
                return sql;
            }
            case "oracle": {
                sql.append(" SELECT ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                StringBuilder tempSql = new StringBuilder();
                tempSql.append(" SELECT * FROM ( ");
                tempSql.append((CharSequence)sql);
                tempSql.append(" ) WHERE ROWNUM <= ");
                tempSql.append(maxrows);
                sql = tempSql;
                return sql;
            }
            case "mssql": {
                sql.append(" SELECT ");
                sql.append(" TOP ");
                sql.append(" ( ");
                sql.append(maxrows);
                sql.append(" ) ");
                sql.append((CharSequence)resultNames);
                sql.append(" FROM ");
                sql.append((CharSequence)fromSQL);
                sql.append(" WHERE ");
                sql.append((CharSequence)whereSQL);
                return sql;
            }
        }
        throw new UnsupportedOperationException("Unknown database!");
    }

    private static StringBuilder createWhereRsgbSQL(Map<String, Object> searchContext) throws ParseException {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        String condition = null;
        if (searchContext.get("namespace").equals("VBO")) {
            condition = "    vo.sc_identif = ? ";
        } else if (searchContext.get("namespace").equals("NL.KAD.OnroerendeZaak")) {
            condition = "    koz.kad_identif = ? ";
            Long i = null;
            if (searchContext.get("identificatie") instanceof String) {
                String id = (String)searchContext.get("identificatie");
                try {
                    i = Long.parseLong(id);
                }
                catch (NumberFormatException nfe) {
                    LOG.error((Object)"Identificatie is geen nummer. ", (Throwable)nfe);
                }
                searchContext.put("identificatie", i);
            }
        }
        EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("identificatie"), (StringBuilder)sql, (String)condition);
        return sql;
    }

    private static StringBuilder createWhereStagingSQL(Map<String, Object> searchContext) throws ParseException {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        String condition = "    b.object_ref like ? ";
        first = EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("objectPrefix"), (StringBuilder)sql, (String)condition);
        condition = "    b.status_datum >= ? ";
        first = EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("fromDate"), (StringBuilder)sql, (String)condition);
        condition = "    b.status_datum <= ? ";
        EigendomInfo.addTerm((boolean)first, (Object)searchContext.get("toDate"), (StringBuilder)sql, (String)condition);
        return sql;
    }

    private static boolean addTerm(boolean first, Object o, StringBuilder sql, String condition) {
        if (!(o == null || o instanceof String && ((String)o).isEmpty())) {
            if (!first) {
                sql.append("AND ");
            }
            sql.append(condition);
            first = false;
        }
        return first;
    }

    private static PreparedStatement addParamsSQL(PreparedStatement stm, Map<String, Object> searchContext) throws SQLException {
        int index = 1;
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("objectPrefix"), (PreparedStatement)stm);
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("fromDate"), (PreparedStatement)stm);
        index = EigendomInfo.addParam((int)index, (Object)searchContext.get("toDate"), (PreparedStatement)stm);
        EigendomInfo.addParam((int)index, (Object)searchContext.get("identificatie"), (PreparedStatement)stm);
        return stm;
    }

    private static int addParam(int index, Object o, PreparedStatement stm) throws SQLException {
        if (!(o == null || o instanceof String && ((String)o).isEmpty())) {
            if (o instanceof String) {
                stm.setString(index++, "" + (String)o + "%");
            } else if (o instanceof Timestamp) {
                stm.setTimestamp(index++, (Timestamp)o);
            } else {
                stm.setObject(index++, o);
            }
        }
        return index;
    }

    private static String getDbType(Connection conn) throws SQLException {
        String databaseProductName = conn.getMetaData().getDatabaseProductName();
        if (databaseProductName.contains("PostgreSQL")) {
            return "postgres";
        }
        if (databaseProductName.contains("Oracle")) {
            return "oracle";
        }
        if (databaseProductName.contains("Microsoft")) {
            return "mssql";
        }
        throw new UnsupportedOperationException("Unknown database: " + conn.getMetaData().getDatabaseProductName());
    }
}

